/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.length.nautical;

import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormatI18n;

public enum NauticalLengthFormat {
    M{

        @Override
        public Float toM(Float value) {
            return value;
        }

        @Override
        public Float toKM(Float value) {
            return Float.valueOf(1.meterToKiloMeter(value));
        }

        @Override
        public Float toNM(Float value) {
            return Float.valueOf(1.meterToKiloMeter(Float.valueOf(1.kiloMeterToMile(value))));
        }

        @Override
        public Float toFTM(Float value) {
            return Float.valueOf(1.meterToBrass(value));
        }
    }
    ,
    KM{

        @Override
        public Float toM(Float value) {
            return Float.valueOf(2.kiloMeterToMeter(value));
        }

        @Override
        public Float toKM(Float value) {
            return value;
        }

        @Override
        public Float toNM(Float value) {
            return Float.valueOf(2.kiloMeterToMile(value));
        }

        @Override
        public Float toFTM(Float value) {
            return Float.valueOf(2.meterToBrass(Float.valueOf(2.kiloMeterToMeter(value))));
        }
    }
    ,
    NM{

        @Override
        public Float toM(Float value) {
            return Float.valueOf(3.kiloMeterToMeter(Float.valueOf(3.mileToKiloMeter(value))));
        }

        @Override
        public Float toKM(Float value) {
            return Float.valueOf(3.mileToKiloMeter(value));
        }

        @Override
        public Float toNM(Float value) {
            return value;
        }

        @Override
        public Float toFTM(Float value) {
            return Float.valueOf(3.meterToBrass(Float.valueOf(3.kiloMeterToMeter(Float.valueOf(3.mileToKiloMeter(value))))));
        }
    }
    ,
    FTM{

        @Override
        public Float toM(Float value) {
            return Float.valueOf(4.brassToMeter(value));
        }

        @Override
        public Float toKM(Float value) {
            return Float.valueOf(4.meterToKiloMeter(Float.valueOf(4.brassToMeter(value))));
        }

        @Override
        public Float toNM(Float value) {
            return Float.valueOf(4.kiloMeterToMile(Float.valueOf(4.meterToKiloMeter(Float.valueOf(4.brassToMeter(value))))));
        }

        @Override
        public Float toFTM(Float value) {
            return value;
        }
    };

    public static final float BRASS_TO_METER_RATIO = 1.8288f;
    public static final float KILOMETER_TO_METER_RATIO = 1000.0f;
    public static final float MILE_TO_KILOMETER_RATIO = 1.852f;

    public final Float convert(NauticalLengthFormat targetFormat, Float value) {
        if (value == null) {
            return null;
        }
        switch (targetFormat) {
            case M: {
                return this.toM(value);
            }
            case KM: {
                return this.toKM(value);
            }
            case NM: {
                return this.toNM(value);
            }
            case FTM: {
                return this.toFTM(value);
            }
        }
        throw new IllegalStateException();
    }

    public abstract Float toM(Float var1);

    public abstract Float toKM(Float var1);

    public abstract Float toNM(Float var1);

    public abstract Float toFTM(Float var1);

    public String getLabel() {
        return NauticalLengthFormatI18n.getLabel(this);
    }

    public String getDescription() {
        return NauticalLengthFormatI18n.getDescription(this);
    }

    public static float brassToMeter(Float value) {
        return value.floatValue() * 1.8288f;
    }

    public static float meterToBrass(Float value) {
        return value.floatValue() / 1.8288f;
    }

    public static float kiloMeterToMeter(Float value) {
        return value.floatValue() * 1000.0f;
    }

    public static float meterToKiloMeter(Float value) {
        return value.floatValue() / 1000.0f;
    }

    public static float mileToKiloMeter(Float value) {
        return value.floatValue() * 1.852f;
    }

    public static float kiloMeterToMile(Float value) {
        return value.floatValue() / 1.852f;
    }
}

