/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.length.nautical;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditor;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorConfig;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorModel;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormat;
import java.util.Objects;
import javax.swing.JLabel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;

public class NauticalLengthEditorHandler
extends BeanUIHandlerSupport<NauticalLengthEditor>
implements UIHandler<NauticalLengthEditor> {
    private static final Logger log = LogManager.getLogger(NauticalLengthEditorHandler.class);

    @Override
    public void beforeInit(NauticalLengthEditor ui) {
        super.beforeInit(ui);
        NauticalLengthEditorModel model = new NauticalLengthEditorModel();
        model.setFormat(NauticalLengthFormat.M);
        ui.setContextValue(model);
    }

    @Override
    protected String getProperty(NauticalLengthEditor ui) {
        NauticalLengthEditorModel model = ui.getModel();
        if (model == null) {
            return null;
        }
        NauticalLengthEditorConfig config = model.getConfig();
        if (config == null) {
            return null;
        }
        return config.getProperty();
    }

    public void init(NauticalLengthEditor ui, JLabel label) {
        Objects.requireNonNull(label, "No label, can't init.");
        this.init(ui);
        NauticalLengthEditorModel model = ui.getModel();
        model.addPropertyChangeListener("format", evt -> label.setText(model.getLabel()));
        label.setText(model.getLabel());
    }

    @Override
    protected void prepareInit(String property) {
        log.debug(String.format("%s - init NauticalLengthEditor", ((NauticalLengthEditor)this.ui).getName()));
        NauticalLengthEditorModel model = ((NauticalLengthEditor)this.ui).getModel();
        NauticalLengthEditorConfig config = model.getConfig();
        Objects.requireNonNull(config, "No config in editor, can't init.");
        if (property == null || property.isEmpty()) {
            config.setProperty(((NauticalLengthEditor)this.ui).getName());
        }
        ((NauticalLengthEditor)this.ui).getEditor().init();
        ((NauticalLengthEditor)this.ui).getEditor().getModel().addPropertyChangeListener("numberValue", evt -> model.setNauticalLength((Float)evt.getNewValue()));
    }

    @Override
    protected void prepareBindFromBean(String property, JavaBean bean) {
        NauticalLengthEditorModel model = ((NauticalLengthEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Float newValue;
            Float oldValue = model.getStorageNauticalLength();
            if (!Objects.equals(oldValue, newValue = (Float)e.getNewValue())) {
                log.debug(String.format("%s - [%s] get new value from bean: %s", ((NauticalLengthEditor)this.ui).getName(), property, newValue));
                ((NauticalLengthEditor)this.ui).setStorageNauticalLength(newValue);
            }
        });
    }

    @Override
    protected void prepareBindToBean(String property, JavaBean bean) {
        NauticalLengthEditorModel model = ((NauticalLengthEditor)this.ui).getModel();
        model.addPropertyChangeListener("storageNauticalLength", evt -> {
            Float newValue = (Float)evt.getNewValue();
            if (!Objects.equals(newValue, bean.get(property))) {
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((NauticalLengthEditor)this.ui).getName(), property, newValue));
                bean.set(property, (Object)newValue);
            }
        });
    }
}

