/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBox;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;

public class JaxxComboBoxCellEditor
extends DefaultCellEditor
implements TableCellEditor,
AncestorListener {
    public <O extends JavaBean> JaxxComboBoxCellEditor(final JaxxComboBox<O> editor) {
        super(editor.getCombobox());
        this.editorComponent = editor;
        final JComboBox<O> comboBox = editor.getCombobox();
        this.editorComponent.setOpaque(false);
        comboBox.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value != null && !(value instanceof JavaBean)) {
                    value = null;
                }
                editor.setSelectedItem((JavaBean)value);
            }

            @Override
            public Object getCellEditorValue() {
                return editor.getModel().getSelectedItem();
            }

            @Override
            public boolean stopCellEditing() {
                if (comboBox.isEditable()) {
                    Object cellEditorValue = this.getCellEditorValue();
                    Object item = comboBox.getEditor().getItem();
                    if (item != null && !editor.getConfig().getBeanType().isAssignableFrom(item.getClass()) && cellEditorValue == null && !"".equals(item)) {
                        editor.setSelectedItem(null);
                    }
                }
                return super.stopCellEditing();
            }
        };
        ((JComponent)comboBox.getEditor().getEditorComponent()).addAncestorListener(this);
        comboBox.addActionListener(this.delegate);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.editorComponent.requestFocusInWindow();
            ((JaxxComboBox)((Object)((Object)this.editorComponent))).getCombobox().getEditor().selectAll();
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    public JaxxComboBox<?> getComponent() {
        return (JaxxComboBox)((Object)super.getComponent());
    }
}

