/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.decoration.Decorated;
import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.BeanUIUtil;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBox;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxConfig;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxEditor;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxModel;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxRenderer;
import io.ultreia.java4all.jaxx.widgets.combobox.JaxxComboBoxHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;

public class FilterableComboBoxHandler<O extends JavaBean>
implements PropertyChangeListener,
UIHandler<FilterableComboBox<O>> {
    public static final Logger log = LogManager.getLogger(JaxxComboBoxHandler.class);
    protected FilterableComboBox<O> ui;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return FilterableComboBoxHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return FilterableComboBoxHandler.this.ui.getDisplayDecorator();
        }
    };
    protected boolean init;
    private JComboBox<O> combobox;
    private FilterableComboBoxModel<O> model;
    private FilterableComboBoxEditor<O> editor;
    private FilterableComboBoxConfig<O> config;

    public void beforeInit(FilterableComboBox<O> ui) {
        this.ui = ui;
    }

    public void afterInit(FilterableComboBox<O> ui) {
        this.model = ui.getModel();
        this.config = this.model.getConfig();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedItem".equals(propertyName)) {
            this.setSelectedItem((JavaBean)this.ui.getBeanType().cast(evt.getOldValue()), (JavaBean)this.ui.getBeanType().cast(evt.getNewValue()));
            return;
        }
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(null, this.model.getIndex());
            List list = (List)evt.getOldValue();
            this.model.fireEmpty(list == null || list.isEmpty());
        }
    }

    public void init(Decorator decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        this.config.setDecorator(Objects.requireNonNull(decorator, String.format("decorator can not be null (for type %s)", this.ui.getBeanType())).copy());
        if (this.config.getBeanType() == null) {
            this.config.setBeanType(decorator.definition().type());
        }
        this.combobox = this.ui.getCombobox();
        this.editor = new FilterableComboBoxEditor<O>(this.ui.getModel(), this.ui.getCombobox());
        this.combobox.setRenderer(new FilterableComboBoxRenderer(this.editor::getFilterText));
        this.popupHandler.preparePopup(this.config.getSelectedToolTipText(), this.config.getNotSelectedToolTipText(), this.config.getI18nPrefix(), this.config.getPopupTitleText(), (ButtonGroup)this.ui.getIndexes(), this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.config.getDecorator());
        this.model.addPropertyChangeListener(this);
        this.model.setData(data);
        this.ui.getIndexes().setSelectedButton((Object)this.model.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void reset() {
        this.model.setSelectedItem(null);
        this.combobox.setSelectedItem(null);
        if (this.combobox.isShowing()) {
            this.combobox.hidePopup();
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || Objects.equals(newValue, oldValue)) {
            return;
        }
        log.debug(String.format("%s \u2192 change index state : <%d to %d>", this.ui.getName(), oldValue, newValue));
        AbstractButton button = this.ui.getIndexes().getButton((Object)newValue);
        if (button != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.model.getReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || Objects.equals(newValue, oldValue)) {
            return;
        }
        log.debug(String.format("%s \u2192 change reverse sort state : <%s to %s>", this.ui.getName(), oldValue, newValue));
        this.updateUI(this.model.getIndex(), newValue);
    }

    protected void setSelectedItem(O oldValue, O newValue) {
        if (oldValue == null && newValue == null) {
            return;
        }
        if (!this.config.getBeanType().isInstance(newValue)) {
            newValue = null;
        }
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if (newValue != null && this.config.isBeanDecoratorAware()) {
            ((Decorated)newValue).registerDecorator(this.config.getDecorator());
        }
        log.debug(String.format("%s \u2192 change selected item state <%s to %s>", this.ui.getName(), oldValue, newValue));
        this.model.mutateBeanProperty(newValue);
    }

    private void updateUI(int index, boolean reverseSort) {
        Decorator decorator = this.config.getDecorator();
        decorator.setIndex(index);
        Object previousSelectedItem = this.model.getSelectedItem();
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.model.selectedItem = null;
        }
        List<O> data = this.model.getData();
        if (this.config.isBeanDecoratorAware()) {
            data.forEach(datum -> ((Decorated)datum).registerDecorator(decorator));
            if (previousSelectedItem != null) {
                ((Decorated)previousSelectedItem).registerDecorator(decorator);
            }
        }
        if (this.config.isSortable() && data != null && !data.isEmpty()) {
            try {
                decorator.sort(data, index, reverseSort);
            }
            catch (Exception eee) {
                log.warn(eee.getMessage(), (Throwable)eee);
            }
        }
        this.editor.updateComboBoxModel(data, previousSelectedItem == null ? null : () -> previousSelectedItem);
        this.model.selectedItem = previousSelectedItem;
    }
}

