/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.combobox;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.combobox.FilterableComboBoxModel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class FilterableComboBoxEditor<T extends JavaBean>
extends BasicComboBoxEditor {
    private static final Logger log = LogManager.getLogger(FilterableComboBoxEditor.class);
    private final FilterableComboBoxModel<T> model;
    private final JComboBox<T> comboBox;
    private String filterText = "";
    private Object selected;
    private boolean editing;
    private boolean filterMatch;

    public FilterableComboBoxEditor(FilterableComboBoxModel<T> model, JComboBox<T> comboBox) {
        this.model = Objects.requireNonNull(model);
        this.comboBox = Objects.requireNonNull(comboBox);
        this.editor = new CustomTextField();
        EditorHandler editorHandler = new EditorHandler();
        this.editor.addFocusListener(editorHandler);
        this.editor.addKeyListener(editorHandler);
        this.editor.addMouseListener(editorHandler);
        comboBox.addPopupMenuListener(editorHandler);
        comboBox.setEditor(this);
        comboBox.setEditable(true);
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void updateComboBoxModel(List<T> filteredItems, Supplier<T> selectedValue) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
        model.removeAllElements();
        model.addAll(filteredItems);
        if (selectedValue != null) {
            model.setSelectedItem(selectedValue.get());
        }
    }

    @Override
    public CustomTextField getEditorComponent() {
        return (CustomTextField)super.getEditorComponent();
    }

    @Override
    public Object getItem() {
        return this.selected;
    }

    @Override
    public void setItem(Object anObject) {
        log.info(String.format("FilterableComboBoxEditor set item (editing %s with text: %s): %s", this.editing, this.filterText, anObject));
        this.getEditorComponent().updateText(this.editing, this.filterText, anObject);
        this.selected = anObject;
    }

    @Override
    protected JTextField createEditorComponent() {
        return null;
    }

    private void resetFilterComponent() {
        if (!this.editing) {
            return;
        }
        this.getEditorComponent().resetForegroundColor();
        this.filterText = "";
        this.editing = false;
        this.filterMatch = false;
        this.updateComboBoxModel(this.model.getData(), this.model::getSelectedItem);
    }

    private void updateSelectedItemFromComboBox() {
        JavaBean selectedItem = (JavaBean)this.comboBox.getSelectedItem();
        this.model.setSelectedItem(selectedItem);
    }

    private void applyFilter() {
        log.info("Apply filter with: " + this.filterText);
        List<T> filteredItems = this.model.updateFilteredData(this.filterText);
        this.filterMatch = !filteredItems.isEmpty();
        this.getEditorComponent().updateForegroundColor(this.filterMatch);
        this.updateComboBoxModel(filteredItems, () -> this.filterMatch ? (JavaBean)filteredItems.get(0) : null);
    }

    private void cancelEditing() {
        T selectedItem = this.model.getSelectedItem();
        log.info(String.format("Cancel editing, restore model value: %s", selectedItem));
        this.resetFilterComponent();
        this.comboBox.setSelectedItem(selectedItem);
        this.setItem(selectedItem);
    }

    private class EditorHandler
    implements KeyListener,
    FocusListener,
    PopupMenuListener,
    MouseListener {
        private boolean wasCanceled;

        private EditorHandler() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.wasCanceled = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.wasCanceled) {
                return;
            }
            if (FilterableComboBoxEditor.this.editing && !FilterableComboBoxEditor.this.filterMatch) {
                return;
            }
            Object selectedItem = FilterableComboBoxEditor.this.comboBox.getSelectedItem();
            Object modelSelectedItem = FilterableComboBoxEditor.this.model.getSelectedItem();
            if (!Objects.equals(modelSelectedItem, selectedItem)) {
                log.info("popupMenuWillBecomeInvisible::need to set new selected item: " + selectedItem);
                FilterableComboBoxEditor.this.updateSelectedItemFromComboBox();
                FilterableComboBoxEditor.this.resetFilterComponent();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.wasCanceled = true;
            FilterableComboBoxEditor.this.cancelEditing();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            FilterableComboBoxEditor.this.resetFilterComponent();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (e.isControlDown()) {
                return;
            }
            switch (keyCode) {
                case 10: {
                    if (!FilterableComboBoxEditor.this.comboBox.isPopupVisible()) {
                        FilterableComboBoxEditor.this.comboBox.showPopup();
                        e.consume();
                        return;
                    }
                    FilterableComboBoxEditor.this.updateSelectedItemFromComboBox();
                    FilterableComboBoxEditor.this.resetFilterComponent();
                    e.consume();
                    FilterableComboBoxEditor.this.comboBox.hidePopup();
                    return;
                }
                case 9: {
                    if (FilterableComboBoxEditor.this.filterMatch || !FilterableComboBoxEditor.this.editing) {
                        FilterableComboBoxEditor.this.updateSelectedItemFromComboBox();
                    }
                    FilterableComboBoxEditor.this.resetFilterComponent();
                    if (FilterableComboBoxEditor.this.comboBox.isPopupVisible()) {
                        FilterableComboBoxEditor.this.comboBox.hidePopup();
                    }
                    if (e.isShiftDown()) {
                        this.focusPreviousComponent();
                        break;
                    }
                    this.focusNextComponent();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (!Character.isDefined(keyChar)) {
                return;
            }
            if (e.isControlDown()) {
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 9: 
                case 10: 
                case 27: 
                case 127: {
                    return;
                }
                case 8: {
                    this.removeCharAtEnd();
                    break;
                }
                default: {
                    this.addChar(keyChar);
                    e.consume();
                }
            }
            if (FilterableComboBoxEditor.this.editing) {
                if (!FilterableComboBoxEditor.this.comboBox.isPopupVisible()) {
                    FilterableComboBoxEditor.this.comboBox.showPopup();
                }
                FilterableComboBoxEditor.this.applyFilter();
            }
        }

        private void focusPreviousComponent() {
            JXTable table = (JXTable)FilterableComboBoxEditor.this.comboBox.getClientProperty("Table");
            if (table != null) {
                table.getActionForKeyStroke(KeyStroke.getKeyStroke("shift pressed TAB")).actionPerformed(null);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        }

        private void focusNextComponent() {
            JXTable table = (JXTable)FilterableComboBoxEditor.this.comboBox.getClientProperty("Table");
            if (table != null) {
                table.getActionForKeyStroke(KeyStroke.getKeyStroke("pressed TAB")).actionPerformed(null);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        }

        public void addChar(char c) {
            FilterableComboBoxEditor.this.filterText = FilterableComboBoxEditor.this.filterText + c;
            FilterableComboBoxEditor.this.editing = true;
        }

        public void removeCharAtEnd() {
            if (FilterableComboBoxEditor.this.filterText.length() > 0) {
                FilterableComboBoxEditor.this.filterText = FilterableComboBoxEditor.this.filterText.substring(0, FilterableComboBoxEditor.this.filterText.length() - 1);
                FilterableComboBoxEditor.this.editing = true;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (FilterableComboBoxEditor.this.comboBox.isEnabled() && !FilterableComboBoxEditor.this.comboBox.isPopupVisible()) {
                FilterableComboBoxEditor.this.comboBox.showPopup();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    static class CustomTextField
    extends JTextField {
        private final Color defaultForeground;

        public CustomTextField() {
            UIDefaults defaults = new UIDefaults();
            defaults.put("TextField.contentMargins", new Insets(2, 6, 2, 6));
            this.putClientProperty("Nimbus.Overrides", defaults);
            this.defaultForeground = UIManager.getColor("ComboBox.foreground");
            this.setFocusTraversalKeysEnabled(false);
        }

        public void resetForegroundColor() {
            this.setForeground(this.defaultForeground);
        }

        @Override
        public void setText(String s) {
            if (Objects.equals(this.getText(), s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
            if (!(b instanceof BasicComboBoxEditor.UIResource)) {
                super.setBorder(b);
            }
        }

        public void updateForegroundColor(boolean filterMatch) {
            this.setForeground(filterMatch ? this.defaultForeground : Color.RED);
        }

        public void updateText(boolean editing, String text, Object anObject) {
            if (editing) {
                log.info(String.format("updateFilterLabelText: search: %s vs %s", text, this.getText()));
                this.setText(text);
            } else {
                this.setText(anObject == null ? null : anObject.toString());
            }
        }
    }
}

