/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation.validator;

import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.jaxx.widgets.validation.JaxxWidgetsValidationContext;
import io.ultreia.java4all.validation.core.api.NuitonValidationContext;
import io.ultreia.java4all.validation.core.impl.ValidationMessagesCollector;
import io.ultreia.java4all.validation.core.impl.field.FieldValidatorSupport;
import java.util.Map;
import java.util.function.Function;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorModel;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

public class TemperatureBoundFieldValidator<O>
extends FieldValidatorSupport<O, Float> {
    private final TemperatureFormat defaultTemperatureFormat;
    private final Float min;
    private final Float max;

    public TemperatureBoundFieldValidator(String fieldName, Function<O, Float> fieldFunction, TemperatureFormat defaultTemperatureFormat, Float min, Float max) {
        super(fieldName, fieldFunction);
        this.defaultTemperatureFormat = defaultTemperatureFormat;
        this.min = min;
        this.max = max;
    }

    public void validate(O object, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        TemperatureEditorModel temperatureEditorModel;
        if (this.min == null) {
            throw new IllegalStateException("No parameter 'min' filled");
        }
        if (this.max == null) {
            throw new IllegalStateException("No parameter 'max' filled");
        }
        if (this.min.floatValue() >= this.max.floatValue()) {
            throw new IllegalStateException(String.format("No parameter 'min' (%s) is greater than 'max' (%s)", this.min, this.max));
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            throw new IllegalStateException("No parameter 'fieldName' filled");
        }
        Float temperature = (Float)this.getField(object);
        if (temperature == null) {
            return;
        }
        Map<String, TemperatureEditorModel> map = ((JaxxWidgetsValidationContext)validationContext).getTemperatureEditorModels();
        TemperatureFormat temperatureFormat = this.defaultTemperatureFormat;
        if (map != null && (temperatureEditorModel = map.get(fieldName)) != null) {
            temperatureFormat = temperatureEditorModel.getFormat();
        }
        if (temperature.floatValue() < this.min.floatValue() || temperature.floatValue() > this.max.floatValue()) {
            float max;
            float min;
            if (temperatureFormat.equals((Object)this.defaultTemperatureFormat)) {
                min = this.min.floatValue();
                max = this.max.floatValue();
            } else {
                min = this.defaultTemperatureFormat.convert(this.min, temperatureFormat).floatValue();
                max = this.defaultTemperatureFormat.convert(this.max, temperatureFormat).floatValue();
            }
            TemperatureResult result = new TemperatureResult(min, max, temperatureFormat.getLabel());
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.temperature.temperature.bound", (Object[])new Object[0]), new Object[]{Float.valueOf(result.getMin()), Float.valueOf(result.getMax()), result.getFormat()});
        }
    }

    public static class TemperatureResult {
        private final float min;
        private final float max;
        private final String format;

        TemperatureResult(float min, float max, String format) {
            this.min = min;
            this.max = max;
            this.format = format;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

