/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation.validator;

import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorModel;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormat;
import io.ultreia.java4all.jaxx.widgets.validation.JaxxWidgetsValidationContext;
import io.ultreia.java4all.validation.core.api.NuitonValidationContext;
import io.ultreia.java4all.validation.core.impl.ValidationMessagesCollector;
import io.ultreia.java4all.validation.core.impl.field.FieldValidatorSupport;
import java.util.Map;
import java.util.function.Function;

public class NauticalLengthBoundFieldValidator<O>
extends FieldValidatorSupport<O, Float> {
    private final NauticalLengthFormat defaultNauticalLengthFormat;
    private final Float min;
    private final Float max;

    public NauticalLengthBoundFieldValidator(String fieldName, Function<O, Float> fieldFunction, NauticalLengthFormat defaultNauticalLengthFormat, Float min, Float max) {
        super(fieldName, fieldFunction);
        this.defaultNauticalLengthFormat = defaultNauticalLengthFormat;
        this.min = min;
        this.max = max;
    }

    public void validate(O object, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        NauticalLengthEditorModel nauticalLengthEditorModel;
        if (this.defaultNauticalLengthFormat == null) {
            throw new IllegalStateException("No parameter 'defaultNauticalLengthFormat' filled");
        }
        if (this.min == null) {
            throw new IllegalStateException("No parameter 'min' filled");
        }
        if (this.max == null) {
            throw new IllegalStateException("No parameter 'max' filled");
        }
        if (this.min.floatValue() >= this.max.floatValue()) {
            throw new IllegalStateException(String.format("No parameter 'min' (%s) is greater than 'max' (%s)", this.min, this.max));
        }
        String fieldName = this.getFieldName();
        Float nauticalLength = (Float)this.getField(object);
        if (nauticalLength == null) {
            return;
        }
        Map<String, NauticalLengthEditorModel> map = ((JaxxWidgetsValidationContext)validationContext).getNauticalLengthEditorModels();
        NauticalLengthFormat nauticalLengthFormat = this.defaultNauticalLengthFormat;
        if (map != null && (nauticalLengthEditorModel = map.get(fieldName)) != null) {
            nauticalLengthFormat = nauticalLengthEditorModel.getFormat();
        }
        if (nauticalLength.floatValue() < this.min.floatValue() || nauticalLength.floatValue() > this.max.floatValue()) {
            float max;
            float min;
            if (nauticalLengthFormat.equals((Object)this.defaultNauticalLengthFormat)) {
                min = this.min.floatValue();
                max = this.max.floatValue();
            } else {
                min = this.defaultNauticalLengthFormat.convert(nauticalLengthFormat, this.min).floatValue();
                max = this.defaultNauticalLengthFormat.convert(nauticalLengthFormat, this.max).floatValue();
            }
            NauticalLengthResult result = new NauticalLengthResult(min, max, nauticalLengthFormat.getLabel());
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.nauticalLength.nauticalLength.bound", (Object[])new Object[0]), new Object[]{Float.valueOf(result.getMin()), Float.valueOf(result.getMax()), result.getFormat()});
        }
    }

    public static class NauticalLengthResult {
        private final float min;
        private final float max;
        private final String format;

        NauticalLengthResult(float min, float max, String format) {
            this.min = min;
            this.max = max;
            this.format = format;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

