/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation.validator;

import com.google.auto.service.AutoService;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormat;
import io.ultreia.java4all.jaxx.widgets.validation.validator.CoordinateLatitudeDtoFieldValidator;
import io.ultreia.java4all.jaxx.widgets.validation.validator.CoordinateLongitudeDtoFieldValidator;
import io.ultreia.java4all.jaxx.widgets.validation.validator.NauticalLengthBoundFieldValidator;
import io.ultreia.java4all.jaxx.widgets.validation.validator.TemperatureBoundFieldValidator;
import io.ultreia.java4all.util.ImportManager;
import io.ultreia.java4all.validation.core.api.NuitonValidationContext;
import io.ultreia.java4all.validation.core.impl.definition.FieldValidatorDefinition;
import io.ultreia.java4all.validation.core.impl.definition.FileValidatorEntryDefinition;
import io.ultreia.java4all.validation.impl.spi.field.FieldValidationGenerator;
import io.ultreia.java4all.validation.impl.spi.field.FieldValidatorGeneratorSupport;
import java.util.List;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

public final class FieldValidatorGenerators {
    private FieldValidatorGenerators() {
    }

    @AutoService(value={FieldValidationGenerator.class})
    public static class TemperatureBoundFieldValidatorGenerator
    extends FieldValidatorGeneratorSupport {
        public TemperatureBoundFieldValidatorGenerator() {
            super(TemperatureBoundFieldValidator.class, true, true, false, false);
        }

        protected void generateExtraParameters(FileValidatorEntryDefinition key, FieldValidatorDefinition validatorDefinition, Class<? extends NuitonValidationContext> validationContextType, ImportManager importManager, List<String> result) throws NoSuchMethodException {
            super.generateExtraParameters(key, validatorDefinition, validationContextType, importManager, result);
            result.add(String.format("%s.%s", importManager.addImport(TemperatureFormat.class), validatorDefinition.getParameter("defaultTemperatureFormat").toUpperCase()));
            result.add(FieldValidationGenerator.escapeFloat((String)validatorDefinition.getParameter("min")));
            result.add(FieldValidationGenerator.escapeFloat((String)validatorDefinition.getParameter("max")));
        }
    }

    @AutoService(value={FieldValidationGenerator.class})
    public static class NauticalLengthBoundFieldValidatorGenerator
    extends FieldValidatorGeneratorSupport {
        public NauticalLengthBoundFieldValidatorGenerator() {
            super(NauticalLengthBoundFieldValidator.class, true, true, false, false);
        }

        protected void generateExtraParameters(FileValidatorEntryDefinition key, FieldValidatorDefinition validatorDefinition, Class<? extends NuitonValidationContext> validationContextType, ImportManager importManager, List<String> result) throws NoSuchMethodException {
            super.generateExtraParameters(key, validatorDefinition, validationContextType, importManager, result);
            result.add(String.format("%s.%s", importManager.addImport(NauticalLengthFormat.class), validatorDefinition.getParameter("defaultNauticalLengthFormat").toUpperCase()));
            result.add(FieldValidationGenerator.escapeFloat((String)validatorDefinition.getParameter("min")));
            result.add(FieldValidationGenerator.escapeFloat((String)validatorDefinition.getParameter("max")));
        }
    }

    @AutoService(value={FieldValidationGenerator.class})
    public static class CoordinateLongitudeDtoFieldValidatorGenerator
    extends FieldValidatorGeneratorSupport {
        public CoordinateLongitudeDtoFieldValidatorGenerator() {
            super(CoordinateLongitudeDtoFieldValidator.class, true, true, false, false);
        }

        protected void generateExtraParameters(FileValidatorEntryDefinition key, FieldValidatorDefinition validatorDefinition, Class<? extends NuitonValidationContext> validationContextType, ImportManager importManager, List<String> result) throws NoSuchMethodException {
            super.generateExtraParameters(key, validatorDefinition, validationContextType, importManager, result);
            result.add(FieldValidationGenerator.escapeString((String)validatorDefinition.getParameter("editorName")));
        }
    }

    @AutoService(value={FieldValidationGenerator.class})
    public static class CoordinateLatitudeDtoFieldValidatorGenerator
    extends FieldValidatorGeneratorSupport {
        public CoordinateLatitudeDtoFieldValidatorGenerator() {
            super(CoordinateLatitudeDtoFieldValidator.class, true, true, false, false);
        }

        protected void generateExtraParameters(FileValidatorEntryDefinition key, FieldValidatorDefinition validatorDefinition, Class<? extends NuitonValidationContext> validationContextType, ImportManager importManager, List<String> result) throws NoSuchMethodException {
            super.generateExtraParameters(key, validatorDefinition, validationContextType, importManager, result);
            result.add(FieldValidationGenerator.escapeString((String)validatorDefinition.getParameter("editorName")));
        }
    }
}

