/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation.validator;

import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.jaxx.widgets.validation.JaxxWidgetsValidationContext;
import io.ultreia.java4all.validation.core.api.NuitonValidationContext;
import io.ultreia.java4all.validation.core.impl.ValidationMessagesCollector;
import io.ultreia.java4all.validation.core.impl.field.FieldValidatorSupport;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;

public class CoordinateLatitudeDtoFieldValidator<O>
extends FieldValidatorSupport<O, Float> {
    private final String editorName;

    public CoordinateLatitudeDtoFieldValidator(String fieldName, Function<O, Float> fieldFunction, String editorName) {
        super(fieldName, fieldFunction);
        this.editorName = editorName;
    }

    public void validate(O object, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        if (StringUtils.isEmpty((CharSequence)this.editorName)) {
            throw new IllegalStateException("editorName is not defined");
        }
        if (this.getField(object) == null) {
            return;
        }
        Map<String, CoordinatesEditor> map = ((JaxxWidgetsValidationContext)validationContext).getCoordinatesEditors();
        if (map == null) {
            return;
        }
        CoordinatesEditor coordinatesEditor = map.get(this.editorName);
        if (coordinatesEditor == null) {
            return;
        }
        Objects.requireNonNull(coordinatesEditor, "can't find editor named " + this.editorName);
        CoordinateFormat format = coordinatesEditor.getModel().getFormat();
        switch (format) {
            case dd: {
                this.validate(coordinatesEditor.getLatitudeDd(), validationContext, messagesCollector);
                break;
            }
            case dms: {
                this.validate(coordinatesEditor.getLatitudeDms(), validationContext, messagesCollector);
                break;
            }
            case dmd: {
                this.validate(coordinatesEditor.getLatitudeDmd(), validationContext, messagesCollector);
            }
        }
    }

    private void validate(AbsoluteDdCoordinateEditor editor, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        AbsoluteDdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 90) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.degree.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void validate(AbsoluteDmsCoordinateEditor editor, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        Integer second;
        Integer minute;
        AbsoluteDmsCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 90) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.degree.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
        if ((minute = model.getMinute()) != null && minute > 59) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.minute.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
        if ((second = model.getSecond()) != null && second > 59) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.second.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void validate(AbsoluteDmdCoordinateEditor editor, NuitonValidationContext validationContext, ValidationMessagesCollector messagesCollector) {
        Integer minute;
        AbsoluteDmdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 90) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.degree.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
        if ((minute = model.getMinute()) != null && minute > 59) {
            this.addMessage(validationContext, messagesCollector, I18n.n((String)"jaxx.validation.coordinate.minute.latitude.outOfBound", (Object[])new Object[0]), new Object[0]);
        }
    }
}

