/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.validation.core.legacy.XWork2ValidatorUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorModel;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

@Deprecated
public class TemperatureBoundFieldValidator
extends FieldValidatorSupport {
    private final Map<String, TemperatureResult> temperatureResults = new LinkedHashMap<String, TemperatureResult>();
    private TemperatureFormat defaultTemperatureFormat;
    private Float min;
    private Float max;

    public void setDefaultTemperatureFormat(String defaultTemperatureFormat) {
        this.defaultTemperatureFormat = TemperatureFormat.valueOf((String)defaultTemperatureFormat);
    }

    public void setMin(String min) {
        this.min = Float.valueOf(min);
    }

    public void setMax(String max) {
        this.max = Float.valueOf(max);
    }

    public Map<String, TemperatureResult> getTemperatureResults() {
        return this.temperatureResults;
    }

    public void validate(Object object) throws ValidationException {
        TemperatureEditorModel temperatureEditorModel;
        if (this.min == null) {
            throw new ValidationException("No parameter 'min' filled");
        }
        if (this.max == null) {
            throw new ValidationException("No parameter 'max' filled");
        }
        if (this.min.floatValue() >= this.max.floatValue()) {
            throw new ValidationException(String.format("No parameter 'min' (%s) is greater than 'max' (%s)", this.min, this.max));
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            throw new ValidationException("No parameter 'fieldName' filled");
        }
        Float temperature = (Float)this.getFieldValue(fieldName, object);
        if (temperature == null) {
            return;
        }
        this.temperatureResults.clear();
        Map map = (Map)this.getFieldValue("temperatureEditorModels", object);
        TemperatureFormat temperatureFormat = this.defaultTemperatureFormat;
        if (map != null && (temperatureEditorModel = (TemperatureEditorModel)map.get(fieldName)) != null) {
            temperatureFormat = temperatureEditorModel.getFormat();
        }
        if (temperature.floatValue() < this.min.floatValue() || temperature.floatValue() > this.max.floatValue()) {
            float max;
            float min;
            if (temperatureFormat.equals((Object)this.defaultTemperatureFormat)) {
                min = this.min.floatValue();
                max = this.max.floatValue();
            } else {
                min = this.defaultTemperatureFormat.convert(this.min, temperatureFormat).floatValue();
                max = this.defaultTemperatureFormat.convert(this.max, temperatureFormat).floatValue();
            }
            String fieldBoundName = fieldName + "Bound";
            this.temperatureResults.put(fieldBoundName, new TemperatureResult(min, max, temperatureFormat.getLabel()));
            if (this.getDefaultMessage().isEmpty()) {
                String defaultMessage = String.format("%1$s##${%2$s.min}##${%2$s.max}##${%2$s.format}", I18n.n((String)"jaxx.validation.temperature.temperature.bound", (Object[])new Object[0]), "temperatureResults." + fieldBoundName);
                this.setDefaultMessage(defaultMessage);
            }
            XWork2ValidatorUtil.addFieldError((FieldValidatorSupport)this, (ValueStack)this.stack, (String)this.getFieldName(), (Object)object);
        }
    }

    public String getValidatorType() {
        return "temperatureBound";
    }

    public static class TemperatureResult {
        private final float min;
        private final float max;
        private final String format;

        TemperatureResult(float min, float max, String format) {
            this.min = min;
            this.max = max;
            this.format = format;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

