/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.jaxx.widgets.validation;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorModel;
import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthFormat;
import io.ultreia.java4all.validation.core.legacy.XWork2ValidatorUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class NauticalLengthBoundFieldValidator
extends FieldValidatorSupport {
    private static final Logger log = LogManager.getLogger(NauticalLengthBoundFieldValidator.class);
    private final Map<String, NauticalLengthResult> results = new LinkedHashMap<String, NauticalLengthResult>();
    private NauticalLengthFormat defaultNauticalLengthFormat;
    private Float min;
    private Float max;

    public void setDefaultNauticalLengthFormat(String defaultNauticalLengthFormat) {
        try {
            this.defaultNauticalLengthFormat = NauticalLengthFormat.valueOf((String)Objects.requireNonNull(defaultNauticalLengthFormat).toUpperCase());
        }
        catch (Exception e) {
            log.error(String.format("Could not set 'defaultNauticalLengthFormat' parameter with value '%s'", defaultNauticalLengthFormat), (Throwable)e);
            throw e;
        }
    }

    public void setMin(String min) {
        this.min = Float.valueOf(min);
    }

    public void setMax(String max) {
        this.max = Float.valueOf(max);
    }

    public Map<String, NauticalLengthResult> getResults() {
        return this.results;
    }

    public void validate(Object object) throws ValidationException {
        NauticalLengthEditorModel nauticalLengthEditorModel;
        if (this.defaultNauticalLengthFormat == null) {
            throw new ValidationException("No parameter 'defaultNauticalLengthFormat' filled");
        }
        if (this.min == null) {
            throw new ValidationException("No parameter 'min' filled");
        }
        if (this.max == null) {
            throw new ValidationException("No parameter 'max' filled");
        }
        if (this.min.floatValue() >= this.max.floatValue()) {
            throw new ValidationException(String.format("No parameter 'min' (%s) is greater than 'max' (%s)", this.min, this.max));
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            throw new ValidationException("No parameter 'fieldName' filled");
        }
        Float nauticalLength = (Float)this.getFieldValue(fieldName, object);
        if (nauticalLength == null) {
            return;
        }
        this.results.clear();
        Map map = (Map)this.getFieldValue("nauticalLengthEditorModels", object);
        NauticalLengthFormat nauticalLengthFormat = this.defaultNauticalLengthFormat;
        if (map != null && (nauticalLengthEditorModel = (NauticalLengthEditorModel)map.get(fieldName)) != null) {
            nauticalLengthFormat = nauticalLengthEditorModel.getFormat();
        }
        if (nauticalLength.floatValue() < this.min.floatValue() || nauticalLength.floatValue() > this.max.floatValue()) {
            float max;
            float min;
            if (nauticalLengthFormat.equals((Object)this.defaultNauticalLengthFormat)) {
                min = this.min.floatValue();
                max = this.max.floatValue();
            } else {
                min = this.defaultNauticalLengthFormat.convert(nauticalLengthFormat, this.min).floatValue();
                max = this.defaultNauticalLengthFormat.convert(nauticalLengthFormat, this.max).floatValue();
            }
            String fieldBoundName = fieldName + "Bound";
            this.results.put(fieldBoundName, new NauticalLengthResult(min, max, nauticalLengthFormat.getLabel()));
            if (this.getDefaultMessage().isEmpty()) {
                String defaultMessage = String.format("%1$s##${%2$s.min}##${%2$s.max}##${%2$s.format}", I18n.n((String)"jaxx.validation.nauticalLength.nauticalLength.bound", (Object[])new Object[0]), "results." + fieldBoundName);
                this.setDefaultMessage(defaultMessage);
            }
            XWork2ValidatorUtil.addFieldError((FieldValidatorSupport)this, (ValueStack)this.stack, (String)this.getFieldName(), (Object)object);
        }
    }

    public String getValidatorType() {
        return "nauticalLengthBound";
    }

    static class NauticalLengthResult {
        private final float min;
        private final float max;
        private final String format;

        NauticalLengthResult(float min, float max, String format) {
            this.min = min;
            this.max = max;
            this.format = format;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

