package io.ultreia.java4all.jaxx.widgets.validation;

/*-
 * #%L
 * JAXX :: Widgets - Validation
 * %%
 * Copyright (C) 2008 - 2024 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.jaxx.widgets.length.nautical.NauticalLengthEditorModel;
import io.ultreia.java4all.validation.core.api.NuitonValidationContext;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorModel;

import java.util.Map;

/**
 * All we need to validate some widgets.
 * <p>
 * Created at 29/01/2024.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3.1.0
 */
public interface JaxxWidgetsValidationContext extends NuitonValidationContext {

    Map<String, CoordinatesEditor> getCoordinatesEditors();

    default CoordinatesEditor getCoordinatesEditor(String name) {
        return getCoordinatesEditors().get(name);
    }

    default void setCoordinatesEditor(String name, CoordinatesEditor editor) {
        getCoordinatesEditors().put(name, editor);
    }

    Map<String, TemperatureEditorModel> getTemperatureEditorModels();

    default TemperatureEditorModel getTemperatureEditorModel(String name) {
        return getTemperatureEditorModels().get(name);
    }

    default void setTemperatureEditorModel(String name, TemperatureEditorModel editor) {
        getTemperatureEditorModels().put(name, editor);
    }

    Map<String, NauticalLengthEditorModel> getNauticalLengthEditorModels();

    default NauticalLengthEditorModel getNauticalLengthEditorModel(String name) {
        return getNauticalLengthEditorModels().get(name);
    }

    default void setNauticalLengthEditorModel(String name, NauticalLengthEditorModel editor) {
        getNauticalLengthEditorModels().put(name, editor);
    }
}
