package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.text.actions.PasswordEditorReset;
import org.nuiton.jaxx.widgets.text.actions.PasswordEditorToggle;

public class PasswordEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAM1UTU9TQRS9LbRAAQUlJJqYkKCCQV9jjCuMH3wFsQpBFsRunPYN7ZDHm2HmPvqIkYULd/4BF27dGP4DcWXixi3/wYSf4J3Xvr5WypcrmzApt+eeOffOuffbb8gYDXelrjh+IFD6ziYLQ0cHPoot7iw9W19fLm3yMs5xU9ZCodRQ/6TSkC5Cv9uMGwSnWCCmfJ0pb5nyDab8rNxS0ud+C9F0AXIGdz1uqpwjwuSJyWVj8q+byOlQBbpxV0fVne76+fH+YYrPfU4DhIrk91HZUxcgSKruLkBauAhXCptsh+U95ldInBZ+hQoatLFZjxnzim3xbdiDngJkFdNEhnDvn9oT0UVUoULoQknnMek14VY4Ggd5iM4KJdSkduddAmilouwsQneJMx9hyIp0rHCn/rgJoldpqbjG3TZUvbwWlOaG45pQ9v/hJN7Pyiikbwp8g6odsQShY2qU6yytSenNMG2Rfc2ETESEcLUNOhMg1WUhI01kzhZWrwfhehs8rnZBcM9t5x9oCFoVlSra2Gj771mUlYrHEa79pdVGExk3FLnl9kluIXc6iTsTo6SKVF9AYYTxkwfDenuVUHVXj5/santNBPywv6e/1o4OYyvbCR47K6tlaslXjVcWVtvluo8DFF7+JVPTRZoN7pEropGeOF356waS1JOK4cgylslZZKZKbJmew4Pvo29/dUF6AXKeZO4Cs/jn0IdVevyq9NxQPXkaiRuo9dI5RH9dCIMlelKuV5jwkdO4ZTaYR16BrFRsO+BJoG+DaJGVvGYspEZOnN7Ipu795aMfXz7dOoibmaIybp4nM2lo5g1khe8Jn0eboTH0HTdBvzI8cGUy0Z1mHGi+e+N5aQzXRHROHWtUN1l3Q5YDs6bZDteGeS/4rpn3bTtOb5pNam0aQg+P0wbfiZhj8s77MLB3P4iaY789hHhw1X+qboh8VVsULo9Xw1lCUxfjb1lG52DOemxX0i6BS49cMupYSfgurZnHx5hT9swR4x88Vh7qlwcAAA==";
    private static final Logger log = LogManager.getLogger(PasswordEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected JToolBar actionsRight;
    protected Object bean;
    protected PasswordEditorHandler handler;
    protected String property;
    protected JButton reset;
    protected String resetTip;
    protected JPasswordField textEditor;
    protected JToggleButton toggle;
    protected PasswordEditor top;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public void setBean(Object bean) { this.bean = (JavaBean) bean; }
    
    public char[] getPassword() {
        char[] text = textEditor.getPassword();
        if (text == null || text.length == 0) {
            text = null;
        }
        return text;
    }
    
    public void setPassword(char[] password) {
        char[] oldValue = getPassword();
        if (!Arrays.equals(password, oldValue)) {
            textEditor.setText(password == null ? null : new String(password));
            firePropertyChange("password", oldValue, password);
        }
    }
    
    public void setPasswordFromEditor() {
       firePropertyChange("password", null, getPassword());
    }
    
    public void reset() { setPassword(null); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PasswordEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PasswordEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PasswordEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PasswordEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PasswordEditor() {
        $initialize();
    }

    public PasswordEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PasswordEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public PasswordEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__textEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPasswordFromEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public JToolBar getActionsRight() {
        return actionsRight;
    }

    public Object getBean() {
        return bean;
    }

    public PasswordEditorHandler getHandler() {
        return handler;
    }

    public String getProperty() {
        return property;
    }

    public JButton getReset() {
        return reset;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JPasswordField getTextEditor() {
        return textEditor;
    }

    public JToggleButton getToggle() {
        return toggle;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(reset, BorderLayout.CENTER);
    }

    protected void addChildrenToActionsRight() {
        actionsRight.add(toggle, BorderLayout.CENTER);
    }

    protected void addChildrenToTop() {
        add(actionsLeft, BorderLayout.WEST);
        add(textEditor);
        add(actionsRight, BorderLayout.EAST);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createActionsRight() {
        $objectMap.put("actionsRight", actionsRight = new JToolBar());
        
        actionsRight.setName("actionsRight");
        actionsRight.setBorderPainted(false);
        actionsRight.setOpaque(false);
        actionsRight.setFloatable(false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusTraversalKeysEnabled(false);
        reset.setOpaque(false);
        reset.setFocusable(false);
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JPasswordField());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
        textEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textEditor"));
    }

    protected void createToggle() {
        $objectMap.put("toggle", toggle = new JToggleButton());
        
        toggle.setName("toggle");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new PasswordEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createBean();
        createProperty();
        createResetTip();
        createActionsLeft();
        createReset();
        createTextEditor();
        createActionsRight();
        createToggle();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToActionsLeft();
        addChildrenToActionsRight();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // late initializer
        
        PasswordEditorReset.init(this, reset, PasswordEditorReset.class);
        PasswordEditorToggle.init(this, toggle, PasswordEditorToggle.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
