package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class UrlEditor extends NormalTextEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OPEN_LINK_TIP = "openLinkTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_OPEN_LINK_ENABLED = "openLink.enabled";
    public static final String BINDING_OPEN_LINK_TOOL_TIP_TEXT = "openLink.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1US09TQRj9WmihPATFmOjC1KBQotzGNT55RbCKgZoQu3HaO7SDw8wwM5deYmDhwp1/wIVbN4b/QFyZuHHLfzDhJ/jN7eNWKaB2MWmmZ86c78w5/fITUkbDHamrngiYlcLbJGHo6UBYtkW95cfr6yvlTVqx89RUNFNWamh8EklIlmDQb+8bC16pgEz5BlPeMeWbTPk5uaWkoKKDaKYAA8bucmpqlFoLuVMPV4zJr7WRM6EKdPOurqq73fX9/d2jBJ3/mAQIFcrvxbFv/wNBPHVvAZLMt3CpsEl2SJ4TUUVxmokqDjTs9uY4MeY52aLbsA99BUgropHMwvR/2RPRRVShsjBkpXqp+YKPJNrCxJ8z1JlfpdZ4lobWawOVihjSFgaloqLAxJsi3gKjTq/nZvAaM8TAIVKxTAqzyqo11H7ZIUPP1BHkLRel5LNEO2imfaK/RW1h7Df0bGBRn0ONKPT9hOaW7/jOXvzOseWJEqR0gNsWxk+PmEvJKqIa+Rg/PR/umgj47mBff64fH7VC0YPisued6sg/vpDSOLS2zGkbaSQisIznnxE1U4KMoRzLE5Vj8mzla00kqkcVF6N3cUzeE2JqyJbqOzr8euX1jx5ILsIAl8RfJA6/BBlb0+iY5H6oHj6KxA3V+3EddSNZGC5L7VP9gjBhKQY3tUG4QXvTUpHtgMYbmQ2ktaTM23shGjl5tpFt3Qcrx98+fbh12DIzgWPc/JuTsaGpV5BmgjNBo44169O1U4PK0MCXcTe6tQUw4f2trDaTfS1ar58wCvN7dUNWAlPUZIdqQ/hTumsWhLOjw7SBRiuWKlIgd6D5tAt9VzMdWaeZ2D2LUrB3Rewm/oG8xaKuxG3MTe1Z6KOtG8fczw6Zm8reuJ8VAed7YeDET0Tuum856GidOmfChIVeFum+cM/Hd86WmfCxnw9OsCbcOoZ8vwAU4wDoIAYAAA==";
    private static final Logger log = LogManager.getLogger(UrlEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsRight;
    protected JButton openLink;
    protected String openLinkTip;
    protected UrlEditor topUrlEditor;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UrlEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public UrlEditor(LayoutManager param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public UrlEditor() {
        
    }

    public UrlEditor(JAXXContext param0) {
        super(param0);
    }

    public UrlEditor(boolean param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openLink(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        SwingUtil.openLink(getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsRight() {
        return actionsRight;
    }

    public JButton getOpenLink() {
        return openLink;
    }

    public String getOpenLinkTip() {
        return openLinkTip;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOpenLinkTip(String openLinkTip) {
        String oldValue = this.openLinkTip;
        this.openLinkTip = openLinkTip;
        firePropertyChange(PROPERTY_OPEN_LINK_TIP, oldValue, openLinkTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsRight() {
        actionsRight.add(openLink, BorderLayout.CENTER);
    }

    protected void addChildrenToTopUrlEditor() {
        add(actionsRight, BorderLayout.EAST);
    }

    protected void createActionsRight() {
        $objectMap.put("actionsRight", actionsRight = new JToolBar());
        
        actionsRight.setName("actionsRight");
        actionsRight.setBorderPainted(false);
        actionsRight.setOpaque(false);
        actionsRight.setFloatable(false);
    }

    protected void createOpenLink() {
        $objectMap.put("openLink", openLink = new JButton());
        
        openLink.setName("openLink");
        openLink.setFocusTraversalKeysEnabled(false);
        openLink.setOpaque(false);
        openLink.setFocusable(false);
        openLink.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openLink"));
    }

    protected void createOpenLinkTip() {
        $objectMap.put("openLinkTip", openLinkTip = I18n.t("jaxx.url.action.openLink.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        topUrlEditor = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("topUrlEditor", topUrlEditor);
        createOpenLinkTip();
        createActionsRight();
        createOpenLink();
        // inline creation of topUrlEditor
        setName("topUrlEditor");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_TOOL_TIP_TEXT, true ,"openLinkTip") {
        
            @Override
            public void processDataBinding() {
                openLink.setToolTipText(getOpenLinkTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_ENABLED, true ,"text") {
        
            @Override
            public void processDataBinding() {
                openLink.setEnabled(getText() != null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToTopUrlEditor();
        addChildrenToActionsRight();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        openLink.setIcon(SwingUtil.getUIManagerActionIcon("url-open"));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
