package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class BigTextEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INFO_LABEL_TOOL_TIP_TEXT = "infoLabel.toolTipText";
    public static final String BINDING_RESET_TEXT_ENABLED = "resetText.enabled";
    public static final String BINDING_RESET_TEXT_TOOL_TIP_TEXT = "resetText.toolTipText";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";
    public static final String BINDING_TITLE_LABEL_TEXT = "titleLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVyW4bRxAtUqIkUouXrL4kcryISuxhVuSgII7kBbbCxIYlG0Z0SZPTpFpodo+7a8wRhPiQQw4B8gM55JpL4H8wcgqQS676hwD+hFTPkDMkxc0xAbY4NVWv6lVXPf3xLxSsgSvaND0VCtTKO2BR5JlQoWhxb3vz0aO7tQNexxvc1o0IUBtIPrk85Pdg0U/tFsHbqxJSJUGqOKRKB6lyXbcCrbjqAdqoQsnioeR2n3NEKI8Mrltb2Uk9N6IgNJ1cQ6seluvvnz46zvEbv+YBooDKXyHaH7wEQMZ6tgp54SOcrR6wJ6wimWpScUaoJhFadrbrkln7LWvxx/AU5qswFzBDYAhX/1d7YrgYKgoQZlDT+f5g6W3hNzlaD3mE3pZo7tLfmz69N0EQB88hFFra5xLhvNBeKNFwwTxX76dMSq/GmfK26WmLfmQxC4HRATd4iHDa+XqOr5fw7UFGgTKme6bHKFmNywHjguGW464IBuwrrvCdutFS3mOKI7zlskWebVMibzt74/yLaVgJU54Ib/SFuA5sGs6c59tpwFJdy7ClbnPmEys42xfi8GVPrRcTy4fuedUd7/QkdoyrjuEgSrVL+3zqXRSqoVP7pf6Xi6yOQitb5Q2akdf7SWgtt5jpz11Mekj8EF7rc98KkSbCuZUDGvDLowacFsrLFiqb7dweFExIZoQLo3fZreN98koW8cLoRXRpYscfnz01v7dfHHe3b4mKW50U1SM0tAqdORSutlPJ6oUoZOUbFmzsQdFySSoVq9Da+Mp3Op5UPVVxJh5qh+TdZnaf0Arzx8//fPP7f2YgfwtKUjP/FnP+d6CI+9T5fS39KLj2VVzcUnuBztP0nUFYrmlDU3WPCYWcFKLQYJIuCuZ0wB6HPDMUGwSLrCZTW0SNXBvfyLTuZ3df/PXbL5eed5uZIxoXp4nMGlr4DuaEkkLxWMw6OjVUvBYDy0NfZyI0TJaAJGmhO6ydBfokPj8/0agcKUnvEj4UvI3w8ZHi7dVkd8o7bpofuDshTUu05iGTIS83nXTQ3pXX19d/iEKX4FrcAfdrE07ISDChljzCrNFtGprcZwjzXLk7oZtbPhL2ZvJQHp6oR3gmJaGNPdfQ9dDuGvaEG8vk1/ywC58NRSmRgTt1rTrwV+M9Hzo/Dq53fkhFkLpPuprIwqkjatX9jtQShZcjlwnMJG50mbMYZ7x8NM2tjehlqqVTXFhfn2adsA6SH19KMmIjSsmEegrmc5IdalJcWPnCp3VerQnlU6YvTwDn3FmaAvHEYjjPaDjeuYl4zjwO4d1XRnhvmvkQ9eRf0giMtamq+HkMwhVC+A/VJnwlygoAAA==";
    private static final Logger log = LogManager.getLogger(BigTextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected JPanel columnHeader;
    protected BigTextEditorHandler handler;
    protected JLabel infoLabel;
    protected String label;
    protected JavaBean model;
    protected String property;
    protected JButton resetText;
    protected String resetTip;
    protected JTextArea textEditor;
    protected JScrollPane textScrollPane;
    protected String title;
    protected JLabel titleLabel;
    protected BigTextEditor top;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public Object getBean() { return model; }
    
    @Override
    public void setBean(Object bean) { setModel((JavaBean) bean); }
    
    public String getText() {
        return model == null || property == null ? null : model.get(property);
    }
    
    public void setText(String text) {
        if (model == null || property == null) {
            return;
        }
        if (!Objects.equals(text, getText())) {
            model.set(property, text);
        }
    }
    
    public void setTextFromEditor() {
        if (model == null || property == null) {
            return;
        }
        String text = textEditor.getText();
        if (!text.isEmpty() || getText() != null) {
            setText(text.isEmpty() ? null : text);
        }
    }
    
    public void setInfoLabelTip(String infoLabelTip) {
      infoLabel.setToolTipText(infoLabelTip);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BigTextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor() {
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetText(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setText(null);
    }

    public void doFocusGained__on__textScrollPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textEditor.requestFocus();
    }

    public void doKeyReleased__on__textEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTextFromEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public JPanel getColumnHeader() {
        return columnHeader;
    }

    public BigTextEditorHandler getHandler() {
        return handler;
    }

    public JLabel getInfoLabel() {
        return infoLabel;
    }

    public String getLabel() {
        return label;
    }

    public JavaBean getModel() {
        return model;
    }

    public String getProperty() {
        return property;
    }

    public JButton getResetText() {
        return resetText;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JTextArea getTextEditor() {
        return textEditor;
    }

    public JScrollPane getTextScrollPane() {
        return textScrollPane;
    }

    public String getTitle() {
        return title;
    }

    public JLabel getTitleLabel() {
        return titleLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLabel(String label) {
        String oldValue = this.label;
        this.label = label;
        firePropertyChange(PROPERTY_LABEL, oldValue, label);
    }

    public void setModel(JavaBean model) {
        JavaBean oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(resetText);
    }

    protected void addChildrenToColumnHeader() {
        columnHeader.add($JPanel0, BorderLayout.WEST);
        columnHeader.add(actionsLeft, BorderLayout.EAST);
    }

    protected void addChildrenToTextScrollPane() {
        textScrollPane.getViewport().add(textEditor);
    }

    protected void addChildrenToTop() {
        add(textScrollPane, BorderLayout.CENTER);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createColumnHeader() {
        $objectMap.put("columnHeader", columnHeader = new JPanel());
        
        columnHeader.setName("columnHeader");
        columnHeader.setLayout(new BorderLayout());
    }

    protected void createInfoLabel() {
        $objectMap.put("infoLabel", infoLabel = new JLabel());
        
        infoLabel.setName("infoLabel");
    }

    protected void createLabel() {
        $objectMap.put("label", label = null);
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createResetText() {
        $objectMap.put("resetText", resetText = new JButton());
        
        resetText.setName("resetText");
        resetText.setFocusTraversalKeysEnabled(false);
        resetText.setOpaque(false);
        resetText.setFocusable(false);
        resetText.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetText"));
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JTextArea());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
        textEditor.setLineWrap(true);
        textEditor.setWrapStyleWord(true);
        textEditor.setRows(5);
        textEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textEditor"));
    }

    protected void createTextScrollPane() {
        $objectMap.put("textScrollPane", textScrollPane = new JScrollPane());
        
        textScrollPane.setName("textScrollPane");
        textScrollPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textScrollPane"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTitleLabel() {
        $objectMap.put("titleLabel", titleLabel = new JLabel());
        
        titleLabel.setName("titleLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new BigTextEditorHandler(this);
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createModel();
        createProperty();
        createTitle();
        createLabel();
        createResetTip();
        createTextScrollPane();
        createTextEditor();
        createColumnHeader();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout(3, 3));
        createTitleLabel();
        createInfoLabel();
        createActionsLeft();
        createResetText();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_LABEL_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                titleLabel.setText(SwingUtil.getStringValue(getTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INFO_LABEL_TOOL_TIP_TEXT, true ,"label") {
        
            @Override
            public void processDataBinding() {
                infoLabel.setToolTipText(SwingUtil.getStringValue(getLabel()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_TOOL_TIP_TEXT, true ,"resetTip") {
        
            @Override
            public void processDataBinding() {
                resetText.setToolTipText(getResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetText.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToTextScrollPane();
        addChildrenToColumnHeader();
        // inline complete setup of $JPanel0
        $JPanel0.add(titleLabel, BorderLayout.WEST);
        $JPanel0.add(infoLabel, BorderLayout.CENTER);
        addChildrenToActionsLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 property setters
        textScrollPane.setColumnHeaderView(columnHeader);
        infoLabel.setIcon(SwingUtil.getUIManagerActionIcon("info"));
        resetText.setIcon(SwingUtil.getUIManagerActionIcon("text-reset"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
