/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.text;

import io.ultreia.java4all.bean.JavaBean;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.text.NormalTextEditor;

class NormalTextEditorHandler
implements UIHandler<NormalTextEditor> {
    private final NormalTextEditor ui;
    private PropertyChangeListener propertyChangeListener;

    NormalTextEditorHandler(NormalTextEditor ui) {
        this.ui = ui;
    }

    public void afterInit(NormalTextEditor normalTextEditor) {
        this.ui.addPropertyChangeListener("model", evt -> {
            JavaBean oldValue = (JavaBean)evt.getOldValue();
            JavaBean newValue = (JavaBean)evt.getNewValue();
            this.updateListenersFromModel(oldValue, newValue, this.ui.getProperty());
        });
        this.ui.addPropertyChangeListener("property", evt -> {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.updateListenersFromProperty(oldValue, newValue, this.ui.getModel());
        });
    }

    private void updateListenersFromModel(JavaBean oldModel, JavaBean newModel, String property) {
        this.removeListener(oldModel, property);
        this.addListener(newModel, property);
    }

    private void updateListenersFromProperty(String oldProperty, String newProperty, JavaBean model) {
        this.removeListener(model, oldProperty);
        this.addListener(model, newProperty);
    }

    private void addListener(JavaBean model, String property) {
        if (property != null && model != null) {
            this.propertyChangeListener = evt -> {
                String newText;
                Object newValue = evt.getNewValue();
                String oldText = this.ui.getTextEditor().getText();
                if (!Objects.equals(oldText, newText = SwingUtil.getStringValue((Object)newValue))) {
                    this.ui.getTextEditor().setText(newText);
                }
            };
            model.addPropertyChangeListener(property, this.propertyChangeListener);
        }
    }

    private void removeListener(JavaBean model, String property) {
        if (property != null && model != null && this.propertyChangeListener != null) {
            model.removePropertyChangeListener(property, this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }
}

