package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class UrlEditor extends NormalTextEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OPEN_LINK_TIP = "openLinkTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_OPEN_LINK_ENABLED = "openLink.enabled";
    public static final String BINDING_OPEN_LINK_TOOL_TIP_TEXT = "openLink.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1US09TQRQ+LbRQHoJiTHRhSFAoUW7jGuODVwQrGCgJsRunvUM7eHtnmDmXXkJg4cKdf8CFWzeG/0Bcmbhxy38w4Sd45vZxqxR8dDFpTs/55jvffF8//4CU0XBf6orjBwKl7+ywMHR04KOocWfl6dbWWmmHl3GBm7IWCqWGxieRhGQRBt123SA4xTwh5RpIOYuUayLl5mVNSZ/7HUCzeRgwuO9xU+UcEbIXDpeNyW20O2dDFejmXV1Zd7vr27sHpwm+8CEJECqi30tr3/sHgHjr3jwkhYtwLb/D9ljOY36FyGnhV2ihYVub95gxq6zGd+EI+vKQVkwTGMLMf8kTwUVQoULoQUnn5O/U68KtcDQO8hCdTe0tuvSbVioaTCMMSsX9vPDfFAgcRi1Nx1J3GtTjxiFWRiF9sy4qVaJ83XaGjqlTk7NSkNKbY9q2ZtoT/S1ohLFfuucCJH62a0SR3Oc4t+Sm53Xi542VThQhpQMqI0xc7CxrjnXqathi4mJb2GuixrfHR/pT/ey05YUeIjf+p6kO29PDKE1LaxSW20jDCAEKL/eCqdkiZAz3KDNRJqYuZ77R7CT2xOJq9C4WyXnGTJXQUn2nJ19uvP7eA8klGPAkc5eY7V+GDFY1KSY9N1SPn0Tkhur9dI7alRCGS1K7XL9kwkdOfk1tM8+QvGmp2G7A40Jmm2CRlbx2LSQhpy4Xss37eO3s68f3d09aYiZojTt/MxkLmnoFaeF7wudRtJqp6RqlQWV44Mo4Et1CAuTw/pZXm86+FZ23zwlF/r25LcuBKWi2x7Vh3nO+bxZ9K0eHaAONVCyXpU/YgfZmrOm7imnBOsWk7CFRodwVKJv0v3FAQV2L05idPkTo460bJw4aidwkExhHmFWJizWF+1masgDZ6enDMLDLTEZq229Z6Eih+sPGCYReEe1x5aFL7z5eEr5LFz46h5qw5xjh/QTEH1BiJwYAAA==";
    private static final Log log = LogFactory.getLog(UrlEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsRight;
    protected JButton openLink;
    protected String openLinkTip;
    protected UrlEditor top;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UrlEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public UrlEditor(LayoutManager param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public UrlEditor() {
        
    }

    public UrlEditor(JAXXContext param0) {
        super(param0);
    }

    public UrlEditor(boolean param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openLink(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        SwingUtil.openLink(getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsRight() {
        return actionsRight;
    }

    public JButton getOpenLink() {
        return openLink;
    }

    public String getOpenLinkTip() {
        return openLinkTip;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOpenLinkTip(String openLinkTip) {
        String oldValue = this.openLinkTip;
        this.openLinkTip = openLinkTip;
        firePropertyChange(PROPERTY_OPEN_LINK_TIP, oldValue, openLinkTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsRight() {
        actionsRight.add(openLink, BorderLayout.CENTER);
    }

    protected void addChildrenToTop() {
        add(actionsRight, BorderLayout.EAST);
    }

    protected void createActionsRight() {
        $objectMap.put("actionsRight", actionsRight = new JToolBar());
        
        actionsRight.setName("actionsRight");
        actionsRight.setBorderPainted(false);
        actionsRight.setOpaque(false);
        actionsRight.setFloatable(false);
    }

    protected void createOpenLink() {
        $objectMap.put("openLink", openLink = new JButton());
        
        openLink.setName("openLink");
        openLink.setFocusTraversalKeysEnabled(false);
        openLink.setOpaque(false);
        openLink.setFocusable(false);
        openLink.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openLink"));
    }

    protected void createOpenLinkTip() {
        $objectMap.put("openLinkTip", openLinkTip = I18n.t("jaxx.url.action.openLink.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("top", top);
        createOpenLinkTip();
        createActionsRight();
        createOpenLink();
        // inline creation of top
        setName("top");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_TOOL_TIP_TEXT, true ,"openLinkTip") {
        
            @Override
            public void processDataBinding() {
                openLink.setToolTipText(getOpenLinkTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_ENABLED, true ,"text") {
        
            @Override
            public void processDataBinding() {
                openLink.setEnabled(StringUtils.isNotEmpty(getText()));
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToTop();
        addChildrenToActionsRight();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        openLink.setIcon(SwingUtil.getUIManagerActionIcon("url-open"));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
