package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.lang.JavaBean;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class NormalTextEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_TEXT_ENABLED = "resetText.enabled";
    public static final String BINDING_RESET_TEXT_TOOL_TIP_TEXT = "resetText.toolTipText";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uy04UQRS9MzADM4iAEqI7FAWM0qOJO4wPXhEcwcAsjGwspouZIjVdTdVtaEJk4cKdP+DCrRvDPxBXJm7c8g8mfIK3unseyPBykql0V586de6tc+r7H8gYDQ+UrjheIFB5zgYLQ0cHHooadxZevH27tLbByzjDTVkLH5WG+JdKQ3oVetzGvEFwVovEVIiZCpapkDAVplXNVx73Wogmi5A3uCO5qXKOCOOnLi4bU1hpICdDP9DJXm1Vt9vr16dHhyk+8yUNEPokv4vKvn8JgmbVnUVICxfhWnGDbbGCZF6FxGnhVaigXjs3LZkxi6zGN2EPuoqQ9ZkmMoSJ/2pPRBdRhT5CByoaJ/6Vvi3cCkfjIA/RWVS6xmSJHmddgmjfj9ZnETI15XKJcEsoJ5CouWCOlfyYSenYUpwFepvizGuu6fa18rnGHYR+i41xccktKM0Nx5Lw7ftAc76HlVEozxT5OnVg0BKEjtkWdquSUnKKaYvMNRbkYiISj3D9GHwqQKrXwgYb6Dw2qkQYOs5OX+YEl27Cr2H0tAMngzlNgzXPOrUKGR3QNMLI6d629lwmVGzMkdONabeJgB/39/S37aPDuhttCIfPW9USPLJGcijCauuLrRigkIXXzJ9chZzhklIbpXLsbOUrCZLUk4qB6IQtk/OSmSqxZboOD34Mvf/dAek5yEvF3Dlm8fOQwyqdVVVJN/SfPY/EXdnuprGf/h0IvWtKu1y/YcJDTonJrDNJRwtZ5bPNgDcncutEi2xNNuZCauTY2Y1s6N5fOvr59fPdg3ozU1TGnYusbDY08w6ywpPC41G4k9y2DXOPb3jgqmYo28UUKKLddXsnWbgdjaMnGkUmvrmuyoEpabbFtWHyFd8xs55tR0vT8nGO5svKS1w/EQWlbTstXWs7KYZIYiidca76dumyWE4CO37vA0IXr2/Yuyvqu9OXMLCqnait9ukhtCbUP6e21OWIW8J8AeasZDuKrgS4+sQl9wyvCc+l4D89wZyyY/4CjJ2iHN8vi+05bhDHX0VLefUzBwAA";
    private static final Log log = LogFactory.getLog(NormalTextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected NormalTextEditorHandler handler;
    protected JavaBean model;
    protected String property;
    protected JButton resetText;
    protected String resetTip;
    protected JTextField textEditor;
    protected NormalTextEditor top;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getText() {
        return model == null || property == null ? null : model.get(property);
    }
    
    public void setText(String text) {
        if (model == null || property == null) {
            return;
        }
        if (!Objects.equals(text, getText())) {
            model.set(property, text);
        }
    }
    
    public void setTextFromEditor() {
        if (model == null || property == null) {
            return;
        }
        String text = textEditor.getText();
        if (!text.isEmpty() || getText() != null) {
            setText(text.isEmpty() ? null : text);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NormalTextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor() {
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetText(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setText(null);
    }

    public void doKeyReleased__on__textEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTextFromEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public NormalTextEditorHandler getHandler() {
        return handler;
    }

    public JavaBean getModel() {
        return model;
    }

    public String getProperty() {
        return property;
    }

    public JButton getResetText() {
        return resetText;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JTextField getTextEditor() {
        return textEditor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(JavaBean model) {
        JavaBean oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(resetText, BorderLayout.CENTER);
    }

    protected void addChildrenToTop() {
        add(actionsLeft, BorderLayout.WEST);
        add(textEditor);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createResetText() {
        $objectMap.put("resetText", resetText = new JButton());
        
        resetText.setName("resetText");
        resetText.setFocusTraversalKeysEnabled(false);
        resetText.setOpaque(false);
        resetText.setFocusable(false);
        resetText.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetText"));
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JTextField());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
        textEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textEditor"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new NormalTextEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createModel();
        createProperty();
        createResetTip();
        createActionsLeft();
        createResetText();
        createTextEditor();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_TOOL_TIP_TEXT, true ,"resetTip") {
        
            @Override
            public void processDataBinding() {
                resetText.setToolTipText(getResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetText.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToActionsLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        resetText.setIcon(SwingUtil.getUIManagerActionIcon("text-reset"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
