package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.lang.JavaBean;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class BigTextEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INFO_LABEL_TOOL_TIP_TEXT = "infoLabel.toolTipText";
    public static final String BINDING_RESET_TEXT_ENABLED = "resetText.enabled";
    public static final String BINDING_RESET_TEXT_TOOL_TIP_TEXT = "resetText.toolTipText";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";
    public static final String BINDING_TITLE_LABEL_TEXT = "titleLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS3MbRRBuyZZsyY88eOYCDnlYhmTFsziYIth5VBIEScUmlcIXRtqRPK7RzGamN1qXixw4cKCKP8CBKxcq/yHFiSouXP0fqMpPoGdX2pVkvQKq0sjb2/11fz3dn3//BwrWwBVtWp4KBWrlHbAo8kyoULS5d3fr0aN79QPewBvcNowIUBtIPrk85PdgyU/tFsHbqxFSNUGqOqRqF6l6XbcDrbjqA9qsQdnioeR2n3NEqIwNblhb3Uk9N6MgNN1cI6seleuvHz84zvEbv+QBooDKXyXa770EQMZ6vgZ54SOcrR2wJ6wqmWpRcUaoFhFacbbrkln7NWvzx/AUFmpQDJghMISr/6k9MVwMFQUIc6jpfHe49I7wWxythzxCb1u0dun3pk/vTRDEwUWEQlv7XCKcF9oLJRoumOfq/ZhJ6Tke3l162uZMZTGLgdEBN3iIcNr5Jn4J3z5kFChjumf6jJLVuRwyLhpuOe6KYMi+6grfaRgt5X2mOMIbLlvk2Y5wdWVvnH8pDStjyhPhtYEQ14Etw5nzfDMNWG5oGbbVbc58YgVnB0Icvuyr9WJied89r7njrb7EjnHNMRxGqfVon0+9S0I1dWq/NPhyiTVQaGVrvEkz8uogCa3lNjODuUtJD4kfwisD7tsh0kQ4t0pAA3553IDTQnnZQmWznduDggnJjHBh/C67dXxAXskiXhi/iC5N7PjDs6fmt86L4972LVNxa9Oi+oSGVqE7h8LVdipZvRCFrH7Fgs09KFkuSaViFVqfXPlO15OqpyrOxEPtkLzbzO4TWmHh+Pkfr3/39xzkb0FZaubfYs7/DpRwnzq/r6UfBde+iItb7izSeZq+cwgrdW1oqu4zoZCTQhSaTNJFQVEH7HHIM0OpSbDI6jK1RdTI9cmNTOt+du/Fn7/+fOl5r5k5onFxlsisoYVvoSiUFIrHYtbVqZHitRRYHvo6E6FRsgQkSYu9Ye0u0Efx+emJRuVISfqX8KHgHYQPjxTvrCW7U9lx0/yNuxPStERrHjIZ8krLSQftXWVjY+P7KHQJrsUdcH9twQkZCabUkkeYN7pDQ5P7BGGBK3cndHMrR8LeTB4qoxP1Cc+0JLSx55q6Edpdw55wY5n8kh/24LOhKCcycKehVRf+arznI+fHwfXPD6kIUvdJVxNZOHVErXrQlVqi8HLkMoGZxo0ucx7jjJePZrm1Mb1MtXSGCxvo07wT1mHyk0tJRmxMKZlQz8C8KNmhJsWF1c98Wue1ulA+Zfr8BHDOneUZEE8shvOMRuOdm4rnzJMQ3v7fCO/MMh+ikfxLGoOxPlMVP01AuEII/wKAqjCaygoAAA==";
    private static final Log log = LogFactory.getLog(BigTextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected JPanel columnHeader;
    protected BigTextEditorHandler handler;
    protected JLabel infoLabel;
    protected String label;
    protected JavaBean model;
    protected String property;
    protected JButton resetText;
    protected String resetTip;
    protected JTextArea textEditor;
    protected JScrollPane textScrollPane;
    protected String title;
    protected JLabel titleLabel;
    protected BigTextEditor top;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getText() {
        return model == null || property == null ? null : model.get(property);
    }
    
    public void setText(String text) {
        if (model == null || property == null) {
            return;
        }
        if (!Objects.equals(text, getText())) {
            model.set(property, text);
        }
    }
    
    public void setTextFromEditor() {
        if (model == null || property == null) {
            return;
        }
        String text = textEditor.getText();
        if (!text.isEmpty() || getText() != null) {
            setText(text.isEmpty() ? null : text);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BigTextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor() {
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetText(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setText(null);
    }

    public void doFocusGained__on__textScrollPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textEditor.requestFocus();
    }

    public void doKeyReleased__on__textEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTextFromEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public JPanel getColumnHeader() {
        return columnHeader;
    }

    public BigTextEditorHandler getHandler() {
        return handler;
    }

    public JLabel getInfoLabel() {
        return infoLabel;
    }

    public String getLabel() {
        return label;
    }

    public JavaBean getModel() {
        return model;
    }

    public String getProperty() {
        return property;
    }

    public JButton getResetText() {
        return resetText;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JTextArea getTextEditor() {
        return textEditor;
    }

    public JScrollPane getTextScrollPane() {
        return textScrollPane;
    }

    public String getTitle() {
        return title;
    }

    public JLabel getTitleLabel() {
        return titleLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLabel(String label) {
        String oldValue = this.label;
        this.label = label;
        firePropertyChange(PROPERTY_LABEL, oldValue, label);
    }

    public void setModel(JavaBean model) {
        JavaBean oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(resetText);
    }

    protected void addChildrenToColumnHeader() {
        columnHeader.add($JPanel0, BorderLayout.WEST);
        columnHeader.add(actionsLeft, BorderLayout.EAST);
    }

    protected void addChildrenToTextScrollPane() {
        textScrollPane.getViewport().add(textEditor);
    }

    protected void addChildrenToTop() {
        add(textScrollPane, BorderLayout.CENTER);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createColumnHeader() {
        $objectMap.put("columnHeader", columnHeader = new JPanel());
        
        columnHeader.setName("columnHeader");
        columnHeader.setLayout(new BorderLayout());
    }

    protected void createInfoLabel() {
        $objectMap.put("infoLabel", infoLabel = new JLabel());
        
        infoLabel.setName("infoLabel");
    }

    protected void createLabel() {
        $objectMap.put("label", label = null);
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createResetText() {
        $objectMap.put("resetText", resetText = new JButton());
        
        resetText.setName("resetText");
        resetText.setFocusTraversalKeysEnabled(false);
        resetText.setOpaque(false);
        resetText.setFocusable(false);
        resetText.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetText"));
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JTextArea());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
        textEditor.setLineWrap(true);
        textEditor.setWrapStyleWord(true);
        textEditor.setRows(5);
        textEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textEditor"));
    }

    protected void createTextScrollPane() {
        $objectMap.put("textScrollPane", textScrollPane = new JScrollPane());
        
        textScrollPane.setName("textScrollPane");
        textScrollPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textScrollPane"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTitleLabel() {
        $objectMap.put("titleLabel", titleLabel = new JLabel());
        
        titleLabel.setName("titleLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new BigTextEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createModel();
        createProperty();
        createTitle();
        createLabel();
        createResetTip();
        createTextScrollPane();
        createTextEditor();
        createColumnHeader();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout(3, 3));
        createTitleLabel();
        createInfoLabel();
        createActionsLeft();
        createResetText();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_LABEL_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                titleLabel.setText(SwingUtil.getStringValue(getTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INFO_LABEL_TOOL_TIP_TEXT, true ,"label") {
        
            @Override
            public void processDataBinding() {
                infoLabel.setToolTipText(SwingUtil.getStringValue(getLabel()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_TOOL_TIP_TEXT, true ,"resetTip") {
        
            @Override
            public void processDataBinding() {
                resetText.setToolTipText(getResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_TEXT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetText.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToTextScrollPane();
        addChildrenToColumnHeader();
        // inline complete setup of $JPanel0
        $JPanel0.add(titleLabel, BorderLayout.WEST);
        $JPanel0.add(infoLabel, BorderLayout.CENTER);
        addChildrenToActionsLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 6 property setters
        textScrollPane.setColumnHeaderView(columnHeader);
        infoLabel.setIcon(SwingUtil.getUIManagerActionIcon("info"));
        resetText.setIcon(SwingUtil.getUIManagerActionIcon("text-reset"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
