/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.temperature;

import io.ultreia.java4all.jaxx.JaxxWidgetsTemperatureI18nEnumHelper;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorConfig;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

public class TemperatureEditorModel
extends AbstractSerializableBean {
    static final String PROPERTY_FORMAT = "format";
    static final String PROPERTY_STORAGE_TEMPERATURE = "storageTemperature";
    static final String PROPERTY_TEMPERATURE = "temperature";
    private static final long serialVersionUID = -3883079504284754230L;
    private TemperatureEditorConfig config;
    private TemperatureFormat format;
    private Float temperature;
    private Float storageTemperature;
    private Object bean;
    private boolean adjusting;

    public TemperatureEditorConfig getConfig() {
        return this.config;
    }

    public void setConfig(TemperatureEditorConfig config) {
        this.config = config;
    }

    public String getLabel() {
        return this.config.getLabel() + " (" + JaxxWidgetsTemperatureI18nEnumHelper.getLabel(this.format) + ")";
    }

    public TemperatureFormat getFormat() {
        return this.format;
    }

    public void setFormat(TemperatureFormat format) {
        TemperatureFormat oldValue = this.getFormat();
        this.format = format;
        this.firePropertyChange(PROPERTY_FORMAT, (Object)oldValue, (Object)format);
        this.adjusting = true;
        try {
            this.setStorageTemperature(this.storageTemperature);
        }
        finally {
            this.adjusting = false;
        }
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        Float oldTemperature = this.getTemperature();
        this.temperature = temperature;
        this.firePropertyChange(PROPERTY_TEMPERATURE, oldTemperature, temperature);
        if (!this.adjusting) {
            Float oldStorageTemperature = this.getStorageTemperature();
            this.storageTemperature = this.format.convert(temperature, this.config.getStorageFormat());
            this.firePropertyChange(PROPERTY_STORAGE_TEMPERATURE, oldStorageTemperature, this.storageTemperature);
        }
    }

    private Float getStorageTemperature() {
        return this.storageTemperature;
    }

    void setStorageTemperature(Float storageTemperature) {
        this.storageTemperature = storageTemperature;
        if (this.config != null) {
            Float oldTemperature = this.getTemperature();
            this.temperature = this.config.getStorageFormat().convert(storageTemperature, this.format);
            this.firePropertyChange(PROPERTY_TEMPERATURE, oldTemperature, this.temperature);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}

