/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.temperature;

import io.ultreia.java4all.lang.Setters;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.swing.JLabel;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditor;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorConfig;
import org.nuiton.jaxx.widgets.temperature.TemperatureEditorModel;
import org.nuiton.jaxx.widgets.temperature.TemperatureFormat;

public class TemperatureEditorHandler
implements UIHandler<TemperatureEditor> {
    private TemperatureEditor ui;

    public void beforeInit(TemperatureEditor ui) {
        this.ui = ui;
        TemperatureEditorModel model = new TemperatureEditorModel();
        model.setFormat(TemperatureFormat.C);
        ui.setContextValue(model);
    }

    public void afterInit(TemperatureEditor ui) {
    }

    public void init(JLabel label) {
        Objects.requireNonNull(label, "No label, can't init.");
        TemperatureEditorModel model = this.ui.getModel();
        TemperatureEditorConfig config = model.getConfig();
        Objects.requireNonNull(config, "No config in editor, can't init.");
        String property = config.getProperty();
        Object bean = model.getBean();
        this.ui.getEditor().init();
        this.ui.getEditor().getModel().addPropertyChangeListener("numberValue", evt -> model.setTemperature((Float)evt.getNewValue()));
        Method mutator = Setters.getMutator((Object)bean, (String)property);
        Objects.requireNonNull(mutator, "could not find mutator for " + property);
        model.addPropertyChangeListener("storageTemperature", new ModelPropertyChangeListener(bean, mutator));
        model.addPropertyChangeListener("format", evt -> label.setText(model.getLabel()));
        label.setText(model.getLabel());
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final Object bean;
        private final Method mutator;

        private ModelPropertyChangeListener(Object bean, Method mutator) {
            this.bean = bean;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.mutator.invoke(this.bean, evt.getNewValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

