package org.nuiton.jaxx.widgets.temperature;

/*-
 * #%L
 * JAXX :: Widgets Temperature
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Locale;
import javax.annotation.Generated;

import static org.nuiton.i18n.I18n.l;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;


@Generated(value = "Generated by org.nuiton.i18n.plugin.parser.ParseJavaEnumerationsMojo",date = "Thu Aug 02 16:05:34 UTC 2018")
public class I18nEnumHelper {

    public static <E extends Enum<E>> String getLabel(E e) {
        return t(getLabelKey(e));
    }

    public static <E extends Enum<E>> String getLabel(Locale locale, E e) {
        return l(locale, getLabelKey(e));
    }

    protected static <E extends Enum<E>> String getLabelKey(E e) {
        return "enum." + removeAnonymousSuffix(e.getClass().getName()) + "." + e.name();
    }

    public static <E extends Enum<E>> String getDescription(E e) {
        return t(getDescriptionKey(e));
    }

    public static <E extends Enum<E>> String getDescription(Locale locale, E e) {
        return l(locale, getDescriptionKey(e));
    }

    protected static <E extends Enum<E>> String getDescriptionKey(E e) {
        return "enum." + removeAnonymousSuffix(e.getClass().getName()) + "." + e.name() + ".description";
    }


    protected static String removeAnonymousSuffix(String className) {
        return className.contains("$") ? className.substring(0, className.indexOf("$")) : className;
    }
}
