/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.status;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Timer;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.status.StatusMessagePanel;

public class StatusMessagePanelHandler
implements UIHandler<StatusMessagePanel> {
    protected StatusMessagePanel ui;
    protected Color statusForeground;
    protected String statusReferenceContent;
    protected Timer timer;

    public void init() {
        if (this.ui.isShowBusy().booleanValue()) {
            Dimension dim = new Dimension(30, 15);
            this.ui.busyWidget.setMaximumSize(dim);
            this.ui.busyWidget.setMinimumSize(dim);
        }
    }

    public void clearStatus() {
        this.stopStatusFader(this.ui);
        this.ui.getStatusLabel().setText(" ");
    }

    public void setStatus(String status) {
        if (status != null) {
            this.stopStatusFader(this.ui);
            this.ui.getStatusLabel().setText(status);
        }
        if (!this.ui.isBusy().booleanValue()) {
            this.startStatusFader(this.ui);
        }
    }

    protected void fadeStatus(StatusMessagePanel ui) {
        for (int i = 0; i < 8; ++i) {
            if (!this.statusReferenceContent.equals(ui.getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = ui.getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(), currentForeground.getGreen(), currentForeground.getBlue(), currentForeground.getAlpha() - 25);
            ui.getStatusLabel().setForeground(newColor);
            ui.getStatusLabel().repaint();
        }
    }

    protected void startStatusFader(StatusMessagePanel ui) {
        this.statusReferenceContent = ui.getStatusLabel().getText();
        int millisecondsPerMinute = 5000;
        this.timer = new Timer(millisecondsPerMinute, ui);
        this.timer.setRepeats(false);
        this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
        this.timer.start();
    }

    protected void stopStatusFader(StatusMessagePanel ui) {
        if (this.timer != null) {
            this.timer.stop();
            ui.getStatusLabel().setForeground(this.statusForeground);
        }
    }

    public void beforeInit(StatusMessagePanel ui) {
        this.ui = ui;
    }

    public void afterInit(StatusMessagePanel ui) {
        this.init();
    }
}

