package org.nuiton.jaxx.widgets.status;

/*-
 * #%L
 * JAXX :: Widgets Status
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class ClockWidget extends JLabel implements ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DELAY = "delay";
    public static final String PROPERTY_PATTERN = "pattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Ty27TQBS9SZumTXkUkFiwQIUGiniMYR3EQ6kqWhkqUSQqsmESD45TZzzMXBN30wULdvwAC7ZsUP+hYoXEhm3+AamfwB07jSOUhEIWtnVz5sy555779ReUjIbbkfaZjAOMJOvwJGE6lhh0Bdt8vLOz1eyIFq4J09KBwkhD9isUodiARW9YNwis4RKTkzE5lskZMDn1qKsiKeQIUc2FisG9UJi2EIhwY+LhljHO9hBZS1SsB3eNVT3urh8f7vULYu1TESBRJH+W2r71DwR517MuFAMP4bzb4e+4E3LpkzgdSJ8aOm1r9ZAb84x3xVvYh7ILc4prIkO481/2pHQpVaIQ5qubLm+K8C7CzT/19wLPF2iYQY6xYfUwau2+TGtKpQxzCCVPhHwP4ZxVyqx6tiFR+ELnmLLiiEJLhKUclfU4QmSF6wFRwkyP/mUvbI0wGq5PMpeGyfJh5r4WGlDSMZURVibnyEbhOaGyEKxMDoG9JgW+P9jXX3pH/ePJz5C45b+dGgk5jUHpSFGrgdV2Nht7jEHoPOWq1oAFI0LakHQDVqcr3x4gST2pyEZgmdgTbtrEVir3D79dfP1zBorrUAkj7q1zi9+ABWxrciwKvUQ9fJSKO9Wbp+eSlYlQafLWrq+jWFI0z9z3OPLlZiA9GsqDhJxane7UUNjB1tH3zx+vHR67VSCd1ZOczB0rvYK5QIaBFOmmDJZg7GYsKiNiL8oTPi7zBfuuqEHyLqXPy2M9eBNpkXlgMVeS2L6upl3Yr+qJmbIlmUJygUh+A5f6PN49BQAA";
    private static final Logger log = LogManager.getLogger(ClockWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Integer delay;
    protected String pattern;
    protected Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ClockWidget $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_DELAY, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                timer = new Timer((Integer) evt.getNewValue(), ClockWidget.this);
            }
        });
    }
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        update();
    }
    
    /** Adds a feature to the Notify attribute of the Clock object */
    @Override
    public void addNotify() {
        super.addNotify();
        update();
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        timer.stop();
        super.removeNotify();
    }
    
    protected void update() {
        DateFormat format = new SimpleDateFormat(pattern);
        setText(format.format(new Date()));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ClockWidget(Icon param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, Icon param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(String param0) {
        super(param0);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(String param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(Icon param0) {
        super(param0);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, Icon param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget() {
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(String param0, Icon param1, int param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1, Icon param2, int param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Integer getDelay() {
        return delay;
    }

    public String getPattern() {
        return pattern;
    }

    public Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDelay(Integer delay) {
        Integer oldValue = this.delay;
        this.delay = delay;
        firePropertyChange(PROPERTY_DELAY, oldValue, delay);
    }

    public void setPattern(String pattern) {
        String oldValue = this.pattern;
        this.pattern = pattern;
        firePropertyChange(PROPERTY_PATTERN, oldValue, pattern);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDelay() {
        $objectMap.put("delay", delay = 60000);
    }

    protected void createPattern() {
        $objectMap.put("pattern", pattern = "HH:mm");
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = new Timer(delay,this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JLabel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JLabel0", $JLabel0);
        createDelay();
        createPattern();
        createTimer();
        // inline creation of $JLabel0
        setName("$JLabel0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
        timer.setDelay(delay);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
