/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.lang.Setters;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableListModel;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.jaxx.runtime.swing.renderer.FilteredDecoratorListCellRenderer;
import org.nuiton.jaxx.widgets.BeanUIUtil;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;
import org.nuiton.jaxx.widgets.select.FilterableDoubleListConfig;
import org.nuiton.jaxx.widgets.select.FilterableDoubleListModel;

public class FilterableDoubleListHandler<O>
implements UIHandler<FilterableDoubleList<O>> {
    private static final Logger log = LogManager.getLogger(FilterableDoubleListHandler.class);
    private FilterableDoubleList<O> ui;
    private final BeanUIUtil.PopupHandler<O> popupHandler = new BeanUIUtil.PopupHandler<O>(){

        public JPopupMenu getPopup() {
            return FilterableDoubleListHandler.this.ui.getPopup();
        }

        public JComponent getInvoker() {
            return FilterableDoubleListHandler.this.ui.getDisplayDecorator();
        }
    };
    private Decorator decorator;

    public void beforeInit(FilterableDoubleList<O> ui) {
        this.ui = ui;
        FilterableDoubleListConfig config = new FilterableDoubleListConfig();
        FilterableDoubleListModel model = new FilterableDoubleListModel(config);
        ui.setContextValue(model);
    }

    public void afterInit(FilterableDoubleList<O> ui) {
    }

    public void addFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().addFilter(filter);
    }

    public void removeFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().removeFilter(filter);
    }

    public void clearFilters() {
        this.ui.getModel().getUniverseModel().clearFilters();
    }

    public void refreshFilteredElements() {
        this.ui.getModel().getUniverseModel().refreshFilteredElements();
    }

    public void onUniverseListClicked(MouseEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            Object item = this.ui.getModel().getUniverseModel().getElementAt(index);
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(item);
            this.addToSelected(items);
        }
    }

    public void addToSelected(List<O> items) {
        this.ui.getModel().addToSelected(items);
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    public void onSelectedListClicked(MouseEvent event) {
        if (!this.ui.isEnabled()) {
            return;
        }
        JList<O> selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(this.ui.getModel().getSelectedModel().getElementAt(index));
            this.ui.getModel().removeFromSelected(items);
            this.sortData();
        }
    }

    public void onKeyPressedOnUniverseList(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int lastIndice = this.ui.getUniverseList().getSelectionModel().getLeadSelectionIndex();
            this.ui.getAddAction().doClick();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            }
        }
    }

    public void onKeyPressedOnSelectedList(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int lastIndice = this.ui.getSelectedList().getSelectionModel().getLeadSelectionIndex();
            this.ui.getRemoveAction().doClick();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            }
        }
    }

    public void selectFirstRowIfNoSelection(FocusEvent e) {
        JList source = (JList)e.getSource();
        if (source.isSelectionEmpty()) {
            source.setSelectedIndex(0);
        }
    }

    public JPopupMenu getSelectedListPopup(boolean showIt) {
        JPopupMenu result = showIt ? this.ui.getSelectedListPopup() : null;
        return result;
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void init(Decorator decorator, List<O> universe, List<O> selected) {
        this.init(decorator, decorator, universe, selected);
    }

    public void init(Decorator decorator, Decorator decorator2, List<O> universe, List<O> selected) {
        String property;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.decorator = decorator;
        FilterableDoubleListModel<O> model = this.ui.getModel();
        this.ui.addPropertyChangeListener("enabled", e -> {
            boolean newValue = (Boolean)e.getNewValue();
            if (!newValue) {
                this.ui.getUniverseList().getSelectionModel().clearSelection();
                this.ui.getSelectedList().getSelectionModel().clearSelection();
            }
        });
        FilterableDoubleListConfig<O> config = model.getConfig();
        Object bean = model.getBean();
        if (bean != null && (property = config.getProperty()) != null) {
            Method mutator = Setters.getMutator((Object)bean, (String)property);
            Objects.requireNonNull(mutator, "could not find mutator for " + property);
            model.addPropertyChangeListener("selected", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener(model, mutator, filterableDoubleListModel -> true));
        }
        if (config.isShowListLabel()) {
            JLabel universeListHeader = new JLabel();
            universeListHeader.setText(config.getUniverseLabel());
            this.ui.getUniverseListPane().setColumnHeaderView(universeListHeader);
            JLabel selectedListHeader = new JLabel();
            selectedListHeader.setText(config.getSelectedLabel());
            this.ui.getSelectedListPane().setColumnHeaderView(selectedListHeader);
            JLabel label = new JLabel(config.getLabel());
            this.ui.getBeforeFilterPanel().add(label);
        }
        this.ui.getModel().setUniverse(universe);
        this.setSelected(selected);
        JList<O> universeList = this.ui.getUniverseList();
        final FilteredDecoratorListCellRenderer universeListCellRenderer = new FilteredDecoratorListCellRenderer(this.decorator);
        universeList.setCellRenderer((ListCellRenderer<O>)universeListCellRenderer);
        universeList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            this.ui.getModel().setAddEnabled(!source.isSelectionEmpty());
        });
        final JaxxFilterableListModel<O> filterModel = this.ui.getModel().getUniverseModel();
        filterModel.setDecorator(this.decorator);
        this.ui.getFilterField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }
        });
        JList<O> selectedList = this.ui.getSelectedList();
        if (decorator2 == null) {
            decorator2 = this.decorator;
        }
        selectedList.setCellRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(decorator2));
        selectedList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            FilterableDoubleListModel<O> model1 = this.ui.getModel();
            if (!e.getValueIsAdjusting()) {
                boolean removeEnabled = !source.isSelectionEmpty();
                model1.setRemoveEnabled(removeEnabled);
                int minSelectionIndex = source.getMinSelectionIndex();
                int maxSelectionIndex = source.getMaxSelectionIndex();
                boolean oneSelection = minSelectionIndex == maxSelectionIndex;
                boolean upEnabled = removeEnabled && oneSelection && minSelectionIndex > 0;
                model1.setSelectedUpEnabled(upEnabled);
                boolean downEnabled = removeEnabled && oneSelection && minSelectionIndex + 1 < model1.getSelectedListSize();
                model1.setSelectedDownEnabled(downEnabled);
            }
        });
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.popupHandler.preparePopup(null, null, config.getI18nPrefix(), null, (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), (AbstractButton)this.ui.getSortUp(), (AbstractButton)this.ui.getSortDown(), this.decorator);
        indexes.setSelectedButton((Object)this.ui.getIndex());
        this.sortData();
        this.ui.addPropertyChangeListener("index", evt -> this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue()));
        this.ui.addPropertyChangeListener("reverseSort", evt -> this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue()));
        this.ui.addPropertyChangeListener("highlightFilterText", evt -> this.setHighlightFilterText((Boolean)evt.getNewValue()));
        this.ui.processDataBinding("selectedList.componentPopupMenu");
    }

    protected void setSelected(Collection<O> selected) {
        this.ui.getModel().setSelected(selected);
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        log.debug("check state : <" + oldValue + " to " + newValue + ">");
        this.updateUI(this.ui.getIndex(), newValue);
        if (this.ui.getModel().getConfig().isAutoSortSelectedList()) {
            this.sortSelectedList();
        }
    }

    protected void setHighlightFilterText(Boolean newValue) {
        FilteredDecoratorListCellRenderer universeListCellRenderer = (FilteredDecoratorListCellRenderer)this.ui.getUniverseList().getCellRenderer();
        universeListCellRenderer.setHighlightFilterText(newValue.booleanValue());
        this.ui.getUniverseList().repaint();
    }

    protected void updateUI(int index, boolean reversesort) {
        if (this.decorator == null) {
            return;
        }
        this.decorator.setIndex(index);
        List data = this.ui.getModel().getUniverseModel().toList();
        try {
            this.decorator.sort(data, index, reversesort);
        }
        catch (Exception eee) {
            log.warn(eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getUniverseList(), (Collection)data, null);
    }

    protected void sortSelectedList() {
        if (this.decorator == null) {
            return;
        }
        List data = this.ui.getModel().getSelectedModel().toList();
        try {
            this.decorator.sort(data, this.ui.getIndex().intValue(), this.ui.isReverseSort().booleanValue());
        }
        catch (Exception eee) {
            log.warn(eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getSelectedList(), (Collection)data, null);
    }

    public Decorator getDecorator() {
        return this.decorator;
    }
}

