/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import io.ultreia.java4all.lang.Setters;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableListModel;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.jaxx.runtime.swing.renderer.FilteredDecoratorListCellRenderer;
import org.nuiton.jaxx.widgets.BeanUIUtil;
import org.nuiton.jaxx.widgets.select.BeanDoubleList;
import org.nuiton.jaxx.widgets.select.BeanDoubleListModel;

public class BeanDoubleListHandler<O>
implements PropertyChangeListener,
UIHandler<BeanDoubleList<O>> {
    private static final Logger log = LogManager.getLogger(BeanDoubleListHandler.class);
    protected Method mutator;
    protected BeanDoubleList<O> ui;
    private final BeanUIUtil.PopupHandler<O> popupHandler = new BeanUIUtil.PopupHandler<O>(){

        public JPopupMenu getPopup() {
            return BeanDoubleListHandler.this.ui.getPopup();
        }

        public JComponent getInvoker() {
            return BeanDoubleListHandler.this.ui.getChangeDecorator();
        }
    };
    protected MultiJXPathDecorator<O> decorator;

    public JPopupMenu getSelectedListPopup(boolean showIt) {
        JPopupMenu result = showIt ? this.ui.getSelectedListPopup() : null;
        return result;
    }

    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        this.init(decorator, decorator, universe, selected);
    }

    public void init(JXPathDecorator<O> decorator, JXPathDecorator<O> decorator2, List<O> universe, List<O> selected) {
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.decorator = BeanUIUtil.createDecorator(decorator);
        BeanDoubleListModel uiModel = this.ui.getModel();
        uiModel.setUseMultiSelect(this.ui.getUseMultiSelect());
        uiModel.setUniverse(universe);
        uiModel.setSelected(selected);
        JList<O> universeList = this.ui.getUniverseList();
        JList<O> selectedList = this.ui.getSelectedList();
        uiModel.addCanRemoveItemsPredicate(o -> !o.isEmpty());
        final FilteredDecoratorListCellRenderer universeListCellRenderer = new FilteredDecoratorListCellRenderer(this.decorator);
        universeList.setCellRenderer((ListCellRenderer<O>)universeListCellRenderer);
        decorator2 = decorator2 != null ? BeanUIUtil.createDecorator(decorator2) : this.decorator;
        selectedList.setCellRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(decorator2));
        universeList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            uiModel.setAddEnabled(!source.isSelectionEmpty());
        });
        selectedList.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.recomputeButtonStates();
            }
        });
        selectedList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                BeanDoubleListHandler.this.fireSelectionUpdate();
            }
        });
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.popupHandler.preparePopup(null, null, this.ui.getI18nPrefix(), null, (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), (AbstractButton)this.ui.getSortUp(), (AbstractButton)this.ui.getSortDown(), this.decorator);
        this.ui.addPropertyChangeListener(this);
        final JaxxFilterableListModel<O> filterModel = uiModel.getUniverseModel();
        filterModel.setDecorator(this.decorator);
        this.ui.getFilterField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String text = BeanDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }
        });
        indexes.setSelectedButton((Object)this.ui.getIndex());
        this.sortData();
        this.ui.processDataBinding("selectedList.componentPopupMenu");
    }

    public void recomputeButtonStates() {
        int maxSelectionIndex;
        JList<O> selectedList = this.ui.getSelectedList();
        BeanDoubleListModel<O> uiModel = this.ui.getModel();
        List<O> selectedItems = selectedList.getSelectedValuesList();
        boolean removeEnabled = uiModel.computeRemoveEnabled(selectedItems);
        ListSelectionModel selectionModel = selectedList.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        boolean oneSelection = minSelectionIndex == (maxSelectionIndex = selectionModel.getMaxSelectionIndex());
        boolean upEnabled = removeEnabled && oneSelection && minSelectionIndex > 0;
        uiModel.setSelectedUpEnabled(upEnabled);
        boolean downEnabled = removeEnabled && oneSelection && minSelectionIndex + 1 < uiModel.getSelectedListSize();
        uiModel.setSelectedDownEnabled(downEnabled);
    }

    public void setUniverse(List<O> selection) {
        this.ui.getModel().setUniverse(selection);
        this.sortData();
    }

    public void setSelected(List<O> selection) {
        this.ui.getModel().setSelected(selection);
        this.sortData();
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    public void moveUpSelected(O item) {
        this.ui.getModel().moveUpSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    public void moveDownSelected(O item) {
        this.ui.getModel().moveDownSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void setHighlightFilterText(Boolean newValue) {
        FilteredDecoratorListCellRenderer universeListCellRenderer = (FilteredDecoratorListCellRenderer)this.ui.getUniverseList().getCellRenderer();
        universeListCellRenderer.setHighlightFilterText(newValue.booleanValue());
        this.ui.getUniverseList().repaint();
    }

    protected void updateUI(int index, boolean reversesort) {
        this.decorator.setContextIndex(index);
        JaxxFilterableListModel<O> universeModel = this.ui.getModel().getUniverseModel();
        List<Object> data = Arrays.asList(universeModel.toArray());
        try {
            DecoratorUtil.sort(this.decorator, data, (int)index, (boolean)reversesort);
        }
        catch (Exception eee) {
            log.warn(eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getUniverseList(), data, null);
        this.ui.getUniverseList().requestFocus();
    }

    public void onUniverseListClicked(MouseEvent event) {
        JList<O> universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            if (!this.ui.getModel().isAddEnabled()) {
                return;
            }
            O item = universeList.getModel().getElementAt(index);
            this.ui.getModel().addToSelected(item);
            this.sortData();
        }
    }

    public void onSelectedListClicked(MouseEvent event) {
        JList<O> selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            if (!this.ui.getModel().isRemoveEnabled()) {
                return;
            }
            O item = selectedList.getModel().getElementAt(index);
            this.ui.getModel().removeFromSelected(item);
            this.sortData();
        }
    }

    public void select() {
        List<O> selection = this.ui.getUniverseList().getSelectedValuesList();
        this.ui.getModel().addToSelected(selection);
        this.ui.getUniverseList().clearSelection();
        this.sortData();
    }

    public void unselect() {
        List<O> selection = this.ui.getSelectedList().getSelectedValuesList();
        this.ui.getModel().removeFromSelected(selection);
        this.ui.getSelectedList().clearSelection();
        this.sortData();
    }

    protected void fireSelectionUpdate() {
        if (this.ui.getBean() != null) {
            BeanUIUtil.invokeMethod((Method)this.getMutator(), (Object)this.ui.getBean(), (Object[])new Object[]{this.ui.getModel().getSelected()});
        }
    }

    public Method getMutator() {
        if (this.mutator == null && this.ui.getBackground() != null && this.ui.getProperty() != null) {
            this.mutator = Setters.getMutator((Object)this.ui.getBean(), (String)this.ui.getProperty());
        }
        return this.mutator;
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    public Class<O> getBeanType() {
        Class<O> result = this.ui.getBeanType();
        if (result == null) {
            result = this.decorator == null ? null : this.decorator.getType();
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
        } else if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
        } else if ("highlightFilterText".equals(propertyName)) {
            this.setHighlightFilterText((Boolean)evt.getNewValue());
        } else if ("useMultiSelect".equals(propertyName)) {
            this.ui.getModel().setUseMultiSelect((Boolean)evt.getNewValue());
        }
    }

    public void addFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().addFilter(filter);
    }

    public void removeFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().removeFilter(filter);
    }

    public void clearFilters() {
        this.ui.getModel().getUniverseModel().clearFilters();
    }

    public void refreshFilteredElements() {
        this.ui.getModel().getUniverseModel().refreshFilteredElements();
    }

    public void onKeyPressedOnUniverseList(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int lastIndice = this.ui.getUniverseList().getSelectionModel().getLeadSelectionIndex();
            this.select();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            } else {
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void onKeyPressedOnSelectedList(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int lastIndice = this.ui.getSelectedList().getSelectionModel().getLeadSelectionIndex();
            this.unselect();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void selectFirstRowIfNoSelection(FocusEvent e) {
        JList source = (JList)e.getSource();
        if (source.isSelectionEmpty()) {
            source.setSelectedIndex(0);
        }
    }

    public void beforeInit(BeanDoubleList<O> ui) {
        this.ui = ui;
    }

    public void afterInit(BeanDoubleList<O> ui) {
    }
}

