/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.lang.Setters;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableComboBoxModel;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.jaxx.widgets.BeanUIUtil;
import org.nuiton.jaxx.widgets.select.BeanFilterableComboBox;
import org.nuiton.jaxx.widgets.select.actions.BeanFilterableComboBoxShowPopupAction;

public class BeanFilterableComboBoxHandler<O>
implements PropertyChangeListener,
UIHandler<BeanFilterableComboBox<O>> {
    public static final Logger log = LogManager.getLogger(BeanFilterableComboBoxHandler.class);
    private final KeyAdapter documentKeyListener = new KeyAdapter(){
        ImmutableSet<Integer> codesToSkip = ImmutableSet.of((Object)112, (Object)113, (Object)114, (Object)115, (Object)116, (Object)117, (Object[])new Integer[]{118, 119, 120, 121, 27, 9, 10});

        @Override
        public void keyPressed(KeyEvent e) {
            if (!BeanFilterableComboBoxHandler.this.enabled || !BeanFilterableComboBoxHandler.this.ui.isEnabled()) {
                e.consume();
                return;
            }
            if (e.isControlDown() || e.isShiftDown() || e.isAltDown() || e.isAltGraphDown()) {
                return;
            }
            JComboBox combobox = BeanFilterableComboBoxHandler.this.ui.getCombobox();
            log.debug(BeanFilterableComboBoxHandler.this.ui.getName() + "--keyPressed: " + e.getKeyCode());
            if (!combobox.isPopupVisible() && 10 == e.getKeyCode()) {
                combobox.showPopup();
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            boolean tabToSelect;
            if (!BeanFilterableComboBoxHandler.this.enabled) {
                e.consume();
                return;
            }
            if (e.isControlDown() || e.isShiftDown() || e.isAltDown() || e.isAltGraphDown()) {
                return;
            }
            log.debug("permanent focus owner: " + FocusManager.getCurrentManager().getPermanentFocusOwner());
            log.debug("focus owner: " + FocusManager.getCurrentManager().getFocusOwner());
            if (!Objects.equals(FocusManager.getCurrentManager().getPermanentFocusOwner(), BeanFilterableComboBoxHandler.this.ui.getCombobox().getEditor().getEditorComponent())) {
                e.consume();
                return;
            }
            log.error("keyReleased: " + e.getKeyCode());
            JComboBox combobox = BeanFilterableComboBoxHandler.this.ui.getCombobox();
            if (combobox.isPopupVisible() && 27 == e.getKeyCode()) {
                log.debug("ESC , hide popup");
                e.consume();
                combobox.hidePopup();
                return;
            }
            if (!combobox.isPopupVisible() && !this.codesToSkip.contains((Object)e.getKeyCode())) {
                log.debug("Will show popup, keycode: " + e.getKeyCode());
                combobox.showPopup();
            }
            Object selectedItem = BeanFilterableComboBoxHandler.this.ui.getSelectedItem();
            JTextComponent editorComponent = (JTextComponent)BeanFilterableComboBoxHandler.this.ui.getCombobox().getEditor().getEditorComponent();
            String text = editorComponent.getText();
            log.debug("keycode: " + e.getKeyCode() + ", editorText: " + text);
            if (10 == e.getKeyCode()) {
                log.debug("*ENTER* key");
                if (BeanFilterableComboBoxHandler.this.ui.isEnterToSelectUniqueUniverse().booleanValue() && combobox.getItemCount() == 1) {
                    log.error("Auto-select unique result with *ENTER* key");
                    combobox.setSelectedIndex(0);
                    e.consume();
                    combobox.hidePopup();
                    return;
                }
            }
            if ((tabToSelect = BeanFilterableComboBoxHandler.this.ui.isTabToSelect().booleanValue()) && 9 == e.getKeyCode()) {
                Component focusComponent;
                log.debug("*TAB* key");
                if (!BeanFilterableComboBoxHandler.this.acceptTabKeyEvent()) {
                    log.debug("*TAB* key rejected!!!");
                    e.consume();
                    return;
                }
                if (combobox.getItemCount() > 0) {
                    if (BeanFilterableComboBoxHandler.this.selectedIndex != -1) {
                        log.debug("Auto-select with *TAB* key");
                        combobox.setSelectedIndex(BeanFilterableComboBoxHandler.this.selectedIndex);
                    } else if (combobox.getItemCount() == 1) {
                        log.debug("Auto-select unique result with *TAB* key");
                        combobox.setSelectedIndex(0);
                    }
                    combobox.hidePopup();
                    e.consume();
                }
                FocusTraversalPolicy focusTraversalPolicy = BeanFilterableComboBoxHandler.this.ui.getFocusCycleRootAncestor().getFocusTraversalPolicy();
                Component component = focusComponent = e.isShiftDown() ? focusTraversalPolicy.getComponentBefore(BeanFilterableComboBoxHandler.this.ui.getFocusCycleRootAncestor(), combobox.getEditor().getEditorComponent()) : focusTraversalPolicy.getComponentAfter(BeanFilterableComboBoxHandler.this.ui.getFocusCycleRootAncestor(), combobox.getEditor().getEditorComponent());
                if (focusComponent != null) {
                    log.error("Change focus from " + BeanFilterableComboBoxHandler.this.ui.getName());
                    SwingUtilities.invokeLater(focusComponent::requestFocusInWindow);
                }
                return;
            }
            String selectedItemString = BeanFilterableComboBoxHandler.this.getBeanType().isInstance(selectedItem) ? BeanFilterableComboBoxHandler.this.decorator.toString(selectedItem) : JAXXUtil.getStringValue((Object)selectedItem);
            if (selectedItem == null || !selectedItemString.equals(text)) {
                BeanFilterableComboBoxHandler.this.unselectItem();
            }
        }
    };
    private final DocumentListener editorDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        void updateFilter() {
            boolean wasPopupVisible;
            JComboBox comboBox = BeanFilterableComboBoxHandler.this.ui.getCombobox();
            JaxxFilterableComboBoxModel model = (JaxxFilterableComboBoxModel)comboBox.getModel();
            JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
            boolean bl = wasPopupVisible = comboBox.isShowing() && comboBox.isPopupVisible();
            if (wasPopupVisible) {
                comboBox.hidePopup();
            }
            String text = editorComponent.getText();
            if (BeanFilterableComboBoxHandler.this.ui.getSelectedItem() != null) {
                text = "";
            }
            if (log.isDebugEnabled()) {
                log.debug("updateFilter " + text);
            }
            model.setFilterText(text);
            if (wasPopupVisible) {
                comboBox.showPopup();
            }
        }
    };
    private final BeanUIUtil.PopupHandler<O> popupHandler = new BeanUIUtil.PopupHandler<O>(){

        public JPopupMenu getPopup() {
            return BeanFilterableComboBoxHandler.this.ui.getPopup();
        }

        public JComponent getInvoker() {
            return BeanFilterableComboBoxHandler.this.ui.getDisplayDecorator();
        }
    };
    protected BeanFilterableComboBox<O> ui;
    protected Method mutator;
    protected MultiJXPathDecorator<O> decorator;
    protected boolean init;
    private JList<O> jList;
    private int selectedIndex;
    private Object selectedValue;
    private Object oldFocusOwner;
    private boolean enabled = false;
    private boolean tabHit = false;

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.decorator = BeanUIUtil.createDecorator(decorator);
        final JComboBox<O> combobox = this.ui.getCombobox();
        try {
            Field listBox = BasicComboBoxUI.class.getDeclaredField("listBox");
            listBox.setAccessible(true);
            this.jList = (JList)listBox.get(combobox.getUI());
        }
        catch (Exception e2) {
            log.error("Can't get jList...", (Throwable)e2);
        }
        this.jList.addListSelectionListener(e -> {
            this.selectedIndex = this.jList.getSelectedIndex();
            this.selectedValue = this.jList.getSelectedValue();
            log.debug("Selected index: " + this.selectedIndex + " - " + this.selectedValue);
        });
        JAXXFilterableComboBoxEditor editor = new JAXXFilterableComboBoxEditor(this.ui.getCombobox().getEditor());
        combobox.setEditor(editor);
        editor.getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BeanFilterableComboBoxHandler.this.ui.isEnabled()) {
                    combobox.showPopup();
                }
            }
        });
        if (this.ui.isTabToSelect().booleanValue()) {
            editor.getEditorComponent().setFocusTraversalKeysEnabled(false);
        }
        editor.getEditorComponent().addKeyListener(this.documentKeyListener);
        FocusManager.getCurrentManager().addPropertyChangeListener("permanentFocusOwner", this::onFocusChanged);
        combobox.setRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(this.decorator));
        ((JaxxFilterableComboBoxModel)combobox.getModel()).setDecorator(this.decorator);
        combobox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        combobox.addItemListener(e -> {
            Object item = e.getItem();
            if (e.getStateChange() == 1) {
                log.debug("itemStateChanged selected " + item + " - " + (item != null ? item.getClass() : null));
                combobox.getEditor().getEditorComponent().setForeground(null);
                this.ui.setSelectedItem(item);
            } else {
                log.debug("itemStateChanged deselected " + item + " - " + (item != null ? item.getClass() : null));
                combobox.getEditor().getEditorComponent().setForeground(this.ui.getInvalidComboEditorTextColor());
            }
        });
        this.popupHandler.preparePopup(this.ui.getSelectedToolTipText(), this.ui.getNotSelectedToolTipText(), this.ui.getI18nPrefix(), this.ui.getPopupTitleText(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), (AbstractButton)this.ui.getSortUp(), (AbstractButton)this.ui.getSortDown(), this.decorator);
        this.setFilterable(false, this.ui.getFilterable());
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.ui.getData());
    }

    public void addItems(Iterable<O> items) {
        List<O> data = this.ui.getData();
        boolean wasEmpty = CollectionUtils.isEmpty(data);
        for (O item : items) {
            data.add(item);
        }
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
        this.fireEmpty(wasEmpty);
    }

    public void removeItems(Iterable<O> items) {
        List<O> data = this.ui.getData();
        boolean needUpdate = false;
        for (O item : items) {
            boolean remove = data.remove(item);
            if (!remove) continue;
            Object selectedItem = this.ui.getSelectedItem();
            if (item == selectedItem) {
                this.ui.setSelectedItem(null);
            }
            needUpdate = true;
        }
        if (needUpdate) {
            this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
            this.fireEmpty(false);
        }
    }

    public void addItem(O item) {
        this.addItems(Collections.singleton(item));
    }

    public void removeItem(O item) {
        this.removeItems(Collections.singleton(item));
    }

    public void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    public void reset() {
        if (this.ui.getSelectedItem() != null) {
            this.ui.setSelectedItem(null);
        } else {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.setText("");
        }
        JComboBox<O> comboBox = this.ui.getCombobox();
        if (comboBox.isShowing()) {
            comboBox.hidePopup();
        }
    }

    public void focusCombo() {
        if (this.ui.isAutoFocus().booleanValue()) {
            this.ui.combobox.requestFocusInWindow();
        }
    }

    protected void setFilterable(Boolean oldValue, Boolean newValue) {
        if ((oldValue = Boolean.valueOf(oldValue != null && oldValue != false)).equals(newValue = Boolean.valueOf(newValue != null && newValue != false))) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("filterable state : <" + oldValue + " to " + newValue + ">");
        }
        if (!newValue.booleanValue()) {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.getDocument().removeDocumentListener(this.editorDocumentListener);
            ((JaxxFilterableComboBoxModel)this.ui.getCombobox().getModel()).setFilterText(null);
        } else {
            JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
            editorComponent.getDocument().addDocumentListener(this.editorDocumentListener);
            this.editorDocumentListener.changedUpdate(null);
        }
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("check state : <" + oldValue + " to " + newValue + ">");
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void updateUI(int index, boolean reversesort) {
        this.decorator.setContextIndex(index);
        Object previousSelectedItem = this.ui.getSelectedItem();
        if (previousSelectedItem != null) {
            this.ui.getCombobox().setSelectedItem(null);
            this.ui.selectedItem = null;
        }
        List<O> data = this.ui.getData();
        if (this.ui.isSortable().booleanValue() && CollectionUtils.isNotEmpty(data)) {
            try {
                DecoratorUtil.sort(this.decorator, data, (int)index, (boolean)reversesort);
            }
            catch (Exception eee) {
                log.warn(eee.getMessage(), (Throwable)eee);
            }
        }
        SwingUtil.fillComboBox(this.ui.getCombobox(), data, null);
        if (previousSelectedItem != null) {
            this.ui.setSelectedItem(previousSelectedItem);
        }
        this.ui.getCombobox().requestFocus();
    }

    protected void unselectItem() {
        if (this.ui.selectedItem == null) {
            return;
        }
        this.ui.selectedItem = null;
        BeanUIUtil.invokeMethod((Method)this.getMutator(), (Object)this.ui.getBean(), (Object[])new Object[]{null});
    }

    protected void setSelectedItem(O oldValue, O newValue) {
        if (oldValue == null && newValue == null) {
            return;
        }
        if (!this.getBeanType().isInstance(newValue)) {
            newValue = null;
        }
        JTextComponent editorComponent = (JTextComponent)this.ui.getCombobox().getEditor().getEditorComponent();
        editorComponent.setText("");
        if (log.isDebugEnabled()) {
            log.debug(this.ui.getProperty() + " on " + this.getBeanType() + " :: " + oldValue + " to " + newValue);
        }
        BeanUIUtil.invokeMethod((Method)this.getMutator(), (Object)this.ui.getBean(), (Object[])new Object[]{newValue});
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    public Class<O> getBeanType() {
        Class<O> result = this.ui.getBeanType();
        if (result == null) {
            result = this.decorator == null ? null : this.decorator.getType();
        }
        return result;
    }

    protected Method getMutator() {
        if (this.mutator == null && this.ui.getBean() != null && this.ui.getProperty() != null) {
            this.mutator = Setters.getMutator((Object)this.ui.getBean(), (String)this.ui.getProperty());
        }
        return this.mutator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("selectedItem".equals(propertyName)) {
            this.setSelectedItem(evt.getOldValue(), evt.getNewValue());
            return;
        }
        if ("filterable".equals(propertyName)) {
            this.setFilterable((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(null, this.ui.getIndex());
            List list = (List)evt.getOldValue();
            this.fireEmpty(CollectionUtils.isEmpty((Collection)list));
        }
    }

    protected void fireEmpty(boolean wasEmpty) {
        this.ui.firePropertyChange("empty", wasEmpty, this.isEmpty());
    }

    public void beforeInit(BeanFilterableComboBox<O> ui) {
        this.ui = ui;
    }

    public void afterInit(BeanFilterableComboBox<O> ui) {
        BeanFilterableComboBoxShowPopupAction.init(ui, null, new BeanFilterableComboBoxShowPopupAction());
    }

    private boolean acceptTabKeyEvent() {
        if (!this.enabled) {
            log.debug("Reject TAB: not enabled: " + this.ui.getName());
            return false;
        }
        if (this.oldFocusOwner == null) {
            return true;
        }
        if (!(this.oldFocusOwner instanceof JTextField)) {
            if (this.tabHit) {
                return true;
            }
            this.tabHit = true;
            log.debug("Reject TAB: old focus owner is a matching bean comboBox JTextField editor, so have a hit!!!: " + this.oldFocusOwner);
            return false;
        }
        JTextField old = (JTextField)this.oldFocusOwner;
        if (!Objects.equals("ComboBox.textField", old.getName())) {
            if (this.tabHit) {
                return true;
            }
            this.tabHit = true;
            log.debug("Reject TAB: old focus owner is a matching bean comboBox JTextField editor, so have a hit!!!: " + this.oldFocusOwner);
            return false;
        }
        return true;
    }

    private void onFocusChanged(PropertyChangeEvent event) {
        Object newValue = event.getNewValue();
        if (Objects.equals(newValue, this.ui.getCombobox().getEditor().getEditorComponent())) {
            this.enabled = true;
            this.tabHit = false;
            this.selectedIndex = this.ui.getCombobox().getSelectedIndex();
            log.debug(String.format("Acquire focus on %s, initial selected index: %d", this.ui.getName(), this.selectedIndex));
        } else {
            if (newValue != null) {
                this.oldFocusOwner = newValue;
                log.debug("New other focus owner: " + this.oldFocusOwner);
            }
            if (this.enabled) {
                log.debug("Lost focus on " + this.ui.getName());
                this.enabled = false;
                this.oldFocusOwner = this.ui.getCombobox().getEditor().getEditorComponent();
                log.debug("New other focus owner: " + this.oldFocusOwner);
            }
        }
    }

    class JAXXFilterableComboBoxEditor
    implements ComboBoxEditor {
        final ComboBoxEditor wrapped;
        Object oldItem;

        public JAXXFilterableComboBoxEditor(ComboBoxEditor wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public JTextComponent getEditorComponent() {
            return (JTextComponent)this.wrapped.getEditorComponent();
        }

        @Override
        public Object getItem() {
            JTextComponent editor = this.getEditorComponent();
            Object newValue = editor.getText();
            if (log.isDebugEnabled()) {
                log.debug("getItem " + newValue + " - " + (newValue != null ? newValue.getClass() : null));
            }
            if (this.oldItem != null && BeanFilterableComboBoxHandler.this.getBeanType().isInstance(this.oldItem) && Objects.equals(newValue, BeanFilterableComboBoxHandler.this.decorator.toString(this.oldItem))) {
                newValue = this.oldItem;
            }
            if (log.isDebugEnabled()) {
                log.debug("getItem 2 " + newValue + " - " + (newValue != null ? newValue.getClass() : null));
            }
            return newValue;
        }

        @Override
        public void setItem(Object anObject) {
            if (log.isDebugEnabled()) {
                log.debug("setItem " + anObject + " - " + (anObject != null ? anObject.getClass() : null));
            }
            Object item = anObject;
            if (anObject != null) {
                if (BeanFilterableComboBoxHandler.this.getBeanType().isInstance(anObject)) {
                    item = BeanFilterableComboBoxHandler.this.decorator.toString(anObject);
                    this.oldItem = anObject;
                }
                try {
                    this.wrapped.setItem(item);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void selectAll() {
            this.wrapped.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.wrapped.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.wrapped.removeActionListener(l);
        }
    }
}

