package org.nuiton.jaxx.widgets.select;

/*-
 * #%L
 * JAXX :: Widgets Select
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.ApplicationAction;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.t;

public class FilterableDoubleList<O> extends Table implements BeanTypeAware<O>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_HIGHLIGHT_FILTER_TEXT = "highlightFilterText";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_SELECT_POPUP_ENABLED = "showSelectPopupEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_FILTER_FIELD_LABEL_VISIBLE = "filterFieldLabel.visible";
    public static final String BINDING_FILTER_FIELD_VISIBLE = "filterField.visible";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU = "selectedList.componentPopupMenu";
    public static final String BINDING_SELECTED_LIST_ENABLED = "selectedList.enabled";
    public static final String BINDING_SELECTED_LIST_MODEL = "selectedList.model";
    public static final String BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED = "selectedListMoveDownAction.enabled";
    public static final String BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED = "selectedListMoveUpAction.enabled";
    public static final String BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED = "selectedListRemoveAction.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";
    public static final String BINDING_TOOLBAR_RIGHT_VISIBLE = "toolbarRight.visible";
    public static final String BINDING_UNIVERSE_LIST_ENABLED = "universeList.enabled";
    public static final String BINDING_UNIVERSE_LIST_MODEL = "universeList.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(FilterableDoubleList.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JPanel beforeFilterPanel;
    protected JToggleButton changeDecorator;
    protected JTextField filterField;
    protected JLabel filterFieldLabel;
    protected Boolean filterable;
    protected FilterableDoubleListHandler<O> handler;
    protected Boolean highlightFilterText;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected FilterableDoubleListModel<O> model;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected JButton removeButton;
    protected JButton resetButton;
    protected Boolean reverseSort;
    protected JList<O> selectedList;
    protected JMenuItem selectedListMoveDownAction;
    protected JMenuItem selectedListMoveUpAction;
    protected JScrollPane selectedListPane;
    protected JPopupMenu selectedListPopup;
    protected JMenuItem selectedListRemoveAction;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected Boolean showSelectPopupEnabled;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;
    protected JPanel topPanel;
    protected JList<O> universeList;
    protected JScrollPane universeListPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private FilterableDoubleList<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JXPathDecorator<O> decorator, JXPathDecorator<O> decorator2, List<O> universe, List<O> selected) {
          handler.init(decorator, decorator2, universe, selected);
      }
    
    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        handler.init(decorator, universe, selected);
    }
    
    public Class<O> getBeanType() { return model.getConfig().getBeanType(); }
    
    // Config delegate methods
    public void setBeanType(Class<O> beanType) { model.getConfig().setBeanType(beanType); }
    public void setProperty(String property) { model.getConfig().setProperty(property); }
    public void setUseMultiSelect(boolean useMultiSelect) { model.getConfig().setUseMultiSelect(useMultiSelect); }
    public void setI18nPrefix(String i18nPrefix) { model.getConfig().setI18nPrefix(i18nPrefix); }
    public void setShowListLabel(boolean showListLabel) { model.getConfig().setShowListLabel(showListLabel); }
    public void setUniverseLabel(String universeLabel) { model.getConfig().setUniverseLabel(universeLabel); }
    public void setSelectedLabel(String selectedLabel) { model.getConfig().setSelectedLabel(selectedLabel); }
    
    // Model delegate methods
    public void setBean(Object bean) { model.setBean(bean); }
    public void setUniverse(Collection<O> universe) { model.setUniverse(universe);}
    public void setSelected(Collection<O> selected) { model.setSelected(selected);}

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterableDoubleList() {
        $initialize();
    }

    public FilterableDoubleList(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__changeDecorator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.togglePopup();
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        filterField.setText("");
    }

    public void doActionPerformed__on__selectedListMoveDownAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.moveDownSelected( (O) selectedList.getSelectedValue());
    }

    public void doActionPerformed__on__selectedListMoveUpAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.moveUpSelected( (O) selectedList.getSelectedValue());
    }

    public void doActionPerformed__on__selectedListRemoveAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.unselect();
    }

    public void doFocusGained__on__selectedList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectFirstRowIfNoSelection(event);
    }

    public void doFocusGained__on__selectedListPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectedList.requestFocus();
    }

    public void doFocusGained__on__universeList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectFirstRowIfNoSelection(event);
    }

    public void doFocusGained__on__universeListPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        universeList.requestFocus();
    }

    public void doKeyPressed__on__selectedList(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyPressedOnSelectedList(event);
    }

    public void doKeyPressed__on__universeList(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyPressedOnUniverseList(event);
    }

    public void doMouseClicked__on__selectedList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListClicked(event);
    }

    public void doMouseClicked__on__universeList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListClicked(event);
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeDecorator.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeDecorator.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JPanel getBeforeFilterPanel() {
        return beforeFilterPanel;
    }

    public JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public JTextField getFilterField() {
        return filterField;
    }

    public JLabel getFilterFieldLabel() {
        return filterFieldLabel;
    }

    public Boolean getFilterable() {
        return filterable;
    }

    public FilterableDoubleListHandler<O> getHandler() {
        return handler;
    }

    public Boolean getHighlightFilterText() {
        return highlightFilterText;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public FilterableDoubleListModel<O> getModel() {
        return model;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public JList<O> getSelectedList() {
        return selectedList;
    }

    public JMenuItem getSelectedListMoveDownAction() {
        return selectedListMoveDownAction;
    }

    public JMenuItem getSelectedListMoveUpAction() {
        return selectedListMoveUpAction;
    }

    public JScrollPane getSelectedListPane() {
        return selectedListPane;
    }

    public JPopupMenu getSelectedListPopup() {
        return selectedListPopup;
    }

    public JMenuItem getSelectedListRemoveAction() {
        return selectedListRemoveAction;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public Boolean getShowSelectPopupEnabled() {
        return showSelectPopupEnabled;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    public JPanel getTopPanel() {
        return topPanel;
    }

    public JList<O> getUniverseList() {
        return universeList;
    }

    public JScrollPane getUniverseListPane() {
        return universeListPane;
    }

    public Boolean isFilterable() {
        return filterable !=null && filterable;
    }

    public Boolean isHighlightFilterText() {
        return highlightFilterText !=null && highlightFilterText;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isShowSelectPopupEnabled() {
        return showSelectPopupEnabled !=null && showSelectPopupEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFilterable(Boolean filterable) {
        Boolean oldValue = this.filterable;
        this.filterable = filterable;
        firePropertyChange(PROPERTY_FILTERABLE, oldValue, filterable);
    }

    public void setHighlightFilterText(Boolean highlightFilterText) {
        Boolean oldValue = this.highlightFilterText;
        this.highlightFilterText = highlightFilterText;
        firePropertyChange(PROPERTY_HIGHLIGHT_FILTER_TEXT, oldValue, highlightFilterText);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowSelectPopupEnabled(Boolean showSelectPopupEnabled) {
        Boolean oldValue = this.showSelectPopupEnabled;
        this.showSelectPopupEnabled = showSelectPopupEnabled;
        firePropertyChange(PROPERTY_SHOW_SELECT_POPUP_ENABLED, oldValue, showSelectPopupEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSelectedListPane() {
        selectedListPane.getViewport().add(selectedList);
    }

    protected void addChildrenToSelectedListPopup() {
        selectedListPopup.add(selectedListMoveUpAction);
        selectedListPopup.add(selectedListMoveDownAction);
        selectedListPopup.add(selectedListRemoveAction);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetButton);
    }

    protected void addChildrenToToolbarRight() {
        toolbarRight.add(changeDecorator);
    }

    protected void addChildrenToTopPanel() {
        topPanel.add($JPanel0, BorderLayout.WEST);
        topPanel.add(filterField, BorderLayout.CENTER);
        topPanel.add(toolbarRight, BorderLayout.EAST);
    }

    protected void addChildrenToUniverseListPane() {
        universeListPane.getViewport().add(universeList);
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
    }

    protected void createBeforeFilterPanel() {
        $objectMap.put("beforeFilterPanel", beforeFilterPanel = new JPanel());
        
        beforeFilterPanel.setName("beforeFilterPanel");
        beforeFilterPanel.setLayout(new BorderLayout());
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(t("beandoublelist.action.sort.tip"));
        changeDecorator.setFocusPainted(false);
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterFieldLabel() {
        $objectMap.put("filterFieldLabel", filterFieldLabel = new JLabel());
        
        filterFieldLabel.setName("filterFieldLabel");
    }

    protected void createFilterable() {
        $objectMap.put("filterable", filterable = true);
    }

    protected void createHighlightFilterText() {
        $objectMap.put("highlightFilterText", highlightFilterText = false);
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FilterableDoubleListModel.class));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setToolTipText(t("beandoublelist.action.reset.tip"));
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedList() {
        $objectMap.put("selectedList", selectedList = new JList<O>());
        
        selectedList.setName("selectedList");
        selectedList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__selectedList"));
        selectedList.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__selectedList"));
        selectedList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedList"));
    }

    protected void createSelectedListMoveDownAction() {
        $objectMap.put("selectedListMoveDownAction", selectedListMoveDownAction = new JMenuItem());
        
        selectedListMoveDownAction.setName("selectedListMoveDownAction");
        selectedListMoveDownAction.setText(t("bean.action.selected.move.down"));
        selectedListMoveDownAction.setToolTipText(t("bean.action.selected.move.down.tip"));
        selectedListMoveDownAction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__selectedListMoveDownAction"));
    }

    protected void createSelectedListMoveUpAction() {
        $objectMap.put("selectedListMoveUpAction", selectedListMoveUpAction = new JMenuItem());
        
        selectedListMoveUpAction.setName("selectedListMoveUpAction");
        selectedListMoveUpAction.setText(t("bean.action.selected.move.up"));
        selectedListMoveUpAction.setToolTipText(t("bean.action.selected.move.up.tip"));
        selectedListMoveUpAction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__selectedListMoveUpAction"));
    }

    protected void createSelectedListPane() {
        $objectMap.put("selectedListPane", selectedListPane = new JScrollPane());
        
        selectedListPane.setName("selectedListPane");
        selectedListPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__selectedListPane"));
    }

    protected void createSelectedListPopup() {
        $objectMap.put("selectedListPopup", selectedListPopup = new JPopupMenu());
        
        selectedListPopup.setName("selectedListPopup");
    }

    protected void createSelectedListRemoveAction() {
        $objectMap.put("selectedListRemoveAction", selectedListRemoveAction = new JMenuItem());
        
        selectedListRemoveAction.setName("selectedListRemoveAction");
        selectedListRemoveAction.setText(t("bean.action.selected.remove"));
        selectedListRemoveAction.setToolTipText(t("bean.action.selected.remove.tip"));
        selectedListRemoveAction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__selectedListRemoveAction"));
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = true);
    }

    protected void createShowSelectPopupEnabled() {
        $objectMap.put("showSelectPopupEnabled", showSelectPopupEnabled = true);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setBorderPainted(false);
        toolbarRight.setFloatable(false);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new JPanel());
        
        topPanel.setName("topPanel");
        topPanel.setLayout(new BorderLayout());
    }

    protected void createUniverseList() {
        $objectMap.put("universeList", universeList = new JList<O>());
        
        universeList.setName("universeList");
        universeList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__universeList"));
        universeList.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__universeList"));
        universeList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__universeList"));
    }

    protected void createUniverseListPane() {
        $objectMap.put("universeListPane", universeListPane = new JScrollPane());
        
        universeListPane.setName("universeListPane");
        universeListPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__universeListPane"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        handler = new FilterableDoubleListHandler<>();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createFilterable();
        createShowDecorator();
        createShowReset();
        createShowSelectPopupEnabled();
        createHighlightFilterText();
        createModel();
        createReverseSort();
        createIndex();
        createIndexes();
        createSortGroup();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSelectedListPopup();
        createSelectedListMoveUpAction();
        createSelectedListMoveDownAction();
        createSelectedListRemoveAction();
        createBeforeFilterPanel();
        createTopPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createFilterFieldLabel();
        createToolbarLeft();
        createResetButton();
        createFilterField();
        createToolbarRight();
        createChangeDecorator();
        createUniverseListPane();
        createUniverseList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0,1));
        createAddButton();
        createRemoveButton();
        createSelectedListPane();
        createSelectedList();
        // inline creation of $Table0
        setName("$Table0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 16 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedUpEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveUpAction.setEnabled(model.isSelectedUpEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedUpEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedDownEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveDownAction.setEnabled(model.isSelectedDownEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedDownEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListRemoveAction.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FILTER_FIELD_LABEL_VISIBLE, true ,"filterable") {
        
            @Override
            public void processDataBinding() {
                filterFieldLabel.setVisible(isFilterable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"filterable" ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isFilterable() && isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FILTER_FIELD_VISIBLE, true ,"filterable") {
        
            @Override
            public void processDataBinding() {
                filterField.setVisible(isFilterable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RIGHT_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                toolbarRight.setVisible(isShowDecorator());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNIVERSE_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("universeModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    universeList.setModel(model.getUniverseModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("universeModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UNIVERSE_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                universeList.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                addButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU, true ,"showSelectPopupEnabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setComponentPopupMenu(handler.getSelectedListPopup(isShowSelectPopupEnabled()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedList.setModel(model.getSelectedModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(beforeFilterPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(universeListPane, new GridBagConstraints(0, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(selectedListPane, new GridBagConstraints(2, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToSelectedListPopup();
        addChildrenToTopPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(filterFieldLabel, BorderLayout.WEST);
        $JPanel0.add(toolbarLeft, BorderLayout.EAST);
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
        addChildrenToUniverseListPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(addButton);
        $JPanel1.add(removeButton);
        addChildrenToSelectedListPane();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 16 property setters
        popup.setBorder(new TitledBorder(t("beandoublelist.popup.title")));
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        selectedListMoveUpAction.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-up"));
        selectedListMoveDownAction.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-down"));
        selectedListRemoveAction.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-unselect"));
        filterFieldLabel.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-filter"));
        resetButton.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-reset"));
        changeDecorator.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort"));// late initializer
        
        ApplicationAction.init(this, addButton, org.nuiton.jaxx.widgets.select.actions.FilterableDoubleListAddAction.class);
        ApplicationAction.init(this, removeButton, org.nuiton.jaxx.widgets.select.actions.FilterableDoubleListRemoveAction.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
