/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.select;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableListModel;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.nuiton.jaxx.runtime.swing.renderer.FilteredDecoratorListCellRenderer;
import org.nuiton.jaxx.runtime.util.BeanUtil;
import org.nuiton.jaxx.widgets.DecoratorPopupHandler;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.select.FilterableDoubleList;
import org.nuiton.jaxx.widgets.select.FilterableDoubleListConfig;
import org.nuiton.jaxx.widgets.select.FilterableDoubleListModel;

public class FilterableDoubleListHandler<O extends Serializable>
implements UIHandler<FilterableDoubleList<O>> {
    private static final Log log = LogFactory.getLog(FilterableDoubleListHandler.class);
    private FilterableDoubleList<O> ui;
    private MultiJXPathDecorator<O> decorator;
    private final DecoratorPopupHandler popupHandler = new DecoratorPopupHandler(){

        public JPopupMenu getPopup() {
            return FilterableDoubleListHandler.this.ui.getPopup();
        }

        public JComponent getInvoker() {
            return FilterableDoubleListHandler.this.ui.getChangeDecorator();
        }
    };

    public void beforeInit(FilterableDoubleList<O> ui) {
        this.ui = ui;
        FilterableDoubleListConfig config = new FilterableDoubleListConfig();
        FilterableDoubleListModel model = new FilterableDoubleListModel(config);
        ui.setContextValue(model);
    }

    public void afterInit(FilterableDoubleList<O> ui) {
    }

    public void addFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().addFilter(filter);
    }

    public void removeFilter(Predicate<O> filter) {
        this.ui.getModel().getUniverseModel().removeFilter(filter);
    }

    public void clearFilters() {
        this.ui.getModel().getUniverseModel().clearFilters();
    }

    public void refreshFilteredElements() {
        this.ui.getModel().getUniverseModel().refreshFilteredElements();
    }

    public void onUniverseListClicked(MouseEvent event) {
        JList<O> universeList = this.ui.getUniverseList();
        if (event.getClickCount() == 2) {
            int index = universeList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            Serializable item = (Serializable)this.ui.getModel().getUniverseModel().getElementAt(index);
            ArrayList<Serializable> items = new ArrayList<Serializable>();
            items.add(item);
            this.ui.getModel().addToSelected(items);
        }
    }

    public void onSelectedListClicked(MouseEvent event) {
        JList<O> selectedList = this.ui.getSelectedList();
        if (event.getClickCount() == 2) {
            int index = selectedList.locationToIndex(event.getPoint());
            if (index < 0) {
                return;
            }
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(this.ui.getModel().getSelectedModel().getElementAt(index));
            this.ui.getModel().removeFromSelected(items);
            this.sortData();
        }
    }

    public void select() {
        List<O> selectedValues = this.ui.getUniverseList().getSelectedValuesList();
        this.ui.getModel().addToSelected(selectedValues);
        this.ui.getUniverseList().clearSelection();
    }

    public void unselect() {
        List<O> selectedValues = this.ui.getSelectedList().getSelectedValuesList();
        this.ui.getModel().removeFromSelected(selectedValues);
        this.ui.getSelectedList().clearSelection();
        this.sortData();
    }

    public void onKeyPressedOnUniverseList(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            int lastIndice = this.ui.getUniverseList().getSelectionModel().getLeadSelectionIndex();
            this.select();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
            } else {
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void onKeyPressedOnSelectedList(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            int lastIndice = this.ui.getSelectedList().getSelectionModel().getLeadSelectionIndex();
            this.unselect();
            JList source = (JList)e.getSource();
            if (source.getModel().getSize() > 0) {
                source.setSelectedIndex(Math.min(lastIndice, source.getModel().getSize() - 1));
                this.ui.getSelectedList().requestFocus();
            }
        }
    }

    public void selectFirstRowIfNoSelection(FocusEvent event) {
        JList list = (JList)event.getSource();
        if (list.isSelectionEmpty()) {
            list.setSelectedIndex(0);
        }
    }

    public void moveUpSelected(O item) {
        this.ui.getModel().moveUpSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    public void moveDownSelected(O item) {
        this.ui.getModel().moveDownSelected(item);
        this.ui.getSelectedList().setSelectedValue(item, true);
    }

    public JPopupMenu getSelectedListPopup(boolean showIt) {
        JPopupMenu result = showIt ? this.ui.getSelectedListPopup() : null;
        return result;
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        this.init(decorator, decorator, universe, selected);
    }

    public void init(JXPathDecorator<O> decorator, JXPathDecorator<O> decorator2, List<O> universe, List<O> selected) {
        String property;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.decorator = DecoratorUtil.cloneDecorator(decorator);
        FilterableDoubleListModel<O> model = this.ui.getModel();
        FilterableDoubleListConfig<O> config = model.getConfig();
        Serializable bean = model.getBean();
        if (bean != null && (property = config.getProperty()) != null) {
            Method mutator = BeanUtil.getMutator((Object)bean, (String)property);
            Objects.requireNonNull(mutator, "could not find mutator for " + property);
            model.addPropertyChangeListener("selected", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener(model, mutator, filterableDoubleListModel -> true));
        }
        if (config.isShowListLabel()) {
            JLabel universeListHeader = new JLabel();
            universeListHeader.setText(config.getUniverseLabel());
            this.ui.getUniverseListPane().setColumnHeaderView(universeListHeader);
            JLabel selectedListHeader = new JLabel();
            selectedListHeader.setText(config.getSelectedLabel());
            this.ui.getSelectedListPane().setColumnHeaderView(selectedListHeader);
        }
        this.ui.getModel().setUniverse(universe);
        this.ui.getModel().setSelected(selected);
        JList<O> universeList = this.ui.getUniverseList();
        final FilteredDecoratorListCellRenderer universeListCellRenderer = new FilteredDecoratorListCellRenderer(this.decorator);
        universeList.setCellRenderer((ListCellRenderer<O>)universeListCellRenderer);
        universeList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            this.ui.getModel().setAddEnabled(!source.isSelectionEmpty());
        });
        final JaxxFilterableListModel<O> filterModel = this.ui.getModel().getUniverseModel();
        filterModel.setDecorator(this.decorator);
        this.ui.getFilterField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String text = FilterableDoubleListHandler.this.ui.getFilterField().getText();
                universeListCellRenderer.setFilterText(text);
                filterModel.setFilterText(text);
            }
        });
        JList<O> selectedList = this.ui.getSelectedList();
        decorator2 = decorator2 != null ? DecoratorUtil.cloneDecorator(decorator2) : this.decorator;
        selectedList.setCellRenderer((ListCellRenderer<O>)new DecoratorListCellRenderer(decorator2));
        selectedList.getSelectionModel().addListSelectionListener(e -> {
            ListSelectionModel source = (ListSelectionModel)e.getSource();
            FilterableDoubleListModel<O> model1 = this.ui.getModel();
            if (!e.getValueIsAdjusting()) {
                boolean removeEnabled = !source.isSelectionEmpty();
                model1.setRemoveEnabled(removeEnabled);
                int minSelectionIndex = source.getMinSelectionIndex();
                int maxSelectionIndex = source.getMaxSelectionIndex();
                boolean oneSelection = minSelectionIndex == maxSelectionIndex;
                boolean upEnabled = removeEnabled && oneSelection && minSelectionIndex > 0;
                model1.setSelectedUpEnabled(upEnabled);
                boolean downEnabled = removeEnabled && oneSelection && minSelectionIndex + 1 < model1.getSelectedListSize();
                model1.setSelectedDownEnabled(downEnabled);
            }
        });
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.popupHandler.preparePopup(null, null, config.getI18nPrefix(), null, (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), (AbstractButton)this.ui.getSortUp(), (AbstractButton)this.ui.getSortDown(), this.decorator);
        indexes.setSelectedButton((Object)this.ui.getIndex());
        this.sortData();
        this.ui.addPropertyChangeListener("index", evt -> this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue()));
        this.ui.addPropertyChangeListener("reverseSort", evt -> this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue()));
        this.ui.addPropertyChangeListener("highlightFilterText", evt -> this.setHighlightFilterText((Boolean)evt.getNewValue()));
        this.ui.processDataBinding("selectedList.componentPopupMenu");
    }

    private void sortData() {
        this.updateUI(this.ui.getIndex(), this.ui.isReverseSort());
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        AbstractButton button;
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        if ((button = this.ui.getIndexes().getButton((Object)newValue)) != null) {
            button.setSelected(true);
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    protected void setHighlightFilterText(Boolean newValue) {
        FilteredDecoratorListCellRenderer universeListCellRenderer = (FilteredDecoratorListCellRenderer)this.ui.getUniverseList().getCellRenderer();
        universeListCellRenderer.setHighlightFilterText(newValue.booleanValue());
        this.ui.getUniverseList().repaint();
    }

    protected void updateUI(int index, boolean reversesort) {
        if (this.decorator == null) {
            return;
        }
        this.decorator.setContextIndex(index);
        ArrayList data = this.ui.getModel().getUniverseModel().toList();
        try {
            DecoratorUtil.sort(this.decorator, (List)data, (int)index, (boolean)reversesort);
        }
        catch (Exception eee) {
            log.warn((Object)eee.getMessage(), (Throwable)eee);
        }
        SwingUtil.fillList(this.ui.getUniverseList(), (Collection)data, null);
        this.ui.getUniverseList().requestFocus();
    }
}

