/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.number;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.jaxx.widgets.number.NumberEditorConfig;
import org.nuiton.jaxx.widgets.number.NumberEditorModel;

public class NumberEditorHandler
extends BeanUIHandlerSupport<NumberEditor>
implements UIHandler<NumberEditor> {
    protected static final ImmutableSet<Class<?>> INT_CLASSES = ImmutableSet.of(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, (Object[])new Class[]{BigInteger.class});
    protected static final ImmutableSet<String> NULL_LIMIT_DECIMAL = ImmutableSet.copyOf((Object[])new String[]{"-", ".", "-."});
    protected static final ImmutableSet<String> NULL_LIMIT_INTEGER = ImmutableSet.copyOf((Object[])new String[]{"-"});
    private static final Logger log = LogManager.getLogger(NumberEditorHandler.class);
    private static final String VALIDATE_PROPERTY = "validate";
    private static Map<Class<?>, NumberParserFormatter> numberFactories;
    protected Pattern numberPattern;
    protected NumberParserFormatter numberParserFormatter;

    protected static NumberParserFormatter getNumberFactory(Class<?> numberType) {
        if (numberFactories == null) {
            numberFactories = new HashMap();
            NumberParserFormatter byteSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Byte parse(String textValue) {
                    Byte v = NULL_LIMIT_INTEGER.contains((Object)textValue) ? null : Byte.valueOf(Byte.parseByte(textValue));
                    return v;
                }
            };
            numberFactories.put(Byte.TYPE, byteSupport);
            numberFactories.put(Byte.class, byteSupport);
            NumberParserFormatter shortSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Short parse(String textValue) {
                    Short v = NULL_LIMIT_INTEGER.contains((Object)textValue) ? null : Short.valueOf(Short.parseShort(textValue));
                    return v;
                }
            };
            numberFactories.put(Short.TYPE, shortSupport);
            numberFactories.put(Short.class, shortSupport);
            NumberParserFormatter integerSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Integer parse(String textValue) {
                    Integer v = NULL_LIMIT_INTEGER.contains((Object)textValue) ? null : Integer.valueOf(Integer.parseInt(textValue));
                    return v;
                }
            };
            numberFactories.put(Integer.TYPE, integerSupport);
            numberFactories.put(Integer.class, integerSupport);
            NumberParserFormatter longSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Long parse(String textValue) {
                    Long v = NULL_LIMIT_INTEGER.contains((Object)textValue) ? null : Long.valueOf(Long.parseLong(textValue));
                    return v;
                }
            };
            numberFactories.put(Long.TYPE, longSupport);
            numberFactories.put(Long.class, longSupport);
            NumberParserFormatter floatSupport = new NumberParserFormatter(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Number numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Float parse(String textValue) {
                    Float v;
                    if (NULL_LIMIT_DECIMAL.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Float.valueOf(Float.parseFloat(textValue));
                        if (addSign) {
                            v = Float.valueOf(-v.floatValue());
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Float.TYPE, floatSupport);
            numberFactories.put(Float.class, floatSupport);
            NumberParserFormatter doubleSupport = new NumberParserFormatter(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Number numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Double parse(String textValue) {
                    Double v;
                    if (NULL_LIMIT_DECIMAL.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Double.parseDouble(textValue);
                        if (addSign) {
                            v = -v.doubleValue();
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Double.TYPE, doubleSupport);
            numberFactories.put(Double.class, doubleSupport);
            NumberParserFormatter bigIntegerSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigInteger parse(String textValue) {
                    return new BigInteger(textValue);
                }
            };
            numberFactories.put(BigInteger.class, bigIntegerSupport);
            NumberParserFormatter bigDecimalSupport = new NumberParserFormatter(){

                @Override
                public String format(Number numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigDecimal parse(String textValue) {
                    return new BigDecimal(textValue);
                }
            };
            numberFactories.put(BigDecimal.class, bigDecimalSupport);
        }
        for (Map.Entry<Class<?>, NumberParserFormatter> entry : numberFactories.entrySet()) {
            if (!entry.getKey().equals(numberType)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Could not find a NumberFactory for type " + numberType);
    }

    public void beforeInit(NumberEditor ui) {
        super.beforeInit((JComponent)ui);
        NumberEditorModel model = new NumberEditorModel(new NumberEditorConfig());
        ui.setContextValue(model);
    }

    public void afterInit(NumberEditor ui) {
    }

    public void init(NumberEditor ui) {
        super.init((JComponent)ui);
        NumberEditorModel model = ui.getModel();
        ui.addPropertyChangeListener("showPopupButton", evt -> {
            if (ui.getPopup().isVisible()) {
                this.setPopupVisible(false);
            }
        });
        ui.addPropertyChangeListener("autoPopup", evt -> {
            if (ui.getPopup().isVisible()) {
                this.setPopupVisible(false);
            }
        });
        ui.addPropertyChangeListener("popupVisible", evt -> this.setPopupVisible((Boolean)evt.getNewValue()));
        ui.getTextField().addMouseListener(new PopupListener());
        Number numberValue = model.getNumberValue();
        this.setTextValueFromNumberValue(numberValue);
    }

    protected String getProperty(NumberEditor ui) {
        return ui.getModel().getConfig().getProperty();
    }

    protected void prepareInit(String property) {
        boolean canBeDecimal;
        NumberEditorModel model;
        NumberEditorConfig config;
        Class<?> numberType;
        log.debug(String.format("init NumberEditor %s", ((NumberEditor)this.ui).getName()));
        if (property == null) {
            ((NumberEditor)this.ui).setProperty(((NumberEditor)this.ui).getName());
        }
        Preconditions.checkState(((numberType = (config = (model = ((NumberEditor)this.ui).getModel()).getConfig()).getNumberType()) != null ? 1 : 0) != 0, (Object)("Required a number type on " + this.ui));
        this.numberParserFormatter = NumberEditorHandler.getNumberFactory(numberType);
        log.info("init numberType: " + numberType + " on " + this.ui);
        Boolean useDecimal = config.getUseDecimal();
        boolean bl = canBeDecimal = !INT_CLASSES.contains(numberType);
        if (useDecimal == null) {
            useDecimal = canBeDecimal;
            config.setUseDecimal(useDecimal);
        } else {
            Preconditions.checkState((useDecimal == false || canBeDecimal ? 1 : 0) != 0, (Object)("Can't use decimal with the following number type " + numberType + " on " + this.ui));
        }
        String numberPatternDef = model.getNumberPattern();
        if (StringUtils.isNotEmpty((CharSequence)numberPatternDef)) {
            this.setNumberPattern(numberPatternDef);
        }
        model.addPropertyChangeListener("numberPattern", evt -> {
            String newPattern = (String)evt.getNewValue();
            this.setNumberPattern(newPattern);
            log.info(String.format("set new numberPattern%s", newPattern));
            this.numberPattern = StringUtils.isEmpty((CharSequence)newPattern) ? null : Pattern.compile(newPattern);
        });
        model.addPropertyChangeListener("numberValue", evt -> {
            Number newValue = (Number)evt.getNewValue();
            this.setTextValueFromNumberValue(newValue);
        });
        model.addPropertyChangeListener("textValue", evt -> {
            String newValue = (String)evt.getNewValue();
            this.setNumberValueFromTextValue(newValue);
        });
    }

    protected void prepareBindFromBean(String property, JavaBean bean) {
        NumberEditorModel model = ((NumberEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Number newValue;
            Number oldValue = model.getNumberValue();
            if (!Objects.equals(oldValue, newValue = (Number)e.getNewValue())) {
                ((NumberEditor)this.ui).setNumberValue(newValue);
            }
        });
    }

    protected void prepareBindToBean(String property, JavaBean bean) {
        NumberEditorModel model = ((NumberEditor)this.ui).getModel();
        model.addPropertyChangeListener("numberValue", e -> {
            if (!model.canUpdateBeanNumberValuePredicate().test(model)) {
                return;
            }
            bean.set(property, e.getNewValue());
        });
    }

    public void addChar(char c) {
        try {
            ((NumberEditor)this.ui).getTextField().getDocument().insertString(((NumberEditor)this.ui).getTextField().getCaretPosition(), c + "", null);
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
        this.setTextValue(((NumberEditor)this.ui).getTextField().getText());
    }

    public void removeChar() {
        JTextField textField = ((NumberEditor)this.ui).getTextField();
        int position = textField.getCaretPosition();
        if (position < 1) {
            if (log.isDebugEnabled()) {
                log.debug("cannot remove when caret on first position or text empty");
            }
            return;
        }
        try {
            textField.getDocument().remove(position - 1, 1);
        }
        catch (BadLocationException ex) {
            log.debug((Object)ex);
            return;
        }
        String newText = textField.getText();
        if (log.isDebugEnabled()) {
            log.debug("text updated : " + newText);
        }
        textField.setCaretPosition(--position);
        this.setTextValue(newText);
    }

    public void reset() {
        this.setTextValue("");
    }

    public void toggleSign() {
        String newValue = ((NumberEditor)this.ui).getModel().getTextValue();
        newValue = newValue.startsWith("-") ? newValue.substring(1) : "-" + newValue;
        this.setTextValue(newValue);
    }

    public void setTextValue(KeyEvent event, String newText) {
        if (event.getKeyCode() == 68 && event.isControlDown()) {
            log.debug("Reset code");
            newText = "";
        }
        this.setTextValue(newText);
    }

    public void setTextValue(String newText) {
        boolean textValid;
        NumberEditorModel model = ((NumberEditor)this.ui).getModel();
        if (StringUtils.isEmpty((CharSequence)newText)) {
            textValid = true;
        } else if (this.numberPattern != null) {
            Matcher matcher = this.numberPattern.matcher(newText);
            textValid = matcher.matches();
            if (!textValid && model.isCanUseSign() && "-".equals(newText)) {
                textValid = true;
            }
        } else {
            textValid = true;
        }
        if (textValid) {
            log.info(String.format("Text [%s] is valid, will set it to model", newText));
            int caretPosition = ((NumberEditor)this.ui).getTextField().getCaretPosition();
            model.setTextValue(newText);
            if (caretPosition >= 0 && caretPosition < newText.length()) {
                ((NumberEditor)this.ui).getTextField().setCaretPosition(caretPosition);
            }
        } else {
            String oldText = model.getTextValue();
            if (oldText == null) {
                oldText = "";
            }
            log.info(String.format("Text [%s] is not valid, will rollback to previous valid text: %s", newText, oldText));
            int caretPosition = ((NumberEditor)this.ui).getTextField().getCaretPosition() - 1;
            ((NumberEditor)this.ui).getTextField().setText(oldText);
            if (caretPosition >= 0 && caretPosition < oldText.length()) {
                ((NumberEditor)this.ui).getTextField().setCaretPosition(caretPosition);
            }
        }
    }

    public void setPopupVisible(Boolean newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (newValue == null || !newValue.booleanValue()) {
            ((NumberEditor)this.ui).getPopup().setVisible(false);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            JComponent invoker = ((NumberEditor)this.ui).isShowPopupButton() != false ? ((NumberEditor)this.ui).getShowPopUpButton() : this.ui;
            Dimension dim = ((NumberEditor)this.ui).getPopup().getPreferredSize();
            int x = (int)(invoker.getPreferredSize().getWidth() - dim.getWidth());
            ((NumberEditor)this.ui).getPopup().show(invoker, x, invoker.getHeight());
            ((NumberEditor)this.ui).getTextField().requestFocus();
        });
    }

    protected void setNumberPattern(String newPattern) {
        try {
            this.numberPattern = Pattern.compile(newPattern);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not compute numberPattern " + newPattern + " on " + this.ui, e);
        }
        if (log.isInfoEnabled()) {
            log.info("init numberPattern: " + this.numberPattern + " on " + this.ui);
        }
    }

    protected void setNumberValueFromTextValue(String textValue) {
        if (((NumberEditor)this.ui).getModel().isNumberValueIsAdjusting()) {
            return;
        }
        Number numberValue = StringUtils.isBlank((CharSequence)textValue) ? (Number)null : (Number)this.numberParserFormatter.parse(textValue);
        if (log.isInfoEnabled()) {
            log.info("Set numberValue " + numberValue + " from textValue " + textValue);
        }
        ((NumberEditor)this.ui).getModel().setNumberValue(numberValue);
    }

    protected void setTextValueFromNumberValue(Number numberValue) {
        if (((NumberEditor)this.ui).getModel().isTextValueIsAdjusting()) {
            return;
        }
        String textValue = this.numberParserFormatter.format(numberValue);
        if (log.isInfoEnabled()) {
            log.info("Set textValue " + textValue + " from numberValue " + numberValue);
        }
        ((NumberEditor)this.ui).getModel().setTextValue(textValue);
    }

    protected void validate() {
        this.setPopupVisible(false);
        ((NumberEditor)this.ui).firePropertyChange(VALIDATE_PROPERTY, null, (Object)true);
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (((NumberEditor)NumberEditorHandler.this.ui).isAutoPopup().booleanValue()) {
                if (((NumberEditor)NumberEditorHandler.this.ui).isPopupVisible().booleanValue()) {
                    if (!((NumberEditor)NumberEditorHandler.this.ui).getPopup().isVisible()) {
                        NumberEditorHandler.this.setPopupVisible(true);
                    }
                } else {
                    ((NumberEditor)NumberEditorHandler.this.ui).setPopupVisible(true);
                }
            } else if (((NumberEditor)NumberEditorHandler.this.ui).isPopupVisible().booleanValue()) {
                NumberEditorHandler.this.setPopupVisible(true);
            }
        }
    }

    static interface NumberParserFormatter {
        public Number parse(String var1);

        public String format(Number var1);
    }
}

