package org.nuiton.jaxx.widgets.number;

/*-
 * #%L
 * JAXX :: Widgets Number
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.css.DataBinding;
import org.nuiton.jaxx.runtime.css.Pseudoclasses;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.number.actions.Reset;
import static io.ultreia.java4all.i18n.I18n.t;

public class NumberEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_POPUP = "autoPopup";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CLEAR_ALL_BUTTON_ENABLED = "clearAllButton.enabled";
    public static final String BINDING_DOT_BUTTON_ENABLED = "dotButton.enabled";
    public static final String BINDING_LEFT_TOOLBAR_ENABLED = "leftToolbar.enabled";
    public static final String BINDING_LEFT_TOOLBAR_VISIBLE = "leftToolbar.visible";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_RIGHT_TOOLBAR_ENABLED = "rightToolbar.enabled";
    public static final String BINDING_RIGHT_TOOLBAR_VISIBLE = "rightToolbar.visible";
    public static final String BINDING_TEXT_FIELD_ENABLED = "textField.enabled";
    public static final String BINDING_TEXT_FIELD_TEXT = "textField.text";
    public static final String BINDING_TOGGLE_SIGN_BUTTON_ENABLED = "toggleSignButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(NumberEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoPopup;
    protected JButton clearAllButton;
    protected JButton clearOnebutton;
    protected JButton dotButton;
    protected NumberEditorHandler handler;
    protected JToolBar leftToolbar;
    protected NumberEditorModel model;
    protected JButton number0;
    protected JButton number1Button;
    protected JButton number2Button;
    protected JButton number3Button;
    protected JButton number4Button;
    protected JButton number5Button;
    protected JButton number6Button;
    protected JButton number7Button;
    protected JButton number8Button;
    protected JButton number9Button;
    protected JPopupMenu popup;
    protected JPanel popupPanel;
    protected Boolean popupVisible;
    protected JButton reset;
    protected JToolBar rightToolbar;
    protected JToggleButton showPopUpButton;
    protected Boolean showPopupButton;
    protected Boolean showReset;
    protected JTextField textField;
    protected JButton toggleSignButton;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private NumberEditor $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    // Config delegate methods
    public void setProperty(String property) { model.getConfig().setProperty(property); }
    public void setUseSign(boolean useSign) { model.getConfig().setUseSign(useSign); }
    public void setNumberType(Class<?> numberType) { model.getConfig().setNumberType(numberType); }
    public void setSelectAllTextOnError(boolean selectAllTextOnError) { model.getConfig().setSelectAllTextOnError(selectAllTextOnError); }
    
    // Model delegate methods
    public void setNumberValue(Number numberValue) { model.setNumberValue(numberValue); }
    public void setNumberPattern(String numberPattern) { model.setNumberPattern(numberPattern); }
    
    public void init() { handler.init(); }
    
    public void reset() { handler.reset(); }
    
    void showPopup() {
       if ( popupVisible || autoPopup ) {
           if (!popupVisible) {
               setPopupVisible(true);
           } else if (!getPopup().isVisible()) {
               handler.setPopupVisible(true);
           }
       }
    }
    
    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        textField.setToolTipText(toolTipText);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor() {
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__clearAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reset();
    }

    public void doActionPerformed__on__clearOnebutton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeChar();
    }

    public void doActionPerformed__on__dotButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('.');
    }

    public void doActionPerformed__on__number0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('0');
    }

    public void doActionPerformed__on__number1Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('1');
    }

    public void doActionPerformed__on__number2Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('2');
    }

    public void doActionPerformed__on__number3Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('3');
    }

    public void doActionPerformed__on__number4Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('4');
    }

    public void doActionPerformed__on__number5Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('5');
    }

    public void doActionPerformed__on__number6Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('6');
    }

    public void doActionPerformed__on__number7Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('7');
    }

    public void doActionPerformed__on__number8Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('8');
    }

    public void doActionPerformed__on__number9Button(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar('9');
    }

    public void doActionPerformed__on__showPopUpButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setPopupVisible(!popup.isVisible());
    }

    public void doActionPerformed__on__toggleSignButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.toggleSign();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    public void doFocusGained__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textField.requestFocusInWindow();
    }

    public void doFocusGained__on__textField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopup();
    }

    public void doFocusLost__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setTextValue(event, textField.getText());
    }

    public void doMouseEntered__on__clearAllButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, clearAllButton, "font-weight", "bold", Pseudoclasses.wrap((clearAllButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearAllButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() | Font.BOLD));
            } else {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__clearOnebutton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, clearOnebutton, "font-weight", "bold", Pseudoclasses.wrap((clearOnebutton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearOnebutton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() | Font.BOLD));
            } else {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__dotButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, dotButton, "font-weight", "normal", Pseudoclasses.wrap((dotButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dotButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() | Font.BOLD));
            } else {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number0, "font-weight", "bold", Pseudoclasses.wrap((number0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number0.getFont() != null) {
            if (((String) value).equals("bold")) {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() | Font.BOLD));
            } else {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number1Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number1Button, "font-weight", "bold", Pseudoclasses.wrap((number1Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number1Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() | Font.BOLD));
            } else {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number2Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number2Button, "font-weight", "bold", Pseudoclasses.wrap((number2Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number2Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() | Font.BOLD));
            } else {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number3Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number3Button, "font-weight", "bold", Pseudoclasses.wrap((number3Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number3Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() | Font.BOLD));
            } else {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number4Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number4Button, "font-weight", "bold", Pseudoclasses.wrap((number4Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number4Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() | Font.BOLD));
            } else {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number5Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number5Button, "font-weight", "bold", Pseudoclasses.wrap((number5Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number5Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() | Font.BOLD));
            } else {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number6Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number6Button, "font-weight", "bold", Pseudoclasses.wrap((number6Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number6Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() | Font.BOLD));
            } else {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number7Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number7Button, "font-weight", "bold", Pseudoclasses.wrap((number7Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number7Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() | Font.BOLD));
            } else {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number8Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number8Button, "font-weight", "bold", Pseudoclasses.wrap((number8Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number8Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() | Font.BOLD));
            } else {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__number9Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, number9Button, "font-weight", "bold", Pseudoclasses.wrap((number9Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number9Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() | Font.BOLD));
            } else {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__toggleSignButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, toggleSignButton, "font-weight", "normal", Pseudoclasses.wrap((toggleSignButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSignButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JPanel0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__clearAllButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, clearAllButton, "font-weight", "bold", Pseudoclasses.wrap((clearAllButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearAllButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() | Font.BOLD));
            } else {
                clearAllButton.setFont(clearAllButton.getFont().deriveFont(clearAllButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__clearOnebutton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, clearOnebutton, "font-weight", "bold", Pseudoclasses.wrap((clearOnebutton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (clearOnebutton.getFont() != null) {
            if (((String) value).equals("bold")) {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() | Font.BOLD));
            } else {
                clearOnebutton.setFont(clearOnebutton.getFont().deriveFont(clearOnebutton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__dotButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, dotButton, "font-weight", "normal", Pseudoclasses.wrap((dotButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dotButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() | Font.BOLD));
            } else {
                dotButton.setFont(dotButton.getFont().deriveFont(dotButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number0, "font-weight", "bold", Pseudoclasses.wrap((number0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number0.getFont() != null) {
            if (((String) value).equals("bold")) {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() | Font.BOLD));
            } else {
                number0.setFont(number0.getFont().deriveFont(number0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number1Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number1Button, "font-weight", "bold", Pseudoclasses.wrap((number1Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number1Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() | Font.BOLD));
            } else {
                number1Button.setFont(number1Button.getFont().deriveFont(number1Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number2Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number2Button, "font-weight", "bold", Pseudoclasses.wrap((number2Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number2Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() | Font.BOLD));
            } else {
                number2Button.setFont(number2Button.getFont().deriveFont(number2Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number3Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number3Button, "font-weight", "bold", Pseudoclasses.wrap((number3Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number3Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() | Font.BOLD));
            } else {
                number3Button.setFont(number3Button.getFont().deriveFont(number3Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number4Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number4Button, "font-weight", "bold", Pseudoclasses.wrap((number4Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number4Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() | Font.BOLD));
            } else {
                number4Button.setFont(number4Button.getFont().deriveFont(number4Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number5Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number5Button, "font-weight", "bold", Pseudoclasses.wrap((number5Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number5Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() | Font.BOLD));
            } else {
                number5Button.setFont(number5Button.getFont().deriveFont(number5Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number6Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number6Button, "font-weight", "bold", Pseudoclasses.wrap((number6Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number6Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() | Font.BOLD));
            } else {
                number6Button.setFont(number6Button.getFont().deriveFont(number6Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number7Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number7Button, "font-weight", "bold", Pseudoclasses.wrap((number7Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number7Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() | Font.BOLD));
            } else {
                number7Button.setFont(number7Button.getFont().deriveFont(number7Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number8Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number8Button, "font-weight", "bold", Pseudoclasses.wrap((number8Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number8Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() | Font.BOLD));
            } else {
                number8Button.setFont(number8Button.getFont().deriveFont(number8Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__number9Button(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, number9Button, "font-weight", "bold", Pseudoclasses.wrap((number9Button.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (number9Button.getFont() != null) {
            if (((String) value).equals("bold")) {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() | Font.BOLD));
            } else {
                number9Button.setFont(number9Button.getFont().deriveFont(number9Button.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__toggleSignButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, toggleSignButton, "font-weight", "normal", Pseudoclasses.wrap((toggleSignButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSignButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSignButton.setFont(toggleSignButton.getFont().deriveFont(toggleSignButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoPopup() {
        return autoPopup;
    }

    public JButton getClearAllButton() {
        return clearAllButton;
    }

    public JButton getClearOnebutton() {
        return clearOnebutton;
    }

    public JButton getDotButton() {
        return dotButton;
    }

    public NumberEditorHandler getHandler() {
        return handler;
    }

    public JToolBar getLeftToolbar() {
        return leftToolbar;
    }

    public NumberEditorModel getModel() {
        return model;
    }

    public JButton getNumber0() {
        return number0;
    }

    public JButton getNumber1Button() {
        return number1Button;
    }

    public JButton getNumber2Button() {
        return number2Button;
    }

    public JButton getNumber3Button() {
        return number3Button;
    }

    public JButton getNumber4Button() {
        return number4Button;
    }

    public JButton getNumber5Button() {
        return number5Button;
    }

    public JButton getNumber6Button() {
        return number6Button;
    }

    public JButton getNumber7Button() {
        return number7Button;
    }

    public JButton getNumber8Button() {
        return number8Button;
    }

    public JButton getNumber9Button() {
        return number9Button;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JPanel getPopupPanel() {
        return popupPanel;
    }

    public Boolean getPopupVisible() {
        return popupVisible;
    }

    public JButton getReset() {
        return reset;
    }

    public JToolBar getRightToolbar() {
        return rightToolbar;
    }

    public JToggleButton getShowPopUpButton() {
        return showPopUpButton;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JTextField getTextField() {
        return textField;
    }

    public JButton getToggleSignButton() {
        return toggleSignButton;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isAutoPopup() {
        return autoPopup !=null && autoPopup;
    }

    public Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoPopup(Boolean autoPopup) {
        Boolean oldValue = this.autoPopup;
        this.autoPopup = autoPopup;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, autoPopup);
    }

    public void setPopupVisible(Boolean popupVisible) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = popupVisible;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, popupVisible);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLeftToolbar() {
        leftToolbar.add(reset);
    }

    protected void addChildrenToPopup() {
        popup.add(popupPanel);
    }

    protected void addChildrenToPopupPanel() {
        popupPanel.add(number7Button);
        popupPanel.add(number8Button);
        popupPanel.add(number9Button);
        popupPanel.add(clearAllButton);
        popupPanel.add(number4Button);
        popupPanel.add(number5Button);
        popupPanel.add(number6Button);
        popupPanel.add(clearOnebutton);
        popupPanel.add(number1Button);
        popupPanel.add(number2Button);
        popupPanel.add(number3Button);
        popupPanel.add($JButton0);
        popupPanel.add(number0);
        popupPanel.add(toggleSignButton);
        popupPanel.add(dotButton);
        popupPanel.add(validateButton);
    }

    protected void addChildrenToRightToolbar() {
        rightToolbar.add(showPopUpButton);
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = false);
    }

    protected void createClearAllButton() {
        $objectMap.put("clearAllButton", clearAllButton = new JButton());
        
        clearAllButton.setName("clearAllButton");
        if (clearAllButton.getFont() != null) {
            clearAllButton.setFont(clearAllButton.getFont().deriveFont((float) 14));
        }
        clearAllButton.setFocusable(false);
        clearAllButton.setForeground(new Color(255, 0, 0));
        clearAllButton.setText(t("numbereditor.clearAll"));
        clearAllButton.setFocusPainted(false);
        clearAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearAllButton"));
        clearAllButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__clearAllButton"));
        clearAllButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__clearAllButton"));
    }

    protected void createClearOnebutton() {
        $objectMap.put("clearOnebutton", clearOnebutton = new JButton());
        
        clearOnebutton.setName("clearOnebutton");
        if (clearOnebutton.getFont() != null) {
            clearOnebutton.setFont(clearOnebutton.getFont().deriveFont((float) 14));
        }
        clearOnebutton.setFocusable(false);
        clearOnebutton.setForeground(new Color(255, 0, 0));
        clearOnebutton.setFocusPainted(false);
        clearOnebutton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearOnebutton"));
        clearOnebutton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__clearOnebutton"));
        clearOnebutton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__clearOnebutton"));
    }

    protected void createDotButton() {
        $objectMap.put("dotButton", dotButton = new JButton());
        
        dotButton.setName("dotButton");
        if (dotButton.getFont() != null) {
            dotButton.setFont(dotButton.getFont().deriveFont((float) 14));
        }
        dotButton.setFocusable(false);
        dotButton.setForeground(new Color(0, 153, 0));
        dotButton.setText(t("numbereditor.."));
        dotButton.setFocusPainted(false);
        dotButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dotButton"));
        dotButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__dotButton"));
        dotButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__dotButton"));
    }

    protected void createLeftToolbar() {
        $objectMap.put("leftToolbar", leftToolbar = new JToolBar());
        
        leftToolbar.setName("leftToolbar");
        leftToolbar.setBorderPainted(false);
        leftToolbar.setOpaque(false);
        leftToolbar.setFloatable(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorModel.class));
    }

    protected void createNumber0() {
        $objectMap.put("number0", number0 = new JButton());
        
        number0.setName("number0");
        if (number0.getFont() != null) {
            number0.setFont(number0.getFont().deriveFont((float) 14));
        }
        number0.setFocusable(false);
        number0.setForeground(new Color(0, 0, 255));
        number0.setFocusPainted(false);
        number0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number0"));
        number0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number0"));
        number0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number0"));
    }

    protected void createNumber1Button() {
        $objectMap.put("number1Button", number1Button = new JButton());
        
        number1Button.setName("number1Button");
        if (number1Button.getFont() != null) {
            number1Button.setFont(number1Button.getFont().deriveFont((float) 14));
        }
        number1Button.setFocusable(false);
        number1Button.setForeground(new Color(0, 0, 255));
        number1Button.setText(t("numbereditor.1"));
        number1Button.setFocusPainted(false);
        number1Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number1Button"));
        number1Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number1Button"));
        number1Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number1Button"));
    }

    protected void createNumber2Button() {
        $objectMap.put("number2Button", number2Button = new JButton());
        
        number2Button.setName("number2Button");
        if (number2Button.getFont() != null) {
            number2Button.setFont(number2Button.getFont().deriveFont((float) 14));
        }
        number2Button.setFocusable(false);
        number2Button.setForeground(new Color(0, 0, 255));
        number2Button.setText(t("numbereditor.2"));
        number2Button.setFocusPainted(false);
        number2Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number2Button"));
        number2Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number2Button"));
        number2Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number2Button"));
    }

    protected void createNumber3Button() {
        $objectMap.put("number3Button", number3Button = new JButton());
        
        number3Button.setName("number3Button");
        if (number3Button.getFont() != null) {
            number3Button.setFont(number3Button.getFont().deriveFont((float) 14));
        }
        number3Button.setFocusable(false);
        number3Button.setForeground(new Color(0, 0, 255));
        number3Button.setText(t("numbereditor.3"));
        number3Button.setFocusPainted(false);
        number3Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number3Button"));
        number3Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number3Button"));
        number3Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number3Button"));
    }

    protected void createNumber4Button() {
        $objectMap.put("number4Button", number4Button = new JButton());
        
        number4Button.setName("number4Button");
        if (number4Button.getFont() != null) {
            number4Button.setFont(number4Button.getFont().deriveFont((float) 14));
        }
        number4Button.setFocusable(false);
        number4Button.setForeground(new Color(0, 0, 255));
        number4Button.setText(t("numbereditor.4"));
        number4Button.setFocusPainted(false);
        number4Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number4Button"));
        number4Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number4Button"));
        number4Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number4Button"));
    }

    protected void createNumber5Button() {
        $objectMap.put("number5Button", number5Button = new JButton());
        
        number5Button.setName("number5Button");
        if (number5Button.getFont() != null) {
            number5Button.setFont(number5Button.getFont().deriveFont((float) 14));
        }
        number5Button.setFocusable(false);
        number5Button.setForeground(new Color(0, 0, 255));
        number5Button.setText(t("numbereditor.5"));
        number5Button.setFocusPainted(false);
        number5Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number5Button"));
        number5Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number5Button"));
        number5Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number5Button"));
    }

    protected void createNumber6Button() {
        $objectMap.put("number6Button", number6Button = new JButton());
        
        number6Button.setName("number6Button");
        if (number6Button.getFont() != null) {
            number6Button.setFont(number6Button.getFont().deriveFont((float) 14));
        }
        number6Button.setFocusable(false);
        number6Button.setForeground(new Color(0, 0, 255));
        number6Button.setText(t("numbereditor.6"));
        number6Button.setFocusPainted(false);
        number6Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number6Button"));
        number6Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number6Button"));
        number6Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number6Button"));
    }

    protected void createNumber7Button() {
        $objectMap.put("number7Button", number7Button = new JButton());
        
        number7Button.setName("number7Button");
        if (number7Button.getFont() != null) {
            number7Button.setFont(number7Button.getFont().deriveFont((float) 14));
        }
        number7Button.setFocusable(false);
        number7Button.setForeground(new Color(0, 0, 255));
        number7Button.setText(t("numbereditor.7"));
        number7Button.setFocusPainted(false);
        number7Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number7Button"));
        number7Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number7Button"));
        number7Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number7Button"));
    }

    protected void createNumber8Button() {
        $objectMap.put("number8Button", number8Button = new JButton());
        
        number8Button.setName("number8Button");
        if (number8Button.getFont() != null) {
            number8Button.setFont(number8Button.getFont().deriveFont((float) 14));
        }
        number8Button.setFocusable(false);
        number8Button.setForeground(new Color(0, 0, 255));
        number8Button.setText(t("numbereditor.8"));
        number8Button.setFocusPainted(false);
        number8Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number8Button"));
        number8Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number8Button"));
        number8Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number8Button"));
    }

    protected void createNumber9Button() {
        $objectMap.put("number9Button", number9Button = new JButton());
        
        number9Button.setName("number9Button");
        if (number9Button.getFont() != null) {
            number9Button.setFont(number9Button.getFont().deriveFont((float) 14));
        }
        number9Button.setFocusable(false);
        number9Button.setForeground(new Color(0, 0, 255));
        number9Button.setText(t("numbereditor.9"));
        number9Button.setFocusPainted(false);
        number9Button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__number9Button"));
        number9Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__number9Button"));
        number9Button.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__number9Button"));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupPanel() {
        $objectMap.put("popupPanel", popupPanel = new JPanel());
        
        popupPanel.setName("popupPanel");
        popupPanel.setLayout(new GridLayout(4,4));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusable(false);
        reset.setFocusPainted(false);
    }

    protected void createRightToolbar() {
        $objectMap.put("rightToolbar", rightToolbar = new JToolBar());
        
        rightToolbar.setName("rightToolbar");
        rightToolbar.setBorderPainted(false);
        rightToolbar.setOpaque(false);
        rightToolbar.setFloatable(false);
    }

    protected void createShowPopUpButton() {
        $objectMap.put("showPopUpButton", showPopUpButton = new JToggleButton());
        
        showPopUpButton.setName("showPopUpButton");
        showPopUpButton.setFocusable(false);
        showPopUpButton.setToolTipText(t("numbereditor.action.show.tip"));
        showPopUpButton.setFocusPainted(false);
        showPopUpButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showPopUpButton"));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
        textField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textField"));
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createToggleSignButton() {
        $objectMap.put("toggleSignButton", toggleSignButton = new JButton());
        
        toggleSignButton.setName("toggleSignButton");
        if (toggleSignButton.getFont() != null) {
            toggleSignButton.setFont(toggleSignButton.getFont().deriveFont((float) 14));
        }
        toggleSignButton.setFocusable(false);
        toggleSignButton.setForeground(new Color(0, 153, 0));
        toggleSignButton.setText(t("numbereditor.toggleSign"));
        toggleSignButton.setFocusPainted(false);
        toggleSignButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggleSignButton"));
        toggleSignButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__toggleSignButton"));
        toggleSignButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__toggleSignButton"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new NumberEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createAutoPopup();
        createShowPopupButton();
        createShowReset();
        createPopupVisible();
        createPopup();
        createPopupPanel();
        createNumber7Button();
        createNumber8Button();
        createNumber9Button();
        createClearAllButton();
        createNumber4Button();
        createNumber5Button();
        createNumber6Button();
        createClearOnebutton();
        createNumber1Button();
        createNumber2Button();
        createNumber3Button();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setEnabled(false);
        createNumber0();
        createToggleSignButton();
        createDotButton();
        createValidateButton();
        createLeftToolbar();
        createReset();
        createTextField();
        createRightToolbar();
        createShowPopUpButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        $JPanel0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JPanel0"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLEAR_ALL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canClearAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    clearAllButton.setEnabled(model.isCanClearAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canClearAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_SIGN_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canUseSign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toggleSignButton.setEnabled(model.isCanUseSign());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canUseSign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canUseDot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dotButton.setEnabled(model.isCanUseDot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canUseDot", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LEFT_TOOLBAR_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                leftToolbar.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LEFT_TOOLBAR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                leftToolbar.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled" ,"showReset") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled() && isShowReset());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("textValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(textField, model.getTextValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("textValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RIGHT_TOOLBAR_VISIBLE, true ,"showPopupButton") {
        
            @Override
            public void processDataBinding() {
                rightToolbar.setVisible(isShowPopupButton());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RIGHT_TOOLBAR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                rightToolbar.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(leftToolbar, BorderLayout.WEST);
        add(textField, BorderLayout.CENTER);
        add(rightToolbar, BorderLayout.EAST);
        addChildrenToPopup();
        addChildrenToPopupPanel();
        addChildrenToLeftToolbar();
        addChildrenToRightToolbar();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 property setters
        popupPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        popupPanel.setBackground(Color.WHITE);
        validateButton.setIcon(SwingUtil.getUIManagerActionIcon("numbereditor-validate"));
        rightToolbar.setMaximumSize(new Dimension(24,24));
        showPopUpButton.setIcon(SwingUtil.getUIManagerActionIcon("numbereditor-calculator"));// late initializer
        
        Reset.init(this, reset, Reset.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
