/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.number;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.lang.Setters;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.jaxx.widgets.number.NumberEditorConfig;
import org.nuiton.jaxx.widgets.number.NumberEditorModel;

public class NumberEditorHandler
implements UIHandler<NumberEditor> {
    private static final Logger log = LogManager.getLogger(NumberEditorHandler.class);
    protected static final ImmutableSet<Class<?>> INT_CLASSES = ImmutableSet.of(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, (Object[])new Class[]{BigInteger.class});
    private static final String VALIDATE_PROPERTY = "validate";
    protected NumberEditor ui;
    protected Pattern numberPattern;
    protected NumberParserFormatter numberParserFormatter;
    private static Map<Class<?>, NumberParserFormatter<?>> numberFactories;
    protected static final ImmutableSet<String> NULL_LIMIT_DECIMALS;
    protected static final ImmutableSet<String> NULL_LIMIT_INTS;

    public void beforeInit(NumberEditor ui) {
        this.ui = ui;
        NumberEditorModel model = new NumberEditorModel(new NumberEditorConfig());
        ui.setContextValue(model);
    }

    public void afterInit(NumberEditor ui) {
    }

    public void addChar(char c) {
        try {
            this.ui.getTextField().getDocument().insertString(this.ui.getTextField().getCaretPosition(), c + "", null);
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
        this.setTextValue(this.ui.getTextField().getText());
    }

    public void removeChar() {
        JTextField textField = this.ui.getTextField();
        int position = textField.getCaretPosition();
        if (position < 1) {
            if (log.isDebugEnabled()) {
                log.debug("cannot remove when caret on first position or text empty");
            }
            return;
        }
        try {
            textField.getDocument().remove(position - 1, 1);
        }
        catch (BadLocationException ex) {
            log.debug((Object)ex);
            return;
        }
        String newText = textField.getText();
        if (log.isDebugEnabled()) {
            log.debug("text updated : " + newText);
        }
        textField.setCaretPosition(--position);
        this.setTextValue(newText);
    }

    public void reset() {
        this.setTextValue("");
    }

    public void toggleSign() {
        String newValue = this.ui.getModel().getTextValue();
        newValue = newValue.startsWith("-") ? newValue.substring(1) : "-" + newValue;
        this.setTextValue(newValue);
    }

    public void setTextValue(KeyEvent event, String newText) {
        if (event.getKeyCode() == 68 && event.isControlDown()) {
            log.debug("Reset code");
            newText = "";
        }
        this.setTextValue(newText);
    }

    public void setTextValue(String newText) {
        boolean textValid;
        NumberEditorModel model = this.ui.getModel();
        if (StringUtils.isEmpty((CharSequence)newText)) {
            textValid = true;
        } else if (this.numberPattern != null) {
            Matcher matcher = this.numberPattern.matcher(newText);
            textValid = matcher.matches();
            if (!textValid && model.isCanUseSign() && "-".equals(newText)) {
                textValid = true;
            }
        } else {
            textValid = true;
        }
        if (textValid) {
            if (log.isInfoEnabled()) {
                log.info("Text [" + newText + "] is valid, will set it to model");
            }
            model.setTextValue(newText);
        } else {
            String oldText = model.getTextValue();
            if (oldText == null) {
                oldText = "";
            }
            if (log.isInfoEnabled()) {
                log.info("Text [" + newText + "] is not valid, will rollback to previous valid text: " + oldText);
            }
            int caretPosition = this.ui.getTextField().getCaretPosition() - 1;
            this.ui.getTextField().setText(oldText);
            if (caretPosition >= 0) {
                this.ui.getTextField().setCaretPosition(caretPosition);
            }
        }
    }

    public void setPopupVisible(Boolean newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (newValue == null || !newValue.booleanValue()) {
            this.ui.getPopup().setVisible(false);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            JComponent invoker = this.ui.isShowPopupButton() != false ? this.ui.getShowPopUpButton() : this.ui;
            Dimension dim = this.ui.getPopup().getPreferredSize();
            int x = (int)(invoker.getPreferredSize().getWidth() - dim.getWidth());
            this.ui.getPopup().show(invoker, x, invoker.getHeight());
            this.ui.getTextField().requestFocus();
        });
    }

    protected void init() {
        String property;
        boolean canBeDecimal;
        NumberEditorModel model = this.ui.getModel();
        NumberEditorConfig config = model.getConfig();
        Class<?> numberType = config.getNumberType();
        Preconditions.checkState((numberType != null ? 1 : 0) != 0, (Object)("Required a number type on " + this.ui));
        this.numberParserFormatter = NumberEditorHandler.getNumberFactory(numberType);
        if (log.isInfoEnabled()) {
            log.info("init numberType: " + numberType + " on " + this.ui);
        }
        Boolean useDecimal = config.getUseDecimal();
        boolean bl = canBeDecimal = !INT_CLASSES.contains(numberType);
        if (useDecimal == null) {
            useDecimal = canBeDecimal;
            config.setUseDecimal(useDecimal);
        } else {
            Preconditions.checkState((useDecimal == false || canBeDecimal ? 1 : 0) != 0, (Object)("Can't use decimal with the following number type " + numberType + " on " + this.ui));
        }
        String numberPatternDef = model.getNumberPattern();
        if (StringUtils.isNotEmpty((CharSequence)numberPatternDef)) {
            this.setNumberPattern(numberPatternDef);
        }
        model.addPropertyChangeListener("numberPattern", evt -> {
            String newPattern = (String)evt.getNewValue();
            this.setNumberPattern(newPattern);
            if (log.isInfoEnabled()) {
                log.info("set new numberPattern" + newPattern);
            }
            this.numberPattern = StringUtils.isEmpty((CharSequence)newPattern) ? null : Pattern.compile(newPattern);
        });
        model.addPropertyChangeListener("numberValue", evt -> {
            Number newValue = (Number)evt.getNewValue();
            this.setTextValueFromNumberValue(newValue);
        });
        model.addPropertyChangeListener("textValue", evt -> {
            String newValue = (String)evt.getNewValue();
            this.setNumberValueFromTextValue(newValue);
        });
        Object bean = model.getBean();
        if (bean != null && (property = config.getProperty()) != null) {
            Method mutator = Setters.getMutator((Object)bean, (String)property);
            Objects.requireNonNull(mutator, "could not find mutator for " + property);
            Class<?>[] parameterTypes = mutator.getParameterTypes();
            if (!Objects.equals(parameterTypes[0], numberType)) {
                throw new IllegalStateException("Mismatch mutator type, required a " + numberType + " but was " + parameterTypes[0]);
            }
            model.addPropertyChangeListener("numberValue", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, model.canUpdateBeanNumberValuePredicate()));
        }
        this.ui.addPropertyChangeListener("showPopupButton", evt -> {
            if (this.ui.getPopup().isVisible()) {
                this.setPopupVisible(false);
            }
        });
        this.ui.addPropertyChangeListener("autoPopup", evt -> {
            if (this.ui.getPopup().isVisible()) {
                this.setPopupVisible(false);
            }
        });
        this.ui.addPropertyChangeListener("popupVisible", evt -> this.setPopupVisible((Boolean)evt.getNewValue()));
        this.ui.getTextField().addMouseListener(new PopupListener());
        Number numberValue = model.getNumberValue();
        this.setTextValueFromNumberValue(numberValue);
    }

    protected void setNumberPattern(String newPattern) {
        try {
            this.numberPattern = Pattern.compile(newPattern);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not compute numberPattern " + newPattern + " on " + this.ui, e);
        }
        if (log.isInfoEnabled()) {
            log.info("init numberPattern: " + this.numberPattern + " on " + this.ui);
        }
    }

    protected void setNumberValueFromTextValue(String textValue) {
        if (this.ui.getModel().isNumberValueIsAdjusting()) {
            return;
        }
        Number numberValue = StringUtils.isBlank((CharSequence)textValue) ? (Number)null : (Number)((Number)this.numberParserFormatter.parse(textValue));
        if (log.isInfoEnabled()) {
            log.info("Set numberValue " + numberValue + " from textValue " + textValue);
        }
        this.ui.getModel().setNumberValue(numberValue);
    }

    protected void setTextValueFromNumberValue(Number numberValue) {
        if (this.ui.getModel().isTextValueIsAdjusting()) {
            return;
        }
        String textValue = this.numberParserFormatter.format(numberValue);
        if (log.isInfoEnabled()) {
            log.info("Set textValue " + textValue + " from numberValue " + numberValue);
        }
        this.ui.getModel().setTextValue(textValue);
    }

    protected void validate() {
        this.setPopupVisible(false);
        this.ui.firePropertyChange(VALIDATE_PROPERTY, null, (Object)true);
    }

    protected static NumberParserFormatter<?> getNumberFactory(Class<?> numberType) {
        if (numberFactories == null) {
            numberFactories = new HashMap();
            NumberParserFormatter<Byte> byteSupport = new NumberParserFormatter<Byte>(){

                @Override
                public String format(Byte numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Byte parse(String textValue) {
                    Byte v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Byte.valueOf(Byte.parseByte(textValue));
                    return v;
                }
            };
            numberFactories.put(Byte.TYPE, byteSupport);
            numberFactories.put(Byte.class, byteSupport);
            NumberParserFormatter<Short> shortSupport = new NumberParserFormatter<Short>(){

                @Override
                public String format(Short numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Short parse(String textValue) {
                    Short v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Short.valueOf(Short.parseShort(textValue));
                    return v;
                }
            };
            numberFactories.put(Short.TYPE, shortSupport);
            numberFactories.put(Short.class, shortSupport);
            NumberParserFormatter<Integer> integerSupport = new NumberParserFormatter<Integer>(){

                @Override
                public String format(Integer numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Integer parse(String textValue) {
                    Integer v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Integer.valueOf(Integer.parseInt(textValue));
                    return v;
                }
            };
            numberFactories.put(Integer.TYPE, integerSupport);
            numberFactories.put(Integer.class, integerSupport);
            NumberParserFormatter<Long> longSupport = new NumberParserFormatter<Long>(){

                @Override
                public String format(Long numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Long parse(String textValue) {
                    Long v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Long.valueOf(Long.parseLong(textValue));
                    return v;
                }
            };
            numberFactories.put(Long.TYPE, longSupport);
            numberFactories.put(Long.class, longSupport);
            NumberParserFormatter<Float> floatSupport = new NumberParserFormatter<Float>(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Float numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Float parse(String textValue) {
                    Float v;
                    if (NULL_LIMIT_DECIMALS.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Float.valueOf(Float.parseFloat(textValue));
                        if (addSign) {
                            v = Float.valueOf(-v.floatValue());
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Float.TYPE, floatSupport);
            numberFactories.put(Float.class, floatSupport);
            NumberParserFormatter<Double> doubleSupport = new NumberParserFormatter<Double>(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Double numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Double parse(String textValue) {
                    Double v;
                    if (NULL_LIMIT_DECIMALS.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Double.parseDouble(textValue);
                        if (addSign) {
                            v = -v.doubleValue();
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Double.TYPE, doubleSupport);
            numberFactories.put(Double.class, doubleSupport);
            NumberParserFormatter<BigInteger> bigIntegerSupport = new NumberParserFormatter<BigInteger>(){

                @Override
                public String format(BigInteger numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigInteger parse(String textValue) {
                    return new BigInteger(textValue);
                }
            };
            numberFactories.put(BigInteger.class, bigIntegerSupport);
            NumberParserFormatter<BigDecimal> bigDecimalSupport = new NumberParserFormatter<BigDecimal>(){

                @Override
                public String format(BigDecimal numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigDecimal parse(String textValue) {
                    return new BigDecimal(textValue);
                }
            };
            numberFactories.put(BigDecimal.class, bigDecimalSupport);
        }
        for (Map.Entry<Class<?>, NumberParserFormatter<?>> entry : numberFactories.entrySet()) {
            if (!entry.getKey().equals(numberType)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Could not find a NumberFactory for type " + numberType);
    }

    static {
        NULL_LIMIT_DECIMALS = ImmutableSet.copyOf((Object[])new String[]{"-", ".", "-."});
        NULL_LIMIT_INTS = ImmutableSet.copyOf((Object[])new String[]{"-"});
    }

    static interface NumberParserFormatter<N extends Number> {
        public N parse(String var1);

        public String format(N var1);
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (NumberEditorHandler.this.ui.isAutoPopup().booleanValue()) {
                if (NumberEditorHandler.this.ui.isPopupVisible().booleanValue()) {
                    if (!NumberEditorHandler.this.ui.getPopup().isVisible()) {
                        NumberEditorHandler.this.setPopupVisible(true);
                    }
                } else {
                    NumberEditorHandler.this.ui.setPopupVisible(true);
                }
            } else if (NumberEditorHandler.this.ui.isPopupVisible().booleanValue()) {
                NumberEditorHandler.this.setPopupVisible(true);
            }
        }
    }
}

