package io.ultreia.java4all.jaxx.widgets.list;

/*-
 * #%L
 * JAXX :: Widgets List
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.decoration.Decorator;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static io.ultreia.java4all.i18n.I18n.t;

public class ListHeader<O> extends JPanel implements BeanTypeAware<O>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_LABEL_TEXT = "labelText";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHANGE_DECORATOR_VISIBLE = "changeDecorator.visible";
    public static final String BINDING_LABEL_TEXT = "label.text";
    public static final String BINDING_RESET_SELECTION_ENABLED = "resetSelection.enabled";
    public static final String BINDING_RESET_SELECTION_VISIBLE = "resetSelection.visible";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WT08bRxQfDDZgCISmikpPTmiJacu6aZsqEv2TEpqEyEkQJhEql469gz1o2NnMzmIjixx66K1foIdee6nyHaKeIlWVeuU7VMpH6Huz9v5jjd1SDiv85v35vTfv/d789jfJe4p8JFXTcnyupWMd0E7HUr6j+SGzHn6zu/ukfsAaeoN5DcVdLRUJ/sZyJLdHZuxQ7mli7VXBUyXwVEFPlZ6nyl156EqHOTFHa1VS9PSxYF6LMa1JeaBxw/MqtVBzreP6qhcrE3VWrD9+vHk6xjZ+zhHScQH+IqT94b9wEGU9USU5bmvyVvWAHtGKoE4TwCnuNCGhSyi7K6jnPaaH7Dl5QSarpOBSBc40Wf1P5THujKuOq8m4lvD9mEvLF1oxTi0M+RkVIsihze0m054luKetKnweMGoz5brGRUGTaa8l29vMw5IvoK2FKVjrUgpGnUjvEuptsIZUFNCgcC46nFHsiCmP1aTSqaMpZnNN64Kl5XVwv3PsMk3mo7AmuRg4QetM7LAOgLscaQX1jdTy3LFBJ45/09GsGc9zwqaaajJnVHzNhalGdD5pfDBo29VBfeC1IaoZgnVfw+l9JX03XknI3shQsBQdXPGYgJlh9g4UdYe7mA8evRupXHWkrg3VmnOl67s7XAuWcVrkN287W4rt807qJG/sIAom3+nnsYXCR8zx0wHwFqtYeOjqhIURoqoVWhQw6afgu5TQ3KY2l0GVMMKmZodJuym025BtB39/njzroWAwJ9hradzhQdKqaKxCiJ8mT/MicTAd3buGctcpRHk7EQVvYZ2qpPKcwkEJLopLB642YRMkjLp3QpP5Rgv6kYWTo8liKk6zKVjCUpHlQS0I1GdF1Bex0NgeyStfYPsuDWZdJM5t0Aooc2kwZWIYo/jDyxfq1/ab0z5PXgZwpWFWsZUApOUq6TKlOWKbD0gSx6/yiLprezA0pphmX9w4H3mtpwnoAcVCNMgPqNcCb/nJ01e/X/3+r3GSu0eKQlL7HkX9TTKtW3BxLSnsjvv1HQNutj2F6SBMuFbfY7GpA7LQymcdqNGN82sUQnr55M3rX356/1W/TmOA8L1RLKNa5b8jBe4I7jCzUXrLInODzLge820ZbYKs3UAiTuuT1GPz3T5TghzSe499nlHhQ2ctdLm3HZF6eeVkcJnQ6TOTNP63S+JUOCw0VL9QlwpWEhBv12HtkqE3e93Iyrp8HfeE2V5mvi2Nx9dXVk6y4gZEN0K6RWoGeLOBQzyN7lcRMqZkMpvHqBaKLEMcWcFSZDksah7WZD3aG/EipfDMhnhW8awHaTaChNL8UXBRk919Kjx2gpTau0Kg7e619PVlZdAj7/8P+VyE3AZuD7HPRdgDeR99oYstlAR/tvWysIcLZITbLkiXPsdweVOrENYH3RqS8FMkEXglBc8KMwBl+Fntvz3Kg7pNjHLv4zBcQYdvUe6YDPswpvdlw/fwcRSXAXPpuCwrdH9rDQteSF1Q0VyQCp57k0fc4ybQPJS81n8HmlnPgjaj48O/GA5mEMAyXmE+oSkmmYOmkOot8Pxt8KO8UlpeLmFhwai8YioeJx04v/ZlyfGFgPizJn6qYplTmFzJI/RyRsfa0XaOinKlV5RwdY9YmHfShTF9b+oyclbpV8MoNCrosfRx2L7Ap26pDuQP7fzVGfdj+C2O4HGCN4I3yetsH58M9YHiP8/xcOvCHm5f2MPGhT3cBw//AOfnzK47DwAA";
    private static final Logger log = LogManager.getLogger(ListHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Class<O> beanType;
    protected JToggleButton changeDecorator;
    protected List<O> data;
    protected Boolean editable;
    protected ListHeaderHandler<O> handler;
    protected String i18nPrefix;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected JLabel label;
    protected String labelText;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected String popupTitleText;
    protected JButton resetSelection;
    protected Boolean reverseSort;
    protected String selectedToolTipText;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbar;
    protected ListHeader<O> top;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private JList<O> list;
    
    
    public final JList<O> getList() {
        return list;
    }
    
    public void init(Decorator decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    public O getSelectedValue() {
        return handler.getSelectedValue();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListHeader(JList list) {
        this.list = java.util.Objects.requireNonNull(list);
            $initialize();
    }

    public ListHeader() {
        $initialize();
    }

    public ListHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListHeader(boolean param0) {
        super(param0);
        $initialize();
    }

    public ListHeader(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListHeader(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ListHeader(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ListHeader(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListHeader(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__changeDecorator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().togglePopup();
    }

    public void doActionPerformed__on__resetSelection(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getList().getSelectionModel().clearSelection();
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Class<O> getBeanType() {
        return beanType;
    }

    public JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public List<O> getData() {
        return data;
    }

    public Boolean getEditable() {
        return editable;
    }

    public ListHeaderHandler<O> getHandler() {
        return handler;
    }

    public String getI18nPrefix() {
        return i18nPrefix;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public JLabel getLabel() {
        return label;
    }

    public String getLabelText() {
        return labelText;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public String getPopupTitleText() {
        return popupTitleText;
    }

    public JButton getResetSelection() {
        return resetSelection;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanType(Class<O> beanType) {
        Class<O> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setI18nPrefix(String i18nPrefix) {
        String oldValue = this.i18nPrefix;
        this.i18nPrefix = i18nPrefix;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, i18nPrefix);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setLabelText(String labelText) {
        String oldValue = this.labelText;
        this.labelText = labelText;
        firePropertyChange(PROPERTY_LABEL_TEXT, oldValue, labelText);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupTitleText(String popupTitleText) {
        String oldValue = this.popupTitleText;
        this.popupTitleText = popupTitleText;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, popupTitleText);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbar() {
        toolbar.add(resetSelection);
        toolbar.add(changeDecorator);
    }

    protected void addChildrenToTop() {
        add(label, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(t("beanlist.action.sort.tip"));
        changeDecorator.setFocusPainted(false);
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "List.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        label.setOpaque(false);
    }

    protected void createLabelText() {
        $objectMap.put("labelText", labelText = null);
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createResetSelection() {
        $objectMap.put("resetSelection", resetSelection = new JButton());
        
        resetSelection.setName("resetSelection");
        resetSelection.setFocusable(false);
        resetSelection.setToolTipText(t("beanlist.action.reset.tip"));
        resetSelection.setFocusPainted(false);
        resetSelection.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetSelection"));
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setBorderPainted(false);
        toolbar.setFocusable(false);
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new ListHeaderHandler<>();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createShowReset();
        createShowDecorator();
        createReverseSort();
        createEditable();
        createBeanType();
        createLabelText();
        createIndex();
        createData();
        createIndexes();
        createSortGroup();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        createLabel();
        createToolbar();
        createResetSelection();
        createChangeDecorator();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"labelText") {
        
            @Override
            public void processDataBinding() {
                label.setText(SwingUtil.getStringValue(getLabelText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_SELECTION_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                resetSelection.setVisible(isShowReset());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_SELECTION_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (getList() != null) {
                    $bindingSources.put(" getList().getSelectionModel()",  getList().getSelectionModel());
                     getList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    getList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(io.ultreia.java4all.jaxx.widgets.list.ListHeader.this, BINDING_RESET_SELECTION_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getList() != null) {
                    resetSelection.setEnabled(isEnabled() && getList().getSelectedValue() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (getList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove(" getList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    getList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(io.ultreia.java4all.jaxx.widgets.list.ListHeader.this, BINDING_RESET_SELECTION_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CHANGE_DECORATOR_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                changeDecorator.setVisible(isShowDecorator());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbar();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 9 property setters
        popup.setBorder(new TitledBorder(t("beanlist.popup.title")));
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("list-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("list-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("list-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        resetSelection.setIcon(SwingUtil.getUIManagerActionIcon("list-reset"));
        changeDecorator.setIcon(SwingUtil.getUIManagerActionIcon("list-decorator"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
