package io.ultreia.java4all.jaxx.widgets.list;

/*-
 * #%L
 * JAXX :: Widgets List
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.decoration.Decorator;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListAddAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListDisplayDecoratorAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListRemoveAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListResetAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListResetFilterAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListSelectedListMoveDownAction;
import io.ultreia.java4all.jaxx.widgets.list.actions.DoubleListSelectedListMoveUpAction;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import static io.ultreia.java4all.i18n.I18n.t;

public class DoubleList<O> extends Table implements BeanTypeAware<O>, BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_HIGHLIGHT_FILTER_TEXT = "highlightFilterText";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_SELECT_POPUP_ENABLED = "showSelectPopupEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ACTION_ENABLED = "addAction.enabled";
    public static final String BINDING_DISPLAY_DECORATOR_ENABLED = "displayDecorator.enabled";
    public static final String BINDING_DISPLAY_DECORATOR_VISIBLE = "displayDecorator.visible";
    public static final String BINDING_REMOVE_ACTION_ENABLED = "removeAction.enabled";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_RESET_VISIBLE = "reset.visible";
    public static final String BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU = "selectedList.componentPopupMenu";
    public static final String BINDING_SELECTED_LIST_ENABLED = "selectedList.enabled";
    public static final String BINDING_SELECTED_LIST_MODEL = "selectedList.model";
    public static final String BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED = "selectedListMoveDownAction.enabled";
    public static final String BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED = "selectedListMoveUpAction.enabled";
    public static final String BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED = "selectedListRemoveAction.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOP_PANEL_VISIBLE = "topPanel.visible";
    public static final String BINDING_UNIVERSE_LIST_ENABLED = "universeList.enabled";
    public static final String BINDING_UNIVERSE_LIST_MODEL = "universeList.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Logger log = LogManager.getLogger(DoubleList.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAction;
    protected JPanel beforeFilterPanel;
    protected JToggleButton displayDecorator;
    protected JTextField filterField;
    protected JLabel filterFieldLabel;
    protected Boolean filterable;
    protected DoubleListHandler<O> handler;
    protected Boolean highlightFilterText;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected DoubleListModel<O> model;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected JButton removeAction;
    protected JButton reset;
    protected JButton resetFilter;
    protected Boolean reverseSort;
    protected JList<O> selectedList;
    protected JMenuItem selectedListMoveDownAction;
    protected JMenuItem selectedListMoveUpAction;
    protected JScrollPane selectedListPane;
    protected JPopupMenu selectedListPopup;
    protected JMenuItem selectedListRemoveAction;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected Boolean showSelectPopupEnabled;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbarLeft;
    protected JPanel topPanel;
    protected JList<O> universeList;
    protected JScrollPane universeListPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JSeparator $JSeparator0;
    private DoubleList<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(Decorator decorator, Decorator decorator2, List<O> universe, List<O> selected) {
          handler.init(decorator, decorator2, universe, selected);
      }
    
    public void init(Decorator decorator, List<O> universe, List<O> selected) {
        handler.init(decorator, universe, selected);
    }
    
    public Class<O> getBeanType() { return model.getConfig().getBeanType(); }
    
    @Override
    public Object getBean() { return model.getBean(); }
    
    @Override
    public void setBean(Object bean) { model.setBean(bean); }
    
    // Config delegate methods
    public void setBeanType(Class<O> beanType) { model.getConfig().setBeanType(beanType); }
    public void setProperty(String property) { model.getConfig().setProperty(property); }
    public void setUseMultiSelect(boolean useMultiSelect) { model.getConfig().setUseMultiSelect(useMultiSelect); }
    public void setI18nPrefix(String i18nPrefix) { model.getConfig().setI18nPrefix(i18nPrefix); }
    public void setShowListLabel(boolean showListLabel) { model.getConfig().setShowListLabel(showListLabel); }
    public void setLabel(String label) { model.getConfig().setLabel(label); }
    public void setUniverseLabel(String universeLabel) { model.getConfig().setUniverseLabel(universeLabel); }
    public void setSelectedLabel(String selectedLabel) { model.getConfig().setSelectedLabel(selectedLabel); }
    public void setAutoSortSelectedList(boolean autoSortSelectedList) { model.getConfig().setAutoSortSelectedList(autoSortSelectedList); }
    
    // Model delegate methods
    public void setUniverse(Collection<O> universe) { model.setUniverse(universe);}
    public void setSelected(Collection<O> selected) { handler.setSelected(selected);}

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DoubleList() {
        $initialize();
    }

    public DoubleList(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__selectedList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListFocusGained(event);
    }

    public void doFocusGained__on__universeList(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListFocusGained(event);
    }

    public void doMouseClicked__on__selectedList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListClicked(event);
    }

    public void doMouseClicked__on__universeList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListClicked(event);
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displayDecorator.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displayDecorator.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAction() {
        return addAction;
    }

    public JPanel getBeforeFilterPanel() {
        return beforeFilterPanel;
    }

    public JToggleButton getDisplayDecorator() {
        return displayDecorator;
    }

    public JTextField getFilterField() {
        return filterField;
    }

    public JLabel getFilterFieldLabel() {
        return filterFieldLabel;
    }

    public Boolean getFilterable() {
        return filterable;
    }

    public DoubleListHandler<O> getHandler() {
        return handler;
    }

    public Boolean getHighlightFilterText() {
        return highlightFilterText;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public DoubleListModel<O> getModel() {
        return model;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public JButton getRemoveAction() {
        return removeAction;
    }

    public JButton getReset() {
        return reset;
    }

    public JButton getResetFilter() {
        return resetFilter;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public JList<O> getSelectedList() {
        return selectedList;
    }

    public JMenuItem getSelectedListMoveDownAction() {
        return selectedListMoveDownAction;
    }

    public JMenuItem getSelectedListMoveUpAction() {
        return selectedListMoveUpAction;
    }

    public JScrollPane getSelectedListPane() {
        return selectedListPane;
    }

    public JPopupMenu getSelectedListPopup() {
        return selectedListPopup;
    }

    public JMenuItem getSelectedListRemoveAction() {
        return selectedListRemoveAction;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public Boolean getShowSelectPopupEnabled() {
        return showSelectPopupEnabled;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JPanel getTopPanel() {
        return topPanel;
    }

    public JList<O> getUniverseList() {
        return universeList;
    }

    public JScrollPane getUniverseListPane() {
        return universeListPane;
    }

    public Boolean isFilterable() {
        return filterable !=null && filterable;
    }

    public Boolean isHighlightFilterText() {
        return highlightFilterText !=null && highlightFilterText;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isShowSelectPopupEnabled() {
        return showSelectPopupEnabled !=null && showSelectPopupEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFilterable(Boolean filterable) {
        Boolean oldValue = this.filterable;
        this.filterable = filterable;
        firePropertyChange(PROPERTY_FILTERABLE, oldValue, filterable);
    }

    public void setHighlightFilterText(Boolean highlightFilterText) {
        Boolean oldValue = this.highlightFilterText;
        this.highlightFilterText = highlightFilterText;
        firePropertyChange(PROPERTY_HIGHLIGHT_FILTER_TEXT, oldValue, highlightFilterText);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowSelectPopupEnabled(Boolean showSelectPopupEnabled) {
        Boolean oldValue = this.showSelectPopupEnabled;
        this.showSelectPopupEnabled = showSelectPopupEnabled;
        firePropertyChange(PROPERTY_SHOW_SELECT_POPUP_ENABLED, oldValue, showSelectPopupEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSelectedListPane() {
        selectedListPane.getViewport().add(selectedList);
    }

    protected void addChildrenToSelectedListPopup() {
        selectedListPopup.add(selectedListMoveUpAction);
        selectedListPopup.add(selectedListMoveDownAction);
        selectedListPopup.add(selectedListRemoveAction);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetFilter);
    }

    protected void addChildrenToTopPanel() {
        topPanel.add($JPanel0, BorderLayout.WEST);
        topPanel.add(filterField, BorderLayout.CENTER);
    }

    protected void addChildrenToUniverseListPane() {
        universeListPane.getViewport().add(universeList);
    }

    protected void createAddAction() {
        $objectMap.put("addAction", addAction = new JButton());
        
        addAction.setName("addAction");
        addAction.setBorderPainted(false);
        addAction.setFocusable(false);
    }

    protected void createBeforeFilterPanel() {
        $objectMap.put("beforeFilterPanel", beforeFilterPanel = new JPanel());
        
        beforeFilterPanel.setName("beforeFilterPanel");
        beforeFilterPanel.setLayout(new BorderLayout());
    }

    protected void createDisplayDecorator() {
        $objectMap.put("displayDecorator", displayDecorator = new JToggleButton());
        
        displayDecorator.setName("displayDecorator");
    }

    protected void createFilterField() {
        $objectMap.put("filterField", filterField = new JTextField());
        
        filterField.setName("filterField");
        filterField.setColumns(15);
    }

    protected void createFilterFieldLabel() {
        $objectMap.put("filterFieldLabel", filterFieldLabel = new JLabel());
        
        filterFieldLabel.setName("filterFieldLabel");
    }

    protected void createFilterable() {
        $objectMap.put("filterable", filterable = true);
    }

    protected void createHighlightFilterText() {
        $objectMap.put("highlightFilterText", highlightFilterText = false);
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DoubleListModel.class));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createRemoveAction() {
        $objectMap.put("removeAction", removeAction = new JButton());
        
        removeAction.setName("removeAction");
        removeAction.setBorderPainted(false);
        removeAction.setFocusable(false);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setBorderPainted(false);
        reset.setFocusable(false);
    }

    protected void createResetFilter() {
        $objectMap.put("resetFilter", resetFilter = new JButton());
        
        resetFilter.setName("resetFilter");
        resetFilter.setBorderPainted(false);
        resetFilter.setFocusable(false);
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedList() {
        $objectMap.put("selectedList", selectedList = new JList<O>());
        
        selectedList.setName("selectedList");
        selectedList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__selectedList"));
        selectedList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedList"));
    }

    protected void createSelectedListMoveDownAction() {
        $objectMap.put("selectedListMoveDownAction", selectedListMoveDownAction = new JMenuItem());
        
        selectedListMoveDownAction.setName("selectedListMoveDownAction");
    }

    protected void createSelectedListMoveUpAction() {
        $objectMap.put("selectedListMoveUpAction", selectedListMoveUpAction = new JMenuItem());
        
        selectedListMoveUpAction.setName("selectedListMoveUpAction");
    }

    protected void createSelectedListPane() {
        $objectMap.put("selectedListPane", selectedListPane = new JScrollPane());
        
        selectedListPane.setName("selectedListPane");
    }

    protected void createSelectedListPopup() {
        $objectMap.put("selectedListPopup", selectedListPopup = new JPopupMenu());
        
        selectedListPopup.setName("selectedListPopup");
    }

    protected void createSelectedListRemoveAction() {
        $objectMap.put("selectedListRemoveAction", selectedListRemoveAction = new JMenuItem());
        
        selectedListRemoveAction.setName("selectedListRemoveAction");
        selectedListRemoveAction.setText(t("bean.action.selected.remove"));
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = true);
    }

    protected void createShowSelectPopupEnabled() {
        $objectMap.put("showSelectPopupEnabled", showSelectPopupEnabled = true);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFocusable(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new JPanel());
        
        topPanel.setName("topPanel");
        topPanel.setLayout(new BorderLayout());
    }

    protected void createUniverseList() {
        $objectMap.put("universeList", universeList = new JList<O>());
        
        universeList.setName("universeList");
        universeList.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__universeList"));
        universeList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__universeList"));
    }

    protected void createUniverseListPane() {
        $objectMap.put("universeListPane", universeListPane = new JScrollPane());
        
        universeListPane.setName("universeListPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        handler = new DoubleListHandler<>();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createFilterable();
        createShowDecorator();
        createShowReset();
        createShowSelectPopupEnabled();
        createHighlightFilterText();
        createModel();
        createReverseSort();
        createIndex();
        createIndexes();
        createSortGroup();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSelectedListPopup();
        createSelectedListMoveUpAction();
        createSelectedListMoveDownAction();
        createSelectedListRemoveAction();
        createBeforeFilterPanel();
        createTopPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createToolbarLeft();
        createResetFilter();
        createFilterFieldLabel();
        createFilterField();
        createUniverseListPane();
        createUniverseList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0,1));
        createDisplayDecorator();
        createReset();
        createAddAction();
        createRemoveAction();
        createSelectedListPane();
        createSelectedList();
        // inline creation of $Table0
        setName("$Table0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_UP_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedUpEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveUpAction.setEnabled(model.isSelectedUpEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedUpEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MOVE_DOWN_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedDownEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListMoveDownAction.setEnabled(model.isSelectedDownEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedDownEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_REMOVE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedListRemoveAction.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOP_PANEL_VISIBLE, true ,"filterable") {
        
            @Override
            public void processDataBinding() {
                topPanel.setVisible(isFilterable());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNIVERSE_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("universeModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    universeList.setModel(model.getUniverseModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("universeModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UNIVERSE_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                universeList.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISPLAY_DECORATOR_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                displayDecorator.setVisible(isShowDecorator());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISPLAY_DECORATOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                displayDecorator.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                reset.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addAction.setEnabled(model.isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ACTION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAction.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_COMPONENT_POPUP_MENU, true ,"showSelectPopupEnabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setComponentPopupMenu(handler.getSelectedListPopup(isShowSelectPopupEnabled()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedList.setModel(model.getSelectedModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                selectedList.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(beforeFilterPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(universeListPane, new GridBagConstraints(0, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(selectedListPane, new GridBagConstraints(2, 2, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToSelectedListPopup();
        addChildrenToTopPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(toolbarLeft, BorderLayout.WEST);
        $JPanel0.add(filterFieldLabel, BorderLayout.WEST);
        addChildrenToToolbarLeft();
        addChildrenToUniverseListPane();
        // inline complete setup of $JPanel1
        $JPanel1.add(displayDecorator);
        $JPanel1.add(reset);
        $JPanel1.add(addAction);
        $JPanel1.add(removeAction);
        addChildrenToSelectedListPane();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 11 property setters
        popup.setBorder(new TitledBorder(t("beandoublelist.popup.title")));
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterFieldLabel.setIcon(SwingUtil.getUIManagerActionIcon("doublelist-filter"));// late initializer
        
        DoubleListSelectedListMoveUpAction.init(this, selectedListMoveUpAction, DoubleListSelectedListMoveUpAction.class);
        DoubleListSelectedListMoveDownAction.init(this, selectedListMoveDownAction, DoubleListSelectedListMoveDownAction.class);
        DoubleListResetFilterAction.init(this, resetFilter, DoubleListResetFilterAction.class);
        DoubleListDisplayDecoratorAction.init(this, displayDecorator, DoubleListDisplayDecoratorAction.class);
        DoubleListResetAction.init(this, reset, DoubleListResetAction.class);
        DoubleListAddAction.init(this, addAction, DoubleListAddAction.class);
        DoubleListRemoveAction.init(this, removeAction, DoubleListRemoveAction.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
