/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.i18n;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.i18n.I18nEditor;

public class I18nEditorHandler
implements PropertyChangeListener,
ActionListener,
UIHandler<I18nEditor> {
    private static final Logger log = LogManager.getLogger(I18nEditorHandler.class);
    protected I18nEditor ui;
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n((String)"i18neditor.selected", (Object[])new Object[0]);
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n((String)"i18neditor.unselected", (Object[])new Object[0]);
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String SHOW_POPUP_ICON_PROPERTY = "showPopupIcon";
    public static final String SHOW_POPUP_TEXT_PROPERTY = "showPopupText";
    public static final String POPUP_BORDER_PROPERTY = "popupBorder";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    protected final Runnable showPopupRunnable = new Runnable(){

        @Override
        public void run() {
            I18nEditorHandler.this.ui.getPopup().pack();
            JToggleButton invoker = I18nEditorHandler.this.ui.getButton();
            Dimension dim = I18nEditorHandler.this.ui.getPopup().getPreferredSize();
            Dimension invokerDim = invoker.getSize();
            I18nEditorHandler.this.ui.getPopup().show(invoker, (int)(invokerDim.getWidth() - dim.getWidth()), invoker.getHeight());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">");
        }
        log.info(name + " <old:" + evt.getOldValue() + " - new:" + evt.getNewValue() + ">");
        if (LOCALES_PROPERTY.equals(name)) {
            Collection newLocales = (Collection)evt.getNewValue();
            boolean oldShowText = this.ui.renderer.isShowText();
            try {
                this.ui.renderer.setShowText(true);
                this.ui.popup.removeAll();
                for (Object o : newLocales) {
                    Locale l = (Locale)o;
                    boolean selected = l.equals(this.ui.selectedLocale);
                    String text = this.ui.isShowPopupText() != false ? this.ui.renderer.getText(l) : null;
                    Icon icon = this.ui.isShowPopupIcon() != false ? this.ui.renderer.getIcon(l) : null;
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(text, icon, selected);
                    this.ui.popup.add(b);
                    b.addActionListener(this.ui);
                    b.putClientProperty("locale", l);
                    b.setToolTipText(this.getTip(l));
                    b.putClientProperty("$buttonGroup", this.ui.getIndexes());
                    b.putClientProperty("$value", l);
                }
            }
            finally {
                this.ui.renderer.setShowText(oldShowText);
                this.ui.popup.invalidate();
            }
            return;
        }
        if (SHOW_ICON_PROPERTY.equals(name)) {
            this.ui.renderer.setShowIcon(((Boolean)evt.getNewValue()).booleanValue());
            this.ui.processDataBinding("button.icon");
            return;
        }
        if (SHOW_TEXT_PROPERTY.equals(name)) {
            this.ui.renderer.setShowText(((Boolean)evt.getNewValue()).booleanValue());
            this.ui.processDataBinding("button.text");
            return;
        }
        if (SHOW_POPUP_ICON_PROPERTY.equals(name)) {
            this.rebuildPopup();
            return;
        }
        if (SHOW_POPUP_TEXT_PROPERTY.equals(name)) {
            this.rebuildPopup();
            return;
        }
        if (POPUP_BORDER_PROPERTY.equals(name)) {
            this.ui.popup.setBorder((Border)evt.getNewValue());
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean)evt.getNewValue();
            if (newValue == null || !newValue.booleanValue()) {
                if (this.ui.getPopup() != null && this.ui.getPopup().isVisible()) {
                    this.ui.getPopup().setVisible(false);
                }
                return;
            }
            if (!this.ui.getPopup().isVisible()) {
                SwingUtilities.invokeLater(this.showPopupRunnable);
            }
            return;
        }
        if (SELECTED_LOCALE_PROPERTY.equals(name)) {
            Locale newLocale = (Locale)evt.getNewValue();
            try {
                for (Component c : this.ui.popup.getComponents()) {
                    if (!(c instanceof JRadioButtonMenuItem)) continue;
                    JRadioButtonMenuItem b = (JRadioButtonMenuItem)c;
                    Locale l = (Locale)b.getClientProperty("locale");
                    b.setSelected(newLocale.equals(l));
                }
            }
            finally {
                this.ui.popup.invalidate();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Locale value = (Locale)((JComponent)event.getSource()).getClientProperty("locale");
        if (log.isDebugEnabled()) {
            log.debug("new locale : " + value);
        }
        this.ui.setSelectedLocale(value);
    }

    public void loadI18nBundles() {
        Locale[] locales = I18n.getStore().getLocales();
        this.ui.setLocales(Arrays.asList(locales));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildPopup() {
        log.debug("start rebuild");
        try {
            for (Component c : this.ui.popup.getComponents()) {
                if (!(c instanceof JRadioButtonMenuItem)) continue;
                JRadioButtonMenuItem b = (JRadioButtonMenuItem)c;
                Locale l = (Locale)b.getClientProperty("locale");
                String text = this.ui.isShowPopupText() != false ? this.ui.renderer.getSafeText(l) : null;
                Icon icon = this.ui.isShowPopupIcon() != false ? this.ui.renderer.getSafeIcon(l) : null;
                b.setIcon(icon);
                b.setText(text);
                log.debug("text=" + text);
                log.debug("icon=" + icon);
            }
        }
        finally {
            this.ui.popup.invalidate();
        }
    }

    protected String getTip(Locale l) {
        boolean selected = l.equals(this.ui.selectedLocale);
        return selected ? this.getSelectedTip(l) : this.getNotSelectedTip(l);
    }

    protected String getSelectedTip(Locale l) {
        String selectedTip = this.ui.getSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        String tip = this.ui.renderer.getToolTipText(l);
        tip = I18n.t((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    protected String getNotSelectedTip(Locale l) {
        String selectedTip = this.ui.getNotSelectedToolTipText();
        if (selectedTip == null) {
            selectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        String tip = this.ui.renderer.getToolTipText(l);
        tip = I18n.t((String)selectedTip, (Object[])new Object[]{tip});
        return tip;
    }

    public void beforeInit(I18nEditor ui) {
        this.ui = ui;
    }

    public void afterInit(I18nEditor ui) {
        ui.addPropertyChangeListener(this);
    }
}

