/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import io.ultreia.java4all.lang.Setters;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.beanutils.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;
import org.nuiton.jaxx.widgets.gis.DmsCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditorModel;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormattedTextFieldNavigationManager;

public class AbsoluteDmsCoordinateEditorHandler
implements UIHandler<AbsoluteDmsCoordinateEditor> {
    private static final Logger log = LogManager.getLogger(AbsoluteDmsCoordinateEditorHandler.class);
    protected AbsoluteDmsCoordinateEditor ui;
    protected Method degreeMutator;
    protected Method minuteMutator;
    protected Method secondMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmsCoordinateConverter coordinateConverter;

    public void beforeInit(AbsoluteDmsCoordinateEditor ui) {
        this.ui = ui;
        this.coordinateConverter = new DmsCoordinateConverter();
    }

    public void afterInit(AbsoluteDmsCoordinateEditor ui) {
    }

    public void resetModel() {
        this.ui.getModel().reset();
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmsCoordinate> maskFormatter;
        AbsoluteDmsCoordinateEditorModel model = this.ui.getModel();
        Objects.requireNonNull(model.getBean(), "could not find bean in " + this.ui);
        Objects.requireNonNull(model.getPropertyDegree(), "could not find propertyDegree in " + this.ui);
        Objects.requireNonNull(model.getPropertyMinute(), "could not find propertyMinute in " + this.ui);
        Objects.requireNonNull(model.getPropertySecond(), "could not find propertySecond in " + this.ui);
        Object bean = model.getBean();
        this.degreeMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDegree());
        Objects.requireNonNull(this.degreeMutator, "could not find mutator for " + model.getPropertyDegree());
        this.minuteMutator = Setters.getMutator((Object)bean, (String)model.getPropertyMinute());
        Objects.requireNonNull(this.minuteMutator, "could not find mutator for " + model.getPropertyMinute());
        this.secondMutator = Setters.getMutator((Object)bean, (String)model.getPropertySecond());
        Objects.requireNonNull(this.secondMutator, "could not find mutator for " + model.getPropertySecond());
        this.coordinateConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.coordinateConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(maskFormatter);
        editor.setFormatterFactory(formatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", evt -> {
            DmsCoordinate newValue = (DmsCoordinate)((Object)((Object)evt.getNewValue()));
            if (log.isDebugEnabled()) {
                log.debug("Value has changed: " + newValue);
            }
            model.setValue(newValue);
        });
        JFormattedTextFieldNavigationManager.install((JFormattedTextField)editor);
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreeMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("second", new ModelPropertyChangeListener(model, this.secondMutator));
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.coordinateConverter.setFillWithZero(fillWithZero);
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        block5: {
            this.coordinateConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            if (log.isDebugEnabled()) {
                log.debug("setDisplayZeroWhenNull: " + displayZeroWhenNull);
            }
            AbsoluteDmsCoordinateEditorModel model = this.ui.getModel();
            JFormattedTextField editor = this.ui.getEditor();
            JFormattedTextField.AbstractFormatter formatter = editor.getFormatter();
            if (formatter != null) {
                try {
                    String newStringValue = formatter.valueToString((Object)model);
                    if (log.isDebugEnabled()) {
                        log.debug("updating string value: " + newStringValue);
                    }
                    editor.setText(newStringValue);
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Could not parse new string value", (Throwable)e);
                }
            }
        }
    }

    public void setValue(DmsCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor) {
        Object pattern = "**\u00b0**''**''''";
        if (longitudeEditor) {
            pattern = "*" + (String)pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final AbsoluteDmsCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(AbsoluteDmsCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbsoluteDmsCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    AbsoluteDmsCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke(this.model.getBean(), newValue);
                    }
                    finally {
                        AbsoluteDmsCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

