/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.signed;

import io.ultreia.java4all.lang.Setters;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.beanutils.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;
import org.nuiton.jaxx.widgets.gis.DmsCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.signed.SignedDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.signed.SignedDmsCoordinateEditorModel;

public class SignedDmsCoordinateEditorHandler
implements UIHandler<SignedDmsCoordinateEditor> {
    private static final Logger log = LogManager.getLogger(SignedDmsCoordinateEditorHandler.class);
    protected SignedDmsCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method minuteMutator;
    protected Method secondMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmsCoordinateConverter signedConverter;
    protected DmsCoordinateConverter unsignedConverter;
    protected DefaultFormatterFactory signedFormatterFactory;
    protected DefaultFormatterFactory unsignedFormatterFactory;

    public void beforeInit(SignedDmsCoordinateEditor ui) {
        this.ui = ui;
        this.signedConverter = new DmsCoordinateConverter();
        this.signedConverter.setUseSign(true);
        this.unsignedConverter = new DmsCoordinateConverter();
    }

    public void afterInit(SignedDmsCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmsCoordinate> maskFormatter;
        SignedDmsCoordinateEditorModel model = this.ui.getModel();
        Objects.requireNonNull(model.getBean(), "could not find bean in " + this.ui);
        Objects.requireNonNull(model.getPropertySign(), "could not find propertySign in " + this.ui);
        Objects.requireNonNull(model.getPropertyDegree(), "could not find propertyDegree in " + this.ui);
        Objects.requireNonNull(model.getPropertyMinute(), "could not find propertyMinute in " + this.ui);
        Objects.requireNonNull(model.getPropertySecond(), "could not find propertySecond in " + this.ui);
        Object bean = model.getBean();
        this.signMutator = Setters.getMutator((Object)bean, (String)model.getPropertySign());
        Objects.requireNonNull(this.signMutator, "could not find mutator for " + model.getPropertySign());
        this.degreMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDegree());
        Objects.requireNonNull(this.degreMutator, "could not find mutator for " + model.getPropertyDegree());
        this.minuteMutator = Setters.getMutator((Object)bean, (String)model.getPropertyMinute());
        Objects.requireNonNull(this.minuteMutator, "could not find mutator for " + model.getPropertyMinute());
        this.secondMutator = Setters.getMutator((Object)bean, (String)model.getPropertySecond());
        Objects.requireNonNull(this.secondMutator, "could not find mutator for " + model.getPropertySecond());
        this.signedConverter.setForLongitude(longitudeEditor);
        this.unsignedConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor, false);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.unsignedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.unsignedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        pattern = this.getMaskFormatterPattern(longitudeEditor, true);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.signedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.signedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(model.isSign() ? this.signedFormatterFactory : this.unsignedFormatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", evt -> {
            DmsCoordinate newValue = (DmsCoordinate)((Object)((Object)evt.getNewValue()));
            if (log.isDebugEnabled()) {
                log.debug("Value has changed: " + newValue);
            }
            model.setValue(newValue);
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("second", new ModelPropertyChangeListener(model, this.secondMutator));
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        block5: {
            this.signedConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            this.unsignedConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            if (log.isDebugEnabled()) {
                log.debug("setDisplayZeroWhenNull: " + displayZeroWhenNull);
            }
            SignedDmsCoordinateEditorModel model = this.ui.getModel();
            JFormattedTextField editor = this.ui.getEditor();
            JFormattedTextField.AbstractFormatter formatter = editor.getFormatter();
            if (formatter != null) {
                try {
                    String newStringValue = formatter.valueToString((Object)model);
                    if (log.isDebugEnabled()) {
                        log.debug("updating string value: " + newStringValue);
                    }
                    editor.setText(newStringValue);
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Could not parse new string value", (Throwable)e);
                }
            }
        }
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.signedConverter.setFillWithZero(fillWithZero);
        this.unsignedConverter.setFillWithZero(fillWithZero);
    }

    public void setValue(DmsCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFormatterFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")");
        }
        if (keyChar == '-') {
            DefaultFormatterFactory newFactory;
            DmsCoordinate value = (DmsCoordinate)((Object)source.getValue());
            boolean useSign = this.ui.getModel().isSign();
            if (useSign) {
                if (log.isDebugEnabled()) {
                    log.debug("Switch to unsigned");
                }
                newFactory = this.unsignedFormatterFactory;
                --caretPosition;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Switch to signed");
                }
                newFactory = this.signedFormatterFactory;
                ++caretPosition;
            }
            DmsCoordinate newValue = DmsCoordinate.valueOf(value);
            newValue.setSign(!useSign);
            source.setFormatterFactory(newFactory);
            source.setValue((Object)newValue);
            e.consume();
            source.setCaretPosition(caretPosition);
        }
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor, boolean useSign) {
        Object pattern = "**\u00b0**''**''''";
        if (longitudeEditor) {
            pattern = "*" + (String)pattern;
        }
        if (useSign) {
            pattern = "-" + (String)pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final SignedDmsCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(SignedDmsCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!SignedDmsCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    SignedDmsCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke(this.model.getBean(), newValue);
                    }
                    finally {
                        SignedDmsCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

