package org.nuiton.jaxx.widgets.gis.signed;

/*-
 * #%L
 * JAXX :: Widgets Gis
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.gis.DmdCoordinate;

public class SignedDmdCoordinateEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_RESET_BUTTON_TOOL_TIP_TEXT = "resetButton.toolTipText";
    public static final String BINDING_TOOLBAR_LEFT_ENABLED = "toolbarLeft.enabled";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTVMTQRDtBJJIAoqfBy9ShQiUsinPUCpfKaGCWIQDJRcn2Uky1GZmnJklS1Fy8ODNP+DBqxeL/0B5ssqLV/6DVfwEe3ZDNoQEUHPYJLPdr1+/6dfffkNKK3giVM3hPjOCOzskCBzlc8Ma1Fmd39paL+/QilmiuqKYNEJB9EkkIbkNObd9rg0420VEykdIeYuUbyHlF0VDCk55B9BsEbLa7HlU1yk1Bqb6Jle0zpfakbOB9FWrVk/WvWr9/Pj0OEGXPicBAon0M9j2478AiLseLEKSuQZuFXfILsl7hNeQnGK8hg2N2LNFj2j9ijToOziATBHSkigEMzDzT/KEcCFUIA3kqIvp6jXh1DMw191Ck7k1arRTY9rRrMap65TCr6WGuyiEchknhi6HGFKGsGkDQ7oumhtU22u4aVtwbFvOghAeJTyOG27HbSJHGI1DIwXiyFRDuJbg/P8QXLMYMWbOIJ8yUUVaRZ53bPHA0U2s66xu4qsFomzkkIEM5aTsUbedqSznBd8gDQO3z2RGpzbwbrtSOhLZwIMzoQWhGsQY6m7SwBQY9dzuegoe9RsqHGInHuJ4nhLbkFI+HhsY7+8fa4ENjIqGf7z/8NsyYeCHwwP1tXlyfDrx1uhjl2V1mBvHTyohqTLMcrsRjbtvmJdfI3J2G4eGergZQudPXsy81IpE9sgimjCL5Lwkuo5oqczx0fd7b38NQLIAWU8Qt0Bs/AqKW8e7qwvPDeTzFyG54eY1fI5amrHyBkb2mV6O/kxNvw9QpcmLVWqTOlw/+fHl08TRqVIJ5PjwKpmxWqk3kGbcY5yG26Fl/J7bICc19V0Ru7qXz0FK2TXGE+Fz+pwIA9h6GX1DcScwbqwUqSrxcN4hs8s0QwC8PRSndOpdlActX0WZDQnfRvGBbwvMhALYX3k4aznZcmI/IoMGsnhrTPCVirXZaKVt5xkV7Zahqqj4urNoqwSuE+sp9OY+bodSx5YJyQ6HeV399eTbYfTL+OL0pD2yJzAYrs+5KMZYmXEkXHt2Djphn9krIA6ySrRM1npj3EeMPzlZb5N2BwAA";
    private static final Logger log = LogManager.getLogger(SignedDmdCoordinateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JFormattedTextField editor;
    protected SignedDmdCoordinateEditor editorPanel;
    protected SignedDmdCoordinateEditorHandler handler;
    protected SignedDmdCoordinateEditorModel model;
    protected JButton resetButton;
    protected Boolean showReset;
    protected String showResetTip;
    protected JToolBar toolbarLeft;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(boolean longitudeEditor) { handler.init(longitudeEditor); }
    public void setBean(Object bean) { model.setBean(bean); }
    public void setPropertySign(String property ) { model.setPropertySign(property); }
    public void setPropertyDegree(String property ) { model.setPropertyDegree(property); }
    public void setPropertyMinute(String property ) { model.setPropertyMinute(property); }
    public void setPropertyDecimal(String property ) { model.setPropertyDecimal(property); }
    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) { handler.setDisplayZeroWhenNull(displayZeroWhenNull); }
    public void setFillWithZero(boolean fillWithZero) { handler.setFillWithZero(fillWithZero); }
    public void setValue(DmdCoordinate value) { handler.setValue(value, true); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SignedDmdCoordinateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SignedDmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SignedDmdCoordinateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SignedDmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SignedDmdCoordinateEditor() {
        $initialize();
    }

    public SignedDmdCoordinateEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SignedDmdCoordinateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public SignedDmdCoordinateEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetEditor();
    }

    public void doFocusGained__on__editorPanel(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.requestFocusInWindow();
    }

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JFormattedTextField getEditor() {
        return editor;
    }

    public SignedDmdCoordinateEditorHandler getHandler() {
        return handler;
    }

    public SignedDmdCoordinateEditorModel getModel() {
        return model;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowResetTip(String showResetTip) {
        String oldValue = this.showResetTip;
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        add(toolbarLeft, BorderLayout.WEST);
        add(editor, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetButton);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JFormattedTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new SignedDmdCoordinateEditorModel());
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowResetTip() {
        $objectMap.put("showResetTip", showResetTip = new String());
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        editorPanel = this;
        handler = new SignedDmdCoordinateEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editorPanel", editorPanel);
        createShowReset();
        createShowResetTip();
        createModel();
        createToolbarLeft();
        createResetButton();
        createEditor();
        // inline creation of editorPanel
        setName("editorPanel");
        setLayout(new BorderLayout());
        editorPanel.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__editorPanel"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_TOOL_TIP_TEXT, true ,"showResetTip") {
        
            @Override
            public void processDataBinding() {
                resetButton.setToolTipText(getShowResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorPanel();
        addChildrenToToolbarLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        resetButton.setIcon(SwingUtil.getUIManagerActionIcon("coordinate-reset"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
