/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import io.ultreia.java4all.lang.Setters;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.beanutils.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.gis.DdCoordinate;
import org.nuiton.jaxx.widgets.gis.DdCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormattedTextFieldNavigationManager;

public class AbsoluteDdCoordinateEditorHandler
implements UIHandler<AbsoluteDdCoordinateEditor> {
    private static final Logger log = LogManager.getLogger(AbsoluteDdCoordinateEditorHandler.class);
    private AbsoluteDdCoordinateEditor ui;
    protected Method degreeMutator;
    protected Method decimalMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DdCoordinateConverter coordinateConverter;

    public void beforeInit(AbsoluteDdCoordinateEditor ui) {
        this.ui = ui;
        this.coordinateConverter = new DdCoordinateConverter();
    }

    public void afterInit(AbsoluteDdCoordinateEditor ui) {
    }

    public void resetModel() {
        this.ui.getModel().reset();
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DdCoordinate> maskFormatter;
        AbsoluteDdCoordinateEditorModel model = this.ui.getModel();
        Objects.requireNonNull(model.getBean(), "could not find bean in " + this.ui);
        Objects.requireNonNull(model.getPropertyDegree(), "could not find propertyDegree in " + this.ui);
        Objects.requireNonNull(model.getPropertyDecimal(), "could not find propertyDecimal in " + this.ui);
        Object bean = model.getBean();
        this.degreeMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDegree());
        Objects.requireNonNull(this.degreeMutator, "could not find mutator for " + model.getPropertyDegree());
        this.decimalMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDecimal());
        Objects.requireNonNull(this.decimalMutator, "could not find mutator for " + model.getPropertyDecimal());
        this.coordinateConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DdCoordinate.class, pattern, (Converter)this.coordinateConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(maskFormatter);
        editor.setFormatterFactory(formatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", evt -> {
            DdCoordinate newValue = (DdCoordinate)((Object)((Object)evt.getNewValue()));
            if (log.isDebugEnabled()) {
                log.debug("Value has changed: " + (Object)((Object)newValue));
            }
            model.setValue(newValue);
        });
        JFormattedTextFieldNavigationManager.install((JFormattedTextField)editor);
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreeMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        block5: {
            this.coordinateConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            if (log.isDebugEnabled()) {
                log.debug("setDisplayZeroWhenNull: " + displayZeroWhenNull);
            }
            AbsoluteDdCoordinateEditorModel model = this.ui.getModel();
            JFormattedTextField editor = this.ui.getEditor();
            JFormattedTextField.AbstractFormatter formatter = editor.getFormatter();
            if (formatter != null) {
                try {
                    String newStringValue = formatter.valueToString((Object)model);
                    if (log.isDebugEnabled()) {
                        log.debug("updating string value: " + newStringValue);
                    }
                    editor.setText(newStringValue);
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error("Could not parse new string value", (Throwable)e);
                }
            }
        }
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.coordinateConverter.setFillWithZero(fillWithZero);
    }

    public void setValue(DdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor) {
        String pattern = "**.***";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final AbsoluteDdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(AbsoluteDdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbsoluteDdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    AbsoluteDdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke(this.model.getBean(), newValue);
                    }
                    finally {
                        AbsoluteDdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

