/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import io.ultreia.java4all.i18n.I18n;
import java.util.regex.Matcher;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.converter.NuitonConverter;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;

public class DmsCoordinateConverter
implements NuitonConverter<DmsCoordinate> {
    protected boolean useSign;
    protected boolean forLongitude;
    protected String nullValue = "";
    protected char fillChar = (char)32;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        this.nullValue = displayZeroWhenNull ? "0" : "";
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.fillChar = (char)(fillWithZero ? 48 : 32);
    }

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException(I18n.t((String)"jaxx.error.no.convertor.coordinateDms", (Object[])new Object[]{value}));
        }
        Object result = null;
        if (value == null) {
            if (aClass.equals(String.class)) {
                result = String.format("%s%s\u00b0%s'%s''", this.useSign ? "-" : "", StringUtils.leftPad((String)this.nullValue, (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)this.nullValue, (int)2, (char)' '), StringUtils.leftPad((String)this.nullValue, (int)2, (char)' '));
            }
        } else if (aClass.equals(value.getClass())) {
            result = value;
        } else if (value instanceof String) {
            Matcher matcher = DmsCoordinate.COORDINATE_PATTERN.matcher((String)value);
            if (matcher.matches()) {
                String degresStr = matcher.group(1).replaceAll("\\s", "");
                String minutesStr = matcher.group(2).replaceAll("\\s", "");
                String secondsStr = matcher.group(3).replaceAll("\\s", "");
                Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Integer.valueOf(Math.abs(Integer.valueOf(degresStr)));
                Integer minutes = minutesStr.isEmpty() ? null : Integer.valueOf(minutesStr);
                Integer seconds = secondsStr.isEmpty() ? null : Integer.valueOf(secondsStr);
                boolean signed = degresStr.contains("-");
                result = DmsCoordinate.valueOf(signed, degre, minutes, seconds);
            }
        } else if (value instanceof DmsCoordinate) {
            DmsCoordinate coordinate = (DmsCoordinate)((Object)value);
            boolean sign = coordinate.isSign();
            String signStr = sign ? "-" : "";
            Integer degree = coordinate.getDegree();
            String degreeStr = degree == null ? this.nullValue : degree.toString();
            Integer minute = coordinate.getMinute();
            String minuteStr = minute == null ? this.nullValue : minute.toString();
            Integer second = coordinate.getSecond();
            String secondStr = second == null ? this.nullValue : second.toString();
            result = String.format("%s%s\u00b0%s'%s''", signStr, StringUtils.leftPad((String)degreeStr, (int)(this.forLongitude ? 3 : 2), (char)(this.nullValue.equals(degreeStr) ? (char)' ' : (char)this.fillChar)), StringUtils.leftPad((String)minuteStr, (int)2, (char)(this.nullValue.equals(minuteStr) ? (char)' ' : (char)this.fillChar)), StringUtils.leftPad((String)secondStr, (int)2, (char)(this.nullValue.equals(secondStr) ? (char)' ' : (char)this.fillChar)));
        }
        return aClass.cast(result);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) || DmsCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<DmsCoordinate> getType() {
        return DmsCoordinate.class;
    }
}

