/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import io.ultreia.java4all.i18n.I18n;
import java.util.regex.Matcher;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.converter.NuitonConverter;
import org.nuiton.jaxx.widgets.gis.DdCoordinate;

public class DdCoordinateConverter
implements NuitonConverter<DdCoordinate> {
    protected boolean useSign;
    protected boolean forLongitude;
    protected String nullValue = "";
    protected char fillChar = (char)32;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        this.nullValue = displayZeroWhenNull ? "0" : "";
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.fillChar = (char)(fillWithZero ? 48 : 32);
    }

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException(I18n.t((String)"jaxx.error.no.convertor.coordinateDd", (Object[])new Object[]{value}));
        }
        Object result = null;
        if (value == null) {
            if (aClass.equals(String.class)) {
                result = String.format("%s%s.%s", this.useSign ? "-" : "", StringUtils.leftPad((String)this.nullValue, (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)this.nullValue, (int)3, (char)' '));
            }
        } else if (aClass.equals(value.getClass())) {
            result = value;
        } else if (value instanceof String) {
            Matcher matcher = DdCoordinate.COORDINATE_PATTERN.matcher((String)value);
            if (matcher.matches()) {
                Integer decimal;
                Integer degre;
                String degresStr = matcher.group(1).replaceAll("\\s", "");
                String decimalesStr = matcher.group(2).replaceAll("\\s", "");
                Integer n = degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Integer.valueOf(Math.abs(Integer.valueOf(degresStr)));
                if (decimalesStr.isEmpty()) {
                    decimal = null;
                } else {
                    decimalesStr = StringUtils.rightPad((String)decimalesStr, (int)3, (char)'0');
                    decimal = Integer.valueOf(decimalesStr);
                }
                boolean signed = degresStr.contains("-");
                result = DdCoordinate.valueOf(signed, degre, decimal);
            }
        } else if (value instanceof DdCoordinate) {
            String decimalStr;
            DdCoordinate coordinate = (DdCoordinate)((Object)value);
            boolean sign = coordinate.isSign();
            String signStr = sign ? "-" : "";
            Integer degree = coordinate.getDegree();
            String degreeStr = degree == null ? this.nullValue : degree.toString();
            Integer decimal = coordinate.getDecimal();
            if (decimal == null) {
                decimalStr = this.nullValue;
            } else {
                decimalStr = StringUtils.leftPad((String)decimal.toString(), (int)3, (char)'0');
                while (decimalStr.endsWith("0")) {
                    decimalStr = decimalStr.substring(0, decimalStr.length() - 1);
                }
            }
            result = String.format("%s%s.%s", signStr, StringUtils.leftPad((String)degreeStr, (int)(this.forLongitude ? 3 : 2), (char)(this.nullValue.equals(degreeStr) ? (char)' ' : (char)this.fillChar)), StringUtils.rightPad((String)decimalStr, (int)3, (char)(this.nullValue.equals(decimalStr) ? (char)' ' : (char)this.fillChar)));
        }
        return aClass.cast(result);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) || DdCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<DdCoordinate> getType() {
        return DdCoordinate.class;
    }
}

