package org.nuiton.jaxx.widgets.font;

/*-
 * #%L
 * JAXX :: Widgets Font
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static io.ultreia.java4all.i18n.I18n.t;

public class FontSizor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DEFAULT_FONT_SIZE = "defaultFontSize";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_SHOW_DEFAULT_FONT_SIZE = "showDefaultFontSize";
    public static final String PROPERTY_SHOW_FONT_SIZE = "showFontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEFAULT_SIZE_ENABLED = "defaultSize.enabled";
    public static final String BINDING_DEFAULT_SIZE_VISIBLE = "defaultSize.visible";
    public static final String BINDING_DOWN_SIZE_ENABLED = "downSize.enabled";
    public static final String BINDING_UP_SIZE_ENABLED = "upSize.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String BINDING_$JTOOL_BAR0_OPAQUE = "$JToolBar0.opaque";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5UW2oIoGEw0RgwoJOIuevEA8QeQRrEKEUwIvTjtTtshy84wM0sXDxw8ePMf8ODVi+F/IJ5MvHjlfzDhT/DN7pYFbLcr7WHbzr75zPd933vz/Q/KSIFmmKgbjksVc4wt7HmGcB1Ft4mx/HxjY6WyRapqiciqoFwxgYJPKo3SZVSwTtalQka5BCQzIJmaZIYkc5Ftc+YQ5xRoroTyUu3ZRDYIUQpNd9xcldJcO4mc87grwrPaqm531q9PD49SZOlLGiGPg/w8pH3/PwBR1n0llKaWQiOlLbyLTRs7dRAnqFOHhIb02qKNpXyDt8kO2kf9JZTlWABMoQcXssfH+SiPKzQwubyKHWLPKnTvvP4mtepESaPGHGUU4bFGPzDBub87q9CwRWrYtVX4isCK1mvoHIyizbCKYgdqYZD+fzlaH5UN1lw6z7kacRYYswl2oh2DekfxFG00epefXF6H+AUsIJ9rGuIZsgleGq11HZiLVFms6QRHjp6JXnAV2KCjxk6CC2G6rXNvnn2ddXmHN+BxCVd8j0fOnOKvhrHiX/9b/QP9akT9GrVOqowywoVlhSY6j4ru9rcQFfT5ROc+18f4gR8P9sW35vFRq7nHQNx4t12n5hg6jQvGiVBUaxsOOttV1DZfYz5XRjlJbLgE/CGfile+FkaCelAR9IUmGS+wbAAt0390+GPs/e9LKF1Eeeg5q4h1/EuUUw0BjjHb8vjTZ764weYAPK9omVAvG+8xKDO6PG9hhccr1LGgKk88cGkq3qUTUQcrxz+/fr572HIqBRonk+yM3Mpsoix1bOoQ/yIIZ7zt4Be4JK7FogFuN9Ip/Z3n4UxM+8+ZdvkPVZiwiFjF1FFEX0DzgYxxrOD6qbiKgBV696yfmP71yIdfTwDP1fT444rta398cVCWcbzj+hTz4pQ+Wg2muQPjRgJGP3F0PlaPmMEaq7oydD3GnCSsnM/q4nISUEHB7bhO+TrxVE8ovVyMcehWIsKrngmrMVkkI7zrmbDZEwEabpdKGta2JzPiCnK754IkI8QVJBkhriDJCHEF6U6AW0SF49HBiTuJVMguhL/TMhZ2RQsAAA==";
    private static final Logger log = LogManager.getLogger(FontSizor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Float defaultFontSize;
    protected JButton defaultSize;
    protected JButton downSize;
    protected Float fontSize;
    protected FontSizorHandler handler;
    protected Boolean showDefaultFontSize;
    protected Boolean showFontSize;
    protected JButton upSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private FontSizor $JPanel0;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init();
    }
    
    boolean updateDefaultSizeEnabled(Float fontSize, Float defaultFontSize, boolean enabled) {
       return handler.updateDefaultSizeEnabled( fontSize,defaultFontSize, enabled);
    }
    
    public void setCallBack(Runnable action) {
        handler.setCallBack(action);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FontSizor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor() {
        $initialize();
    }

    public FontSizor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FontSizor(boolean param0) {
        super(param0);
        $initialize();
    }

    public FontSizor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__defaultSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(defaultFontSize);
    }

    public void doActionPerformed__on__downSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(fontSize - 1);
    }

    public void doActionPerformed__on__upSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setFontSize(fontSize + 1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Float getDefaultFontSize() {
        return defaultFontSize;
    }

    public JButton getDefaultSize() {
        return defaultSize;
    }

    public JButton getDownSize() {
        return downSize;
    }

    public Float getFontSize() {
        return fontSize;
    }

    public FontSizorHandler getHandler() {
        return handler;
    }

    public Boolean getShowDefaultFontSize() {
        return showDefaultFontSize;
    }

    public Boolean getShowFontSize() {
        return showFontSize;
    }

    public JButton getUpSize() {
        return upSize;
    }

    public Boolean isShowDefaultFontSize() {
        return showDefaultFontSize !=null && showDefaultFontSize;
    }

    public Boolean isShowFontSize() {
        return showFontSize !=null && showFontSize;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDefaultFontSize(Float defaultFontSize) {
        Float oldValue = this.defaultFontSize;
        this.defaultFontSize = defaultFontSize;
        firePropertyChange(PROPERTY_DEFAULT_FONT_SIZE, oldValue, defaultFontSize);
    }

    public void setFontSize(Float fontSize) {
        Float oldValue = this.fontSize;
        this.fontSize = fontSize;
        firePropertyChange(PROPERTY_FONT_SIZE, oldValue, fontSize);
    }

    public void setShowDefaultFontSize(Boolean showDefaultFontSize) {
        Boolean oldValue = this.showDefaultFontSize;
        this.showDefaultFontSize = showDefaultFontSize;
        firePropertyChange(PROPERTY_SHOW_DEFAULT_FONT_SIZE, oldValue, showDefaultFontSize);
    }

    public void setShowFontSize(Boolean showFontSize) {
        Boolean oldValue = this.showFontSize;
        this.showFontSize = showFontSize;
        firePropertyChange(PROPERTY_SHOW_FONT_SIZE, oldValue, showFontSize);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDefaultFontSize() {
        $objectMap.put("defaultFontSize", defaultFontSize = 12f);
    }

    protected void createDefaultSize() {
        $objectMap.put("defaultSize", defaultSize = new JButton());
        
        defaultSize.setName("defaultSize");
        defaultSize.setFocusPainted(false);
        defaultSize.setFocusable(false);
        defaultSize.setToolTipText(t("fontsize.action.default.tip"));
        defaultSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__defaultSize"));
    }

    protected void createDownSize() {
        $objectMap.put("downSize", downSize = new JButton());
        
        downSize.setName("downSize");
        downSize.setFocusPainted(false);
        downSize.setFocusable(false);
        downSize.setToolTipText(t("fontsize.action.down.tip"));
        downSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downSize"));
    }

    protected void createFontSize() {
        $objectMap.put("fontSize", fontSize = null);
    }

    protected void createShowDefaultFontSize() {
        $objectMap.put("showDefaultFontSize", showDefaultFontSize = true);
    }

    protected void createShowFontSize() {
        $objectMap.put("showFontSize", showFontSize = false);
    }

    protected void createUpSize() {
        $objectMap.put("upSize", upSize = new JButton());
        
        upSize.setName("upSize");
        upSize.setFocusPainted(false);
        upSize.setFocusable(false);
        upSize.setToolTipText(t("fontsize.action.up.tip"));
        upSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__upSize"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JPanel0 = this;
        handler = new FontSizorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createDefaultFontSize();
        createFontSize();
        createShowDefaultFontSize();
        createShowFontSize();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        createDownSize();
        createDefaultSize();
        createUpSize();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_OPAQUE, true ,"opaque") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setOpaque(isOpaque());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DOWN_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                downSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_ENABLED, true ,"fontSize" ,"defaultFontSize" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setEnabled(updateDefaultSizeEnabled(getFontSize(), getDefaultFontSize(), isEnabled()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEFAULT_SIZE_VISIBLE, true ,"showDefaultFontSize") {
        
            @Override
            public void processDataBinding() {
                defaultSize.setVisible(isShowDefaultFontSize());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UP_SIZE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                upSize.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"fontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(SwingUtil.getStringValue(getFontSize()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"showFontSize") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(isShowFontSize());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.CENTER);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(downSize);
        $JToolBar0.add(defaultSize);
        $JToolBar0.add(upSize);
        $JToolBar0.add($JLabel0);
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 property setters
        downSize.setIcon(SwingUtil.getUIManagerActionIcon("font-size-down"));
        defaultSize.setIcon(SwingUtil.getUIManagerActionIcon("font-size"));
        upSize.setIcon(SwingUtil.getUIManagerActionIcon("font-size-up"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
