/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.file;

import io.ultreia.java4all.i18n.I18n;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.swing.JOptionPanes;
import org.nuiton.jaxx.widgets.file.JaxxFileChooser;

public class JaxxFileChoosers {
    private static final Logger log = LogManager.getLogger(JaxxFileChoosers.class);

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        JaxxFileChooser.ToLoadFile toLoadFile = JaxxFileChooser.forLoadingFile().setParent(parent).setTitle(title).setApprovalText(buttonLabel).setPatternOrDescriptionFilters(Arrays.asList(filters));
        File parentDirectoryIfExist = JaxxFileChoosers.getParentDirectoryIfExist(incoming);
        if (parentDirectoryIfExist != null) {
            toLoadFile.setStartDirectory(parentDirectoryIfExist);
        }
        File file = toLoadFile.choose();
        if (log.isDebugEnabled()) {
            log.debug(title + " : " + file);
        }
        return file == null ? incoming : file;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        JaxxFileChooser.ToLoadDirectory toLoadDirectory = JaxxFileChooser.forLoadingDirectory().setParent(parent).setTitle(title).setApprovalText(buttonLabel);
        File parentDirectoryIfExist = JaxxFileChoosers.getParentDirectoryIfExist(incoming);
        if (parentDirectoryIfExist != null) {
            toLoadDirectory.setStartDirectory(parentDirectoryIfExist);
        }
        File file = toLoadDirectory.choose();
        if (log.isDebugEnabled()) {
            log.debug(title + " : " + file);
        }
        return file;
    }

    private static File getParentDirectoryIfExist(File incoming) {
        File basedir;
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            return basedir;
        }
        return null;
    }

    public static boolean confirmOverwriteFileIfExist(Component parent, File file) {
        boolean write = true;
        if (file.exists()) {
            write = JOptionPanes.askUser((Component)parent, (String)I18n.t((String)"jaxx.file.overwrite.title", (Object[])new Object[0]), (Object)I18n.t((String)"jaxx.file.overwrite", (Object[])new Object[0]), (int)2, (Object[])new Object[]{I18n.t((String)"jaxx.file.overwrite.ok", (Object[])new Object[0]), I18n.t((String)"jaxx.file.overwrite.cancel", (Object[])new Object[0])}, (int)1) == 0;
        }
        return write;
    }
}

