/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra.datatips;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.nuiton.jaxx.widgets.extra.datatips.DataTipCell;

class TableDataTipCell
implements DataTipCell {
    private final JTable table;
    private final int rowIndex;
    private final int columnIndex;

    TableDataTipCell(JTable table, int rowIndex, int columnIndex) {
        this.table = table;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    @Override
    public boolean isSet() {
        return this.rowIndex >= 0 && this.columnIndex >= 0;
    }

    @Override
    public Rectangle getCellBounds() {
        return this.table.getCellRect(this.rowIndex, this.columnIndex, false);
    }

    @Override
    public Component getRendererComponent() {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(this.rowIndex, this.columnIndex);
        return this.table.prepareRenderer(cellRenderer, this.rowIndex, this.columnIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDataTipCell cellPosition = (TableDataTipCell)o;
        if (this.columnIndex != cellPosition.columnIndex) {
            return false;
        }
        return this.rowIndex == cellPosition.rowIndex;
    }

    public int hashCode() {
        int result = this.rowIndex;
        result = 29 * result + this.columnIndex;
        return result;
    }
}

