/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra.editor;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditorHelper {
    protected static final String UNDO_MANAGER = "UndoManager";

    protected static void addUndoRedoSupport(JEditorPane editor) {
        UndoManager undo = (UndoManager)editor.getClientProperty(UNDO_MANAGER);
        if (undo == null) {
            undo = new UndoManager();
            editor.putClientProperty(UNDO_MANAGER, undo);
            UndoAction undoAction = new UndoAction(undo);
            KeyStroke key = KeyStroke.getKeyStroke(90, 2);
            editor.getInputMap().put(key, "undo");
            editor.getActionMap().put("undo", undoAction);
            RedoAction redoAction = new RedoAction(undo);
            key = KeyStroke.getKeyStroke(90, 66);
            editor.getInputMap().put(key, "redo");
            editor.getActionMap().put("redo", redoAction);
        }
        Document doc = editor.getDocument();
        doc.addUndoableEditListener(undo);
    }

    protected static void removeUndoRedoSupport(JEditorPane editor) {
        UndoManager undo = (UndoManager)editor.getClientProperty(UNDO_MANAGER);
        if (undo != null) {
            Document doc = editor.getDocument();
            doc.removeUndoableEditListener(undo);
        }
    }

    static class RedoAction
    extends TextAction {
        private static final long serialVersionUID = 5508420642118093156L;
        private static final Log log = LogFactory.getLog(RedoAction.class);
        protected final UndoManager undo;

        RedoAction(UndoManager undo) {
            super("redo");
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undo.canRedo()) {
                    this.undo.redo();
                }
            }
            catch (CannotRedoException eee) {
                log.warn((Object)"Unable to redo: ", (Throwable)eee);
            }
        }
    }

    static class UndoAction
    extends TextAction {
        private static final long serialVersionUID = 14313252664900665L;
        private static final Log log = LogFactory.getLog(UndoAction.class);
        protected final UndoManager undo;

        UndoAction(UndoManager undo) {
            super("undo");
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undo.canUndo()) {
                    this.undo.undo();
                }
            }
            catch (CannotUndoException eee) {
                log.warn((Object)"Unable to undo: ", (Throwable)eee);
            }
        }
    }
}

