/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.extra.XMLGridParseConstraints;
import org.nuiton.util.Resource;
import org.xml.sax.SAXException;

public class XMLGridLayout
implements LayoutManager {
    private static final Log log = LogFactory.getLog(XMLGridLayout.class);
    private Map constraints;
    private GridBagLayout layout;
    private String layoutString;

    public XMLGridLayout(String layoutStringOrFile) {
        URL url = Resource.getURLOrNull((String)layoutStringOrFile);
        log.debug((Object)("ask: " + layoutStringOrFile + " url: " + url));
        if (url != null) {
            this.init(url);
        } else {
            this.init(layoutStringOrFile);
        }
    }

    public XMLGridLayout(URL url) {
        this.init(url);
    }

    protected void init(URL url) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            int c = -1;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException eee) {
            throw new RuntimeException("Error when reading file: " + url, eee);
        }
        this.init(sb.toString());
    }

    protected void init(String layoutString) {
        this.layout = new GridBagLayout();
        this.layoutString = layoutString;
        XMLGridParseConstraints parser = null;
        try {
            parser = new XMLGridParseConstraints();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        try {
            this.constraints = parser.parse(layoutString);
        }
        catch (SAXException e) {
            System.err.println(parser.getErrors());
            throw new RuntimeException("Invalid layout string: " + layoutString);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        GridBagConstraints constraint = (GridBagConstraints)this.constraints.get(name);
        if (constraint != null) {
            this.layout.addLayoutComponent(comp, constraint);
        } else {
            System.err.println("(XMLGridLayout) No constraint defined for name " + name);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.layout.removeLayoutComponent(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layout.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layout.minimumLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layout.layoutContainer(parent);
    }

    public GridBagConstraints getConstraint(String componentName) {
        return (GridBagConstraints)this.constraints.get(componentName);
    }

    public String getLayoutString() {
        return this.layoutString;
    }
}

