/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import io.ultreia.java4all.bean.AbstractJavaBean;
import java.util.function.Predicate;
import org.nuiton.jaxx.widgets.ModelToBean;

public class UnlimitedTimeEditorModel
extends AbstractJavaBean
implements ModelToBean {
    public static final String PROPERTY_TIME = "time";
    public static final String PROPERTY_HOURS = "hours";
    public static final String PROPERTY_MINUTES = "minutes";
    public static final String PROPERTY_VALUE_IS_ADJUSTING = "valueIsAdjusting";
    protected final boolean fillState = true;
    protected Object bean;
    protected String propertyTime;
    protected Integer time = null;
    protected boolean valueIsAdjusting;

    public String getPropertyTime() {
        return this.propertyTime;
    }

    public void setPropertyTime(String propertyTime) {
        Preconditions.checkState((boolean)true, (Object)"cant change *propertyTimeDate* property once the fillState is off.");
        this.propertyTime = propertyTime;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Preconditions.checkState((boolean)true, (Object)"cant change *bean* property once the fillState is off.");
        this.bean = bean;
    }

    public Integer getTime() {
        return this.time;
    }

    public void setTime(Integer time) {
        if (!this.isValueIsAdjusting()) {
            Integer oldHours = this.getHours();
            Integer oldMinutes = this.getMinutes();
            this.setTime(this.getHours(time), this.getMinutes(time));
            this.firePropertyChange(PROPERTY_HOURS, oldHours, this.getHours());
            this.firePropertyChange(PROPERTY_MINUTES, oldMinutes, this.getMinutes());
        }
    }

    public int getHours() {
        return this.getHours(this.time);
    }

    public void setHours(Integer hour) {
        if (!this.isValueIsAdjusting()) {
            Integer oldValue = this.getHours();
            this.setTime(hour, this.getMinutes());
            this.firePropertyChange(PROPERTY_HOURS, oldValue, hour);
        }
    }

    public int getMinutes() {
        return this.getMinutes(this.time);
    }

    public void setMinutes(Integer minutes) {
        if (!this.isValueIsAdjusting()) {
            Integer oldValue = this.getMinutes();
            this.setTime(this.getHours(), minutes);
            this.firePropertyChange(PROPERTY_MINUTES, oldValue, minutes);
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        boolean oldValue = this.isValueIsAdjusting();
        this.valueIsAdjusting = valueIsAdjusting;
        this.fireValueIsAdjusting(oldValue);
    }

    public int getHours(Integer time) {
        return time == null ? 0 : time / 60;
    }

    public int getMinutes(Integer time) {
        return time == null ? 0 : time % 60;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTime(Integer hour, Integer minute) {
        Integer oldTime = this.getTime();
        this.setValueIsAdjusting(true);
        try {
            this.time = hour == null || minute == null ? null : Integer.valueOf(hour * 60 + minute);
        }
        finally {
            this.setValueIsAdjusting(false);
            this.fireTime(oldTime);
        }
    }

    protected void fireTime(Integer oldTime) {
        this.firePropertyChange(PROPERTY_TIME, oldTime, this.getTime());
    }

    protected void fireValueIsAdjusting(boolean oldValue) {
        this.firePropertyChange(PROPERTY_VALUE_IS_ADJUSTING, oldValue, this.isValueIsAdjusting());
    }

    protected Predicate<UnlimitedTimeEditorModel> canUpdateBeanValuePredicate() {
        return input -> !this.isValueIsAdjusting();
    }
}

