/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Predicate;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.runtime.util.DateUtil;
import org.nuiton.jaxx.widgets.ModelToBean;

public class DateTimeEditorModel
extends AbstractSerializableBean
implements ModelToBean {
    public static final String PROPERTY_DAY_DATE = "dayDate";
    public static final String PROPERTY_TIME_DATE = "timeDate";
    public static final String PROPERTY_TIME_IN_MINUTES = "timeInMinutes";
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_TIME_EDITABLE = "timeEditable";
    public static final String PROPERTY_DATE_EDITABLE = "dateEditable";
    public static final String PROPERTY_VALUE_IS_ADJUSTING = "valueIsAdjusting";
    private static final long serialVersionUID = 1L;
    protected final boolean fillState = true;
    protected final Calendar calendar = new GregorianCalendar();
    protected Object bean;
    protected String propertyDayDate;
    protected String propertyTimeDate;
    protected String propertyDate;
    protected boolean dateEditable = true;
    protected boolean timeEditable = true;
    protected Date date;
    protected boolean valueIsAdjusting;

    public String getPropertyDayDate() {
        return this.propertyDayDate;
    }

    public void setPropertyDayDate(String propertyDayDate) {
        Preconditions.checkState((boolean)true, (Object)"cant change *propertyDayDate* property once the fillState is off.");
        this.propertyDayDate = propertyDayDate;
    }

    public String getPropertyTimeDate() {
        return this.propertyTimeDate;
    }

    public void setPropertyTimeDate(String propertyTimeDate) {
        Preconditions.checkState((boolean)true, (Object)"cant change *propertyTimeDate* property once the fillState is off.");
        this.propertyTimeDate = propertyTimeDate;
    }

    public String getPropertyDate() {
        return this.propertyDate;
    }

    public void setPropertyDate(String propertyDate) {
        Preconditions.checkState((boolean)true, (Object)"cant change *propertyDate* property once the fillState is off.");
        this.propertyDate = propertyDate;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        Preconditions.checkState((boolean)true, (Object)"cant change *bean* property once the fillState is off.");
        this.bean = bean;
    }

    public boolean isDateEditable() {
        return this.dateEditable;
    }

    public void setDateEditable(boolean dateEditable) {
        this.dateEditable = dateEditable;
        this.firePropertyChange(PROPERTY_DATE_EDITABLE, null, dateEditable);
    }

    public boolean isTimeEditable() {
        return this.timeEditable;
    }

    public void setTimeEditable(boolean timeEditable) {
        this.timeEditable = timeEditable;
        this.firePropertyChange(PROPERTY_TIME_EDITABLE, null, timeEditable);
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        boolean oldValue = this.isValueIsAdjusting();
        this.valueIsAdjusting = valueIsAdjusting;
        this.fireValueIsAdjusting(oldValue);
    }

    void reset() {
        Date oldDate = this.date;
        if (this.isTimeEditable()) {
            this.setTime(new Date(0L), 0, 0);
        }
        this.setValueIsAdjusting(true);
        try {
            this.date = this.isDateEditable() ? null : this.getDayDate();
            this.firePropertyChange(PROPERTY_TIME_IN_MINUTES, oldDate, 0);
            this.firePropertyChange(PROPERTY_DATE, oldDate, null);
            this.firePropertyChange(PROPERTY_TIME_DATE, oldDate, null);
            this.firePropertyChange(PROPERTY_DAY_DATE, oldDate, null);
            this.firePropertyChange(PROPERTY_DATE, oldDate, null);
        }
        finally {
            this.setValueIsAdjusting(false);
        }
        this.fireDate(oldDate);
    }

    public void setHour(Integer hour) {
        if (this.isValueIsAdjusting()) {
            return;
        }
        Date oldTimeDate = this.getTimeDate();
        if (oldTimeDate != null) {
            Integer minute = this.getMinute(oldTimeDate);
            this.setTime(oldTimeDate, hour, minute);
        }
    }

    public void setMinute(Integer minute) {
        if (this.isValueIsAdjusting()) {
            return;
        }
        Date oldTimeDate = this.getTimeDate();
        if (oldTimeDate != null) {
            Integer hour = this.getHour(oldTimeDate);
            this.setTime(oldTimeDate, hour, minute);
        }
    }

    public Integer getTimeInMinutes() {
        Integer result = 0;
        Date timeDate = this.getTimeDate();
        if (timeDate != null) {
            int hour = this.getHour(timeDate);
            int minute = this.getMinute(timeDate);
            result = hour * 60 + minute;
        }
        return result;
    }

    public void setTimeInMinutes(Integer time) {
        if (this.isValueIsAdjusting()) {
            return;
        }
        Date oldTimeDate = this.getTimeDate();
        if (oldTimeDate != null) {
            int hour = time / 60;
            int minute = time % 60;
            this.setTime(oldTimeDate, hour, minute);
        }
    }

    public Date getTimeDate() {
        return this.date == null ? null : DateUtil.getTime((Date)this.date, (boolean)false, (boolean)false);
    }

    public void setTimeDate(Date timeDate) {
        if (this.date != null) {
            Date oldDate = this.date;
            Date oldTimeDate = this.getTimeDate();
            Integer oldTimeInMinutes = this.getTimeInMinutes();
            this.date = DateUtil.getDateAndTime((Date)this.date, (Date)timeDate, (boolean)true, (boolean)false);
            this.fireDate(oldDate);
            this.fireTimeDate(oldTimeDate);
            this.fireTimeInMinutes(oldTimeInMinutes);
        }
    }

    public Date getDayDate() {
        return this.date == null ? null : DateUtil.getDay((Date)this.date);
    }

    public void setDayDate(Date dayDate) {
        Date oldDate = this.date;
        Date oldDayDate = this.getDayDate();
        if (this.date == null) {
            this.date = dayDate;
            oldDayDate = null;
        }
        this.date = DateUtil.getDateAndTime((Date)dayDate, (Date)this.date, (boolean)true, (boolean)false);
        this.fireDate(oldDate);
        this.fireDayDate(oldDayDate);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date oldValue = this.getDate();
        if (Objects.equals(date, oldValue)) {
            return;
        }
        Date oldDayDate = this.getDayDate();
        Date oldTimeDate = this.getTimeDate();
        Integer oldTimeInMinutes = this.getTimeInMinutes();
        this.date = date;
        this.fireDate(oldValue);
        this.fireDayDate(oldDayDate);
        this.fireTimeDate(oldTimeDate);
        this.fireTimeInMinutes(oldTimeInMinutes);
    }

    protected Integer getDay(Date date) {
        Integer hour = null;
        if (date != null) {
            this.calendar.setTime(date);
            hour = this.calendar.get(5);
        }
        return hour;
    }

    protected Integer getHour(Date date) {
        Integer hour = null;
        if (date != null) {
            this.calendar.setTime(date);
            hour = this.calendar.get(11);
        }
        return hour;
    }

    protected Integer getMinute(Date date) {
        Integer hour = null;
        if (date != null) {
            this.calendar.setTime(date);
            hour = this.calendar.get(12);
        }
        return hour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTime(Date oldTimeDate, Integer hour, Integer minute) {
        if (oldTimeDate != null) {
            Date oldFullDate = this.getDate();
            Integer oldTimeInMinutes = this.getTimeInMinutes();
            this.setValueIsAdjusting(true);
            try {
                this.calendar.setTime(oldTimeDate);
                this.calendar.set(11, hour);
                this.calendar.set(12, minute);
                Date newTimeDate = this.calendar.getTime();
                this.setTimeDate(newTimeDate);
            }
            finally {
                this.setValueIsAdjusting(false);
                this.fireDate(oldFullDate);
                this.fireTimeDate(oldTimeDate);
                this.fireTimeInMinutes(oldTimeInMinutes);
            }
        }
    }

    protected void fireTimeDate(Date oldDate) {
        this.firePropertyChange(PROPERTY_TIME_DATE, oldDate, this.getTimeDate());
    }

    protected void fireTimeInMinutes(Integer oldDate) {
        this.firePropertyChange(PROPERTY_TIME_IN_MINUTES, oldDate, this.getTimeInMinutes());
    }

    protected void fireDayDate(Date oldDate) {
        this.firePropertyChange(PROPERTY_DAY_DATE, oldDate, this.getDayDate());
    }

    protected void fireDate(Date oldDate) {
        this.firePropertyChange(PROPERTY_DATE, oldDate, this.getDate());
    }

    protected void fireValueIsAdjusting(boolean oldValue) {
        this.firePropertyChange(PROPERTY_VALUE_IS_ADJUSTING, oldValue, this.isValueIsAdjusting());
    }

    protected Predicate<DateTimeEditorModel> canUpdateBeanValuePredicate() {
        return input -> !this.isValueIsAdjusting();
    }
}

