/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.BeanUIUtil;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;
import org.nuiton.jaxx.widgets.datetime.TimeEditorModel;
import org.nuiton.jaxx.widgets.datetime.TimeSliderInitializer;

public class TimeEditorHandler
extends BeanUIHandlerSupport<TimeEditor>
implements UIHandler<TimeEditor> {
    private static final Logger log = LogManager.getLogger(TimeEditorHandler.class);
    protected final Calendar calendarMinute = new GregorianCalendar();
    protected final Calendar calendarHour = new GregorianCalendar();

    public void beforeInit(TimeEditor ui) {
        super.beforeInit((JComponent)ui);
        TimeEditorModel model = new TimeEditorModel();
        ui.setContextValue(model);
    }

    public void afterInit(TimeEditor ui) {
        ui.getMinuteEditor().setEditor(new JSpinner.DateEditor(ui.getMinuteEditor(), "mm"));
        ui.getHourEditor().setEditor(new JSpinner.DateEditor(ui.getHourEditor(), "HH"));
        JSlider slider = ui.getSlider();
        TimeSliderInitializer timeSliderInitializer = new TimeSliderInitializer();
        timeSliderInitializer.init(slider);
    }

    protected String getProperty(TimeEditor ui) {
        return ui.getModel().getPropertyTime();
    }

    protected void prepareInit(String property) {
        log.debug(String.format("%s - init TimeEditor", ((TimeEditor)this.ui).getName()));
        if (property == null || property.isEmpty()) {
            ((TimeEditor)this.ui).setPropertyTime(((TimeEditor)this.ui).getName());
        }
        if (BeanUIUtil.isAutoSelectOnFocus((JComponent)this.ui)) {
            BeanUIUtil.addAutoSelectOnFocus((JSpinner.DateEditor)((JSpinner.DateEditor)((TimeEditor)this.ui).getHourEditor().getEditor()));
            BeanUIUtil.addAutoSelectOnFocus((JSpinner.DateEditor)((JSpinner.DateEditor)((TimeEditor)this.ui).getMinuteEditor().getEditor()));
        }
    }

    protected void prepareBindFromBean(String property, JavaBean bean) {
        TimeEditorModel model = ((TimeEditor)this.ui).getModel();
        bean.addPropertyChangeListener(property, e -> {
            Date newValue;
            Date oldValue = model.getTime();
            if (!Objects.equals(oldValue, newValue = (Date)e.getNewValue())) {
                ((TimeEditor)this.ui).setTime(newValue);
            }
        });
    }

    protected void prepareBindToBean(String property, JavaBean bean) {
        TimeEditorModel model = ((TimeEditor)this.ui).getModel();
        Predicate<TimeEditorModel> predicate = model.canUpdateBeanValuePredicate();
        model.addPropertyChangeListener("time", event -> {
            if (predicate.test(model)) {
                Date newValue = (Date)event.getNewValue();
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((TimeEditor)this.ui).getName(), property, newValue));
                bean.set(property, (Object)newValue);
            }
        });
    }

    public Date getMinuteModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarMinute.setTime(incomingDate);
        this.calendarMinute.set(11, 0);
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public Date getHourModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarHour.setTime(incomingDate);
        this.calendarHour.set(12, 0);
        incomingDate = this.calendarHour.getTime();
        return incomingDate;
    }

    public void reset() {
        ((TimeEditor)this.ui).getHourEditor().setValue(new Date(0L));
        ((TimeEditor)this.ui).getMinuteEditor().setValue(new Date(0L));
        ((TimeEditor)this.ui).getModel().setTime(null);
    }

    public void setHours(Date hourDate) {
        TimeEditorModel model = ((TimeEditor)this.ui).getModel();
        Date oldTime = model.getTime();
        if (oldTime == null) {
            return;
        }
        this.calendarHour.setTime(hourDate);
        int newHour = this.calendarHour.get(11);
        int newMinute = this.calendarHour.get(12);
        int oldHour = model.getHour(oldTime);
        int oldMinute = model.getMinute(oldTime);
        if (oldHour == newHour && oldMinute == newMinute) {
            log.debug(String.format("Do not update time model , stay on same time = %d:%d", oldHour, oldMinute));
            return;
        }
        log.debug(String.format("hh:mm (old from dateModel)   = %d:%d", oldHour, oldMinute));
        log.debug(String.format("hh:mm (new from hourModel) = %d:%d", newHour, newMinute));
        model.setTimeInMinutes(newHour * 60 + oldMinute);
    }

    public void setMinutes(Date minuteDate) {
        TimeEditorModel model = ((TimeEditor)this.ui).getModel();
        Date oldTime = model.getTime();
        if (oldTime == null) {
            return;
        }
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = model.getHour(oldTime);
        int oldMinute = model.getMinute(oldTime);
        if (oldHour == newHour && oldMinute == newMinute) {
            log.debug(String.format("Do not update time model , stay on same time = %d:%d", oldHour, oldMinute));
            return;
        }
        int hour = oldHour;
        log.debug(String.format("hh:mm (old from dateModel)   = %d:%d", oldHour, oldMinute));
        log.debug(String.format("hh:mm (new from minuteModel) = %d:%d", newHour, newMinute));
        if (newMinute == 0) {
            if (newHour == 1) {
                hour = (oldHour + 1) % 24;
            }
        } else if (newMinute == 59 && newHour == 23) {
            hour = (oldHour - 1) % 24;
        }
        log.debug(String.format("Update time model to hh:mm = %d:%d", hour, newMinute));
        model.setTimeInMinutes(hour * 60 + newMinute);
    }
}

