/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.jaxx.widgets.BeanUIHandlerSupport;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.nuiton.jaxx.widgets.BeanUIUtil;
import org.nuiton.jaxx.widgets.datetime.BeanDateEditor;

public class BeanDateEditorHandler
extends BeanUIHandlerSupport<BeanDateEditor> {
    private static final Logger log = LogManager.getLogger(BeanDateEditorHandler.class);

    protected String getProperty(BeanDateEditor ui) {
        return ui.getProperty();
    }

    protected void prepareInit(String property) {
        log.debug(String.format("%s - init BeanDateEditor", ((BeanDateEditor)((Object)this.ui)).getName()));
        if (property == null || property.isEmpty()) {
            ((BeanDateEditor)((Object)this.ui)).setProperty(((BeanDateEditor)((Object)this.ui)).getName());
        }
        ((BeanDateEditor)((Object)this.ui)).getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), "none");
        JFormattedTextField formattedTextField = ((BeanDateEditor)((Object)this.ui)).getEditor();
        formattedTextField.setEditable(true);
        JXMonthView monthView = new JXMonthView();
        monthView.setLowerBound(new Date(0L));
        monthView.setTraversable(true);
        monthView.setZoomable(true);
        ((BeanDateEditor)((Object)this.ui)).setMonthView(monthView);
        if (BeanUIUtil.isAutoSelectOnFocus((JComponent)this.ui)) {
            BeanUIUtil.addAutoSelectOnFocus((JTextField)formattedTextField);
            formattedTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JFormattedTextField source = (JFormattedTextField)e.getSource();
                    if (source.isEditValid()) {
                        try {
                            ((BeanDateEditor)((Object)BeanDateEditorHandler.this.ui)).commitEdit();
                            log.debug("quit date editor, commit value: " + source.getValue());
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    super.focusLost(e);
                }
            });
        }
    }

    protected void prepareBindFromBean(String property, JavaBean bean) {
        bean.addPropertyChangeListener(property, e -> {
            Date newValue;
            Date oldValue = ((BeanDateEditor)((Object)((Object)this.ui))).getDate();
            if (!Objects.equals(oldValue, newValue = (Date)e.getNewValue())) {
                log.debug(String.format("%s - [%s] get new value from bean: %s", ((BeanDateEditor)((Object)((Object)this.ui))).getName(), property, newValue));
                ((BeanDateEditor)((Object)((Object)this.ui))).setDate(newValue);
            }
        });
    }

    protected void prepareBindToBean(String property, JavaBean bean) {
        ((BeanDateEditor)((Object)this.ui)).addActionListener(e -> {
            JXDatePicker source = (JXDatePicker)e.getSource();
            Date newValue = source.getDate();
            if (bean == null) {
                return;
            }
            if (!Objects.equals(newValue, bean.get(property))) {
                log.debug(String.format("%s - [%s] set new value to bean: %s", ((BeanDateEditor)((Object)((Object)this.ui))).getName(), property, newValue));
                bean.set(property, (Object)newValue);
            }
        });
    }
}

